/************************************************
*                                               *
*       Back Propergation Simurator(BPS)        *
*             subroutine package                *
*               Version 			*
*         coded        	in Nuv.10 1990		*
*         coded by      K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename trace.c                        *
*            trace of network 			*
*                                               *
*************************************************/
#define _BPS_TRACE_

#include "BPS.h"
#include "BPStrace.h"

float	BoxWidth;
float	XPlus;
float	YPlus;
float	XLeng;
float	XLengHalf;
float	MinScale;
float	MaxScale;
char	DisplayMode = 0;

static	char	*LayerName[] = {
		"INPUT LAYER", "OUTPUT LAYER", "TEACH DATA", "HIDDEN LAYER" };

#define	K	1.5
#define	W	7.0	

/************************************************
  draw network structure
  ************************************************/
void
DrawNetwork(mode)
     int mode;
{
  int	 lay, datapoint, i, unit, unit_to, unit_from, nx, ny;
  int    max_num_unit, bias;
  float	 hx, hy, gx_point, gy_point, gx_to, gx_from, w, x, gx_increase;
  float  box_width_half, *sigmoid_data, next_gx_point, next_gy_point;
  char	 no[5], layer_name[MAX_LAYER][20];
  
  /* SET PARAMETERS */
  DisplayMode  = (char)mode;
  max_num_unit = 0;
  bias = 0;
  for (lay=0; lay<NumOfLayer; lay++){
    if (NumOfCell[lay] > max_num_unit) max_num_unit = NumOfCell[lay];
    if (CheckBias(lay)) bias = 1;
  }
  nx = (max_num_unit + bias) * 2 - 1; 
  ny = NumOfLayer * 3 - 2;
  hx = GpmCont.xSize / (float)nx;
  hy = GpmCont.ySize / (float)ny;
  if (hx < hy){
    BoxWidth = hx;
    XPlus = hx;
    YPlus = (GpmCont.ySize - NumOfLayer * hx) / (NumOfLayer - 1);
  }
  else {
    BoxWidth = hy;
    XPlus = (GpmCont.xSize - (max_num_unit + bias) * hy)
      / (max_num_unit + bias - 1);
    YPlus = hy * 2;
  }
  box_width_half = BoxWidth / 2;
  
  if (bias) XLeng = GpmCont.xSize - BoxWidth - XPlus; 
  else XLeng = GpmCont.xSize;
  XLengHalf = XLeng / 2;
  
  /* SET LAYERNAME */
  strcpy(layer_name[0], LayerName[0]);
  strcpy(layer_name[NumOfLayer-1], LayerName[1]);
  if (NumOfLayer > 3){
    for (lay=1; lay<NumOfLayer-1; lay++){
      strcpy(layer_name[lay], LayerName[3]);
      sprintf(no, " %d", lay);
      strcat(layer_name[lay], no);
    }
  }
  else	strcpy(layer_name[1], LayerName[3]);
  
  /* SET SIGMOID DATA */
  datapoint = BoxWidth * K;
  gx_increase = BoxWidth / (float)datapoint;
  sigmoid_data = (float *)malloc((datapoint + 1) * sizeof(float));
  if (sigmoid_data == NULL) exit(46);
  
  w = (W * 2) / (float)datapoint;
  for (i=0; i<=datapoint; i++){
    x = -W + i * w; 
    sigmoid_data[i] = box_width_half / 2 + Sigmoid(x) * box_width_half;
  }	
  
  /* DRAW NETWORK */
  gnewpen(GpmCont.fColor);
  gpen(GpmCont.fLineWidth,GpmCont.fLineType, 0);
  gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
  gfactor(GpmCont.factor);
  
  /* DRAW BOX */
  gx_point = 0.0;	
  gy_point = 0.0;
  for (lay=0; lay<NumOfLayer; lay++){
    gx_point = (GpmCont.xSize - XLeng) + XLengHalf
      - (NumOfCell[lay]*BoxWidth + (NumOfCell[lay]-1)*XPlus)/2;	
    for (unit=1; unit<=NumOfCell[lay]; unit++){
#if 0
      printf("\n"); /* for avoiding error of rec command on FreeBSD */
		      /* I did not understand reason of this error */
		      /* 		22,Aug.,96'	by A.I 	*/	
#endif
      gbox(gx_point, gy_point, gx_point+BoxWidth, gy_point+BoxWidth, 1, -1.0);
      if (DisplayMode != NETWORK_ONLY){
	/* DRAW FUNCTION MARK */
	switch(FuncBias[lay][0]){
	  /* SIGMOID */
	case SIGMOID :
	  next_gx_point = gx_point;
	  next_gy_point = gy_point + sigmoid_data[0];
	  gplot(next_gx_point, next_gy_point, 0);	
	  for (i=1; i<=datapoint; i++) {
	    next_gx_point += gx_increase;
	    next_gy_point = gy_point + sigmoid_data[i];
	    gplot(next_gx_point, next_gy_point, 2);
	  }
	  break;
	  
	  /* LINEAR */
	case LINEAR :
	  gplot(gx_point, gy_point, 0);
	  gplot(gx_point+BoxWidth, gy_point+BoxWidth, 2);
	  break;
	default :
	  break;
	}
      }
      gx_point += BoxWidth + XPlus;	
    }
    
    gnewpen(GpmCont.fColor);
    if (lay+1 != NumOfLayer){
      if (CheckBias(lay+1)){
#if 0
	printf("\n"); /* for avoiding error on FreeBSD */
#endif
	gbox(0.0, gy_point+BoxWidth+YPlus/4, BoxWidth,
	     gy_point+BoxWidth*2+YPlus/4, 1, -1.0); 
	}
    }	
    gy_point += BoxWidth + YPlus;
  }
  
  /* DRAW LINE */
  gy_point = BoxWidth; 
  
  for (lay=1; lay<NumOfLayer; lay++){
    gx_to = (GpmCont.xSize-XLeng) + XLengHalf
      - (NumOfCell[lay]*BoxWidth + (NumOfCell[lay]-1)*XPlus)/2;	
    for (unit_to=1; unit_to<=NumOfCell[lay]; unit_to++){
      if (CheckBias(lay)){
	gplot(box_width_half, gy_point+BoxWidth+YPlus/4, 0);
	gplot(gx_to+box_width_half, gy_point+YPlus, 2);
      }
      
      gx_from = (GpmCont.xSize-XLeng) + XLengHalf
	- (NumOfCell[lay-1]*BoxWidth + (NumOfCell[lay-1]-1)*XPlus)/2;
      for (unit_from=1; unit_from<=NumOfCell[lay-1]; unit_from++){
	gplot(gx_from+box_width_half, gy_point, 0);
	gplot(gx_to+box_width_half, gy_point+YPlus, 2);
	gx_from += BoxWidth + XPlus;
      }
      
      gx_to += BoxWidth + XPlus;
    }
    gy_point += BoxWidth + YPlus;
  }
  
  free(sigmoid_data);
  gflush();
}

/************************************************
  draw teach data
  ************************************************/
void
DrawTeachData()
{
  int	unit;
  float	gx_point, gy_point;
  
  gnewpen(GpmCont.fColor);
  gpen(GpmCont.fLineWidth,GpmCont.fLineType, 0);
  gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
  gfactor(GpmCont.factor);
  
  gy_point = GpmCont.ySize + BoxWidth;
  gx_point = (GpmCont.xSize-XLeng) + XLengHalf
    - (NumOfCell[NumOfLayer-1]*BoxWidth + (NumOfCell[NumOfLayer-1]-1)*XPlus)/2;
  
  for (unit=1; unit<=NumOfCell[NumOfLayer-1]; unit++){ 
    gbox(gx_point, gy_point, gx_point+BoxWidth, gy_point+BoxWidth, 1, -1.0);
    gx_point += BoxWidth + XPlus;	
  }
  
  gnewpen(GpmCont.gColor);
  gflush();
}

double
norm_color(data)
     double  data;
    /************************************************
      normalize data
      ************************************************/
{
  double  level;
  
  level = (data - MinScale) / (MaxScale - MinScale);
  return level;
  
}

double
norm_size(data)
     double  data;
    /************************************************
      normalize data
      ************************************************/
{
  double  level, max, min;
  
  if ((MinScale < 0) && (MaxScale > 0)){
    max = (double)((-MinScale < MaxScale) ? MaxScale : -MinScale);
    min = 0.0;
    level = (data - min) / (max - min);

    if (level >  1.0) return  1.0;
    if (level < -1.0) return -1.0;
    
    return level;
  }	
  level = (data - MinScale) / (MaxScale - MinScale);

  if (level > 1.0) return 1.0;
  if (level < 0.0) return 0.0;
  
  return level;
  
}

/************************************************
  count size
  ************************************************/
void
size(x1, y1, x2, y2, level)
     double x1, y1, x2, y2, level;
{
  double size, size_delta;
  
  if (level > 0){
    gnewpen(2);
    size = BoxWidth * level;
  }
  else{
    gnewpen(1);
    size = BoxWidth * -level;
  }
  size_delta = (BoxWidth - size) / 2;
  gbox(x1+size_delta, y1+size_delta,
       x1+size_delta+size, y1+size_delta+size, 2, -1.0);
}


/************************************************
  draw teach data
  ************************************************/
void
draw_teach(teach_data)
     double  teach_data[];
{
  int	unit;
  float	gx_point, gy_point, level;
  
  gy_point = GpmCont.ySize + BoxWidth;
  gx_point = (GpmCont.xSize - XLeng) + XLengHalf
    - (NumOfCell[NumOfLayer-1]*BoxWidth + (NumOfCell[NumOfLayer-1]-1)*XPlus)/2;
  
  for (unit=0; unit<NumOfCell[NumOfLayer-1]; unit++){ 
    if (DisplayMode == COLOR){
      level = norm_color(teach_data[unit]);
      grainbow(level);
      gbox(gx_point, gy_point,
	   gx_point+BoxWidth, gy_point+BoxWidth, 2, level);
      gnewpen(GpmCont.fColor);
      gbox(gx_point, gy_point, gx_point+BoxWidth, gy_point+BoxWidth, 1,-1.0);
    }
    else {
      level = norm_size(teach_data[unit]);
      gnewpen(0);
      gbox(gx_point, gy_point, gx_point+BoxWidth, gy_point+BoxWidth, 2,-1.0);
      size(gx_point, gy_point, gx_point+BoxWidth, gy_point+BoxWidth, level);
      gnewpen(GpmCont.fColor);
      gbox(gx_point, gy_point, gx_point+BoxWidth, gy_point+BoxWidth, 1,-1.0);
    }
    gx_point += BoxWidth + XPlus;	
  }
}

/************************************************
  draw box of network structure
  ************************************************/
void
DrawBox(ptrn_no, teach_flag, inlayer, outlayer)
    int  ptrn_no;
    int  teach_flag;
    int  inlayer; 
    int  outlayer;
{
  int	   lay, unit;
  double   gx_point, gy_point, level;
  cel_t   *cell_pt = NULL;
  
  gnewpen(GpmCont.fColor);
  gpen(GpmCont.fLineWidth,GpmCont.fLineType, 0);
  gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
  gfactor(GpmCont.factor);
  
  gx_point = 0.0;	
  gy_point = 0.0;
  
  for (lay=0; lay<NumOfLayer; lay++){
    gx_point = (GpmCont.xSize - XLeng) + XLengHalf
      - (NumOfCell[lay]*BoxWidth + (NumOfCell[lay]-1)*XPlus) / 2;	
    if ((inlayer <= lay) && (lay <= outlayer)){ 
      for (unit=1; unit<=NumOfCell[lay]; unit++){ 
	cell_pt = BPNet[lay][unit].CellNode;
	if (DisplayMode == COLOR){
	  level = norm_color(cell_pt->Active);
	  grainbow(level);
	  gbox(gx_point, gy_point,
	       gx_point+BoxWidth, gy_point+BoxWidth, 2, level);
	  gnewpen(GpmCont.fColor);
	  gbox(gx_point, gy_point,
	       gx_point+BoxWidth, gy_point+BoxWidth, 1, -1.0);
	}
	else {
	  level = norm_size(cell_pt->Active);
	  gnewpen(0);
	  gbox(gx_point, gy_point,
	       gx_point+BoxWidth, gy_point+BoxWidth, 2, -1.0);
	  size(gx_point, gy_point,
	       gx_point+BoxWidth, gy_point+BoxWidth, level);
	  gnewpen(GpmCont.fColor);
	  gbox(gx_point, gy_point,
	       gx_point+BoxWidth, gy_point+BoxWidth, 1, -1.0);
	}
	gx_point += BoxWidth + XPlus;	
      }
    }

    if ((inlayer <= lay+1) && (lay+1 <= outlayer)){ 
      if (lay+1 != NumOfLayer){
	if (CheckBias(lay+1)){	
	  if (DisplayMode == COLOR){
	    level = norm_color(1.0); 
	    grainbow(level);
	    gbox(0.0, gy_point+BoxWidth+YPlus/4,
		 BoxWidth, gy_point+BoxWidth*2+YPlus/4, 2, level);
	    gnewpen(GpmCont.fColor);
	    gbox(0.0, gy_point+BoxWidth+YPlus/4,
		 BoxWidth, gy_point+BoxWidth*2+YPlus/4, 1, -1.0);
	  }
	  else {
	    level = norm_size(1.0);
	    gnewpen(0);
	    gbox(0.0, gy_point+BoxWidth+YPlus/4,
		 BoxWidth, gy_point+BoxWidth*2+YPlus/4, 2, -1.0);
	    size(0.0, gy_point+BoxWidth+YPlus/4,
		 BoxWidth, gy_point+BoxWidth*2+YPlus/4, level);
	    gnewpen(GpmCont.fColor);
	    gbox(0.0, gy_point+BoxWidth+YPlus/4,
		 BoxWidth, gy_point+BoxWidth*2+YPlus/4, 1, -1.0);
	  }
	}
      }
    }
    gy_point += BoxWidth + YPlus;
  }
  
  if (teach_flag)
    draw_teach(TeachData[ptrn_no]);
  
  gflush();
}
