/*
 * Copyright (c) 1999, Toshihiro Aoyama All rights reserved.
 * 
 *                                  Modified by okumura  1999.12.21
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#define MAX_LINE_LENGTH (512)

typedef struct PClamp_File {
  char            format[4];
  double          format_version;
  int             number_optional_headers;
  int             number_fields;
  char          **optional_header;
  char           *title_record;
} PClamp_File;

int get_first_head_record(FILE * fp, PClamp_File * file)
{
  char            line[MAX_LINE_LENGTH];
  char            tmp_buffer[MAX_LINE_LENGTH];
  int             i = 0;
  int             j = 0;
  
  fgets(line, MAX_LINE_LENGTH, fp);
  
  strncpy(file->format, line, 3);
  file->format[3] = '\0';
  
  for (i = 3; i < MAX_LINE_LENGTH; i++) {
    if (!isspace(line[i])) {
      tmp_buffer[j] = line[i];
      j++;
    }
  }

  file->format_version = atof(tmp_buffer);

  return 0;
}

int get_second_head_record(FILE * fp, PClamp_File * file)
{
  char            line[MAX_LINE_LENGTH];
  char            tmp_buffer[MAX_LINE_LENGTH];
  int             i = 0;
  int             j;
  int             k = 0;
  
  fgets(line, MAX_LINE_LENGTH, fp);
  
  while (isspace(line[i])) {
    i++;
  }
  while (!isspace(line[i])) {
    tmp_buffer[k] = line[i];
    k++;
    i++;
  }
  tmp_buffer[k] = '\0';
  file->number_optional_headers = atoi(tmp_buffer);
  
  for (j = 0; j < k; j++) {
    tmp_buffer[j] = '\0';
  }
  k = 0;

  while (isspace(line[i])) {
    i++;
  }
  while (!isspace(line[i])) {
    tmp_buffer[k] = line[i];
    k++;
    i++;
  }
  tmp_buffer[k] = '\0';
  
  file->number_fields = atoi(tmp_buffer);

  return 0;
}

int get_optional_headers(FILE * fp, PClamp_File * file)
{
  char            line[MAX_LINE_LENGTH];
  int             i;

  for (i = 0; i < file->number_optional_headers; i++) {
    fgets(line, MAX_LINE_LENGTH, fp);
    file->optional_header[i] = (char *) malloc(sizeof(char) * 128);
    strcpy(file->optional_header[i], line);
  }

  return 0;
}

int get_title_record(FILE * fp, PClamp_File * file)
{
  char            line[MAX_LINE_LENGTH];

  fgets(line, MAX_LINE_LENGTH, fp);
  file->title_record = (char *) malloc(sizeof(char) * 128);
  strcpy(file->title_record, line);

  return 0;
}

int get_a_line(char *line, double *data, int n)
{
  char            tmp_buffer[MAX_LINE_LENGTH];
  int             i, j, k = 0, l = 0;
  
  for (i = 0; i < MAX_LINE_LENGTH; i++) {
    while (isspace(line[i])) {
      i++;
    }
    while (!isspace(line[i])) {
      tmp_buffer[k] = line[i];
      k++;
      i++;
    }
    data[l] = atof(tmp_buffer);
    for (j = 0; j < k; j++) {
      tmp_buffer[j] = '\0';
    }
    k = 0;
    l++;
  }
  
  if (n == l - 1) {
    return 0;
  } else {
    return -1;
  }
}

int main()
{
  PClamp_File     file1;
  FILE           *fp;
  Buffer         *sl_buffer;
  double         *data;
  char            line[MAX_LINE_LENGTH];
  char            *in_filename;
  char            out_filename[256];
  int             number_data = 0;
  int             index[2];
  int             i;
  
  
  read_syscom();
  
  /* Get Input File Name */
  in_filename=GetString(0);
  if(in_filename==NULL)
    exit(1);
  
  /* open Pclamp atf file */
  if ((fp = fopen(in_filename, "r")) == NULL) {
    exit(2);
  }

  /* get headers of atf file */
  get_first_head_record(fp, &file1);
  get_second_head_record(fp, &file1);
  file1.optional_header
    = (char **) malloc(sizeof(char) * file1.number_optional_headers);
  get_optional_headers(fp, &file1);
  get_title_record(fp, &file1);
  
  /* read data */
  data = (double *) malloc(sizeof(double) * file1.number_fields);
  sl_buffer = (Buffer *) malloc(sizeof(Buffer) * file1.number_fields);
  
  while (fgets(line, MAX_LINE_LENGTH, fp) != NULL) {
    get_a_line(line, data, file1.number_fields);
    sl_buffer = (Buffer *) realloc(sl_buffer,
  	   sizeof(Buffer) * (number_data + 1) * file1.number_fields);
    for (i = 0; i < file1.number_fields; i++) {
      sl_buffer[(number_data * file1.number_fields) + i] = data[i];
    }
    number_data++;
  }
  
  /* display headers of atf file */
  fprintf(stdout, "%s %f\n", file1.format, file1.format_version);
  fprintf(stdout, "%d %d\n", file1.number_optional_headers,
	  file1.number_fields);
  for (i = 0; i < file1.number_optional_headers; i++)
    fprintf(stdout, "%s", file1.optional_header[i]);
  fprintf(stdout, "%s\n", file1.title_record);
  
  
  /* generate save file name */
  i = 0;
  while (in_filename[i] != '.') {
    out_filename[i] = in_filename[i];
    i++;
  }
  out_filename[i] = '.';
  out_filename[i + 1] = 'd';
  out_filename[i + 2] = 'a';
  out_filename[i + 3] = 't';
  out_filename[i + 4] = '\0';
  
  /* save satellite buffer file */
  index[0] = number_data - 1;
  index[1] = file1.number_fields;
  
  ChangeDataSize(8);
  WriteFile(out_filename, 2, index, (char *) sl_buffer);
  
  return 0;
}
