#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

void MakeHeader(char *fname, int dim, int *index)
{
  int i;
  FILE *fp;
  char *headerfile;

  /* Header File Open */
  headerfile = (char *)malloc(strlen(fname)+5);
  sprintf(headerfile,"%s.fld",fname);
  fp=fopen(headerfile,"w");
  if(fp==NULL) exit(2);

  /* Header Write */
  fprintf(fp,"# AVS field file\n");
  fprintf(fp,"#        genarated by SATELLITE\n");
  fprintf(fp,"#\n");
  fprintf(fp,"ndim = %d\n",dim);
  for ( i = 1 ; i <= dim ; i++ ){
    fprintf(fp,"dim%d = %d\n",i,index[i-1]);
  }
  fprintf(fp,"nspace = %d\n",dim);
  fprintf(fp,"veclen = 1\n");
  fprintf(fp,"data = double\n");
  fprintf(fp,"field = uniform\n");
  fprintf(fp,"variable 1 file=%s.data filetype=binary\n",fname);

  /* Header File Close */
  fclose(fp);
  free(headerfile);
}

int main(void)
{
  register int i,j,k;
  int dim,index[10],length;
  Buffer *data;
  char *fname,*datafile;
  FILE *fp;
  read_syscom();

  /* Get File name */
  fname=GetString(0);
  if(fname==NULL)
    exit(1);

  /* Get Series Buffer */
  data=GetSeries(1,&dim,index);
  if(data==NULL)
    exit(1);

  if(dim>4)
    exit(6);

  length=IndexSize(dim,index);

  /* Genarate Header File */
  MakeHeader(fname,dim,index);

  /* Data File Open */
  datafile  = (char *)malloc(strlen(fname)+6);
  sprintf(datafile, "%s.data",fname);

  fp=fopen(datafile,"w");
  if(fp==NULL) exit(2);
  switch (dim) {
  case 1:
    for ( i = 0 ; i < index[0] ; i ++ ){
      fwrite(&data[i],sizeof(double),1,fp);
    }
    break;
  case 2:
    for ( j = 0 ; j < index[1] ; j ++ ) {
      for ( i = 0 ; i < index[0] ; i ++ ) {
	fwrite(&data[index[1]*i+j],sizeof(double),1,fp);
      }
    }
    break;
  case 3:
    for ( k = 0 ; k < index[2] ; k ++ ) {
      for ( j = 0 ; j < index[1] ; j ++ ) {
	for ( i = 0 ; i < index[0] ; i ++ ) {
	  fwrite(&data[index[2]*index[1]*k+index[1]*i+j],
		 sizeof(double),1,fp);
	}
      }
    }
    break;
  default:
    break;
  }

  /* Output File Close */
  fclose(fp);

  FreeBuffer(data);

  return 0;
}
