#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

typedef struct {
  int dim;
  int index[10];
  int length;
  Buffer *data;
} Buffer_Struct;

int main()
{
  int i,j;
  Buffer_Struct *bs;
  char *fname;
  FILE *fp;

  read_syscom();

  /* Get Output File Name */
  fname=GetString(0);
  if(fname==NULL)
    exit(1);

  /* Get Series Buffer */
  bs=(Buffer_Struct *)malloc(sizeof(Buffer_Struct));
  bs->data=GetSeries(1,&bs->dim,bs->index);
  if(bs->data==NULL){
    free(bs);
    exit(1);
  } else {
    bs->length=IndexSize(bs->dim,bs->index);
    /* Data Dimension Chack */
    if(bs->dim>2)
      exit(3);
  }

  /* Output File Open */
  fp=fopen(fname,"w");
  if(fp==NULL)
    exit(2);

  /* Data Output */
  for(i=0;i<bs->index[0];i++){
    if(bs->dim==2){
      for(j=0;j<bs->index[1];j++){
	fprintf(fp,"%d %d %f\n",j,i,bs->data[i*bs->index[1]+j]);
      }
      fprintf(fp,"\n");
    } else {
      fprintf(fp,"%d %f\n",i,bs->data[i]);
    }
  }
    
  /* Output File Close */
  fclose(fp);

  /* Buffer Memory Free */
  FreeBuffer(bs->data);
  free(bs);

  return 0;
}
