#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

typedef struct {
  int dim;
  int index[10];
  Buffer *data;
} Buffer_Struct;

int main()
{
  int i,j;
  Buffer_Struct bs;
  char *fname;
  FILE *fp;

  read_syscom();

  /* Get Output File Name */
  fname=GetString(0);
  if(fname==NULL)
    exit(1);

  /* Get Series Buffer */
  bs.data=GetSeries(1,&bs.dim,bs.index);
  if(bs.data==NULL){
    /* Didn't Get Series Buffer */
    exit(1);
  } else {
    /* Don't Use  Over 3 Dimension Data  */
    if(bs.dim>2)
      exit(3);
  }

  /* Open Output File */
  fp=fopen(fname,"w");
  if(fp==NULL)
    exit(2);

  /* Data Output */
  if(bs.dim==1)bs.index[1]=1;

  for(i=0;i<bs.index[0];i++){
    for(j=0;j<bs.index[1];j++){
      fprintf(fp,"%f ",bs.data[i*bs.index[1]+j]);
    }
    if(bs.dim==2)
      fprintf(fp,"\n");
  }

  /* Close Output File  */
  fclose(fp);

  /* Free Buffer */
  FreeBuffer(bs.data);
  return 0;
}
