#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

typedef struct {
  int type;    /* Computer Type */
  int rows;    /* Number of Data rows */
  int cols;    /* Number of Data columns */
  int imgf;    /* Flag Complex ( 0 = REAL , 1 = COMPLEX ) */
  int namelen; /* Length of Name for Data */
} MAT_Header ;

int main()
{
  register int i,j;
  int dim,index[10];
  Buffer *data;
  char *fname,*dname;
  FILE *fp;
  MAT_Header mat;

  read_syscom();

  /* Get File Name */
  fname=GetString(0);
  if(fname==NULL)
    exit(1);

  /* Get Data Name */
  dname=GetString(1);
  if(dname==NULL)
    exit(1);

  /* Get Buffer */
  if (!strcmp(GetArgType(2),"scalar")){
    dim=1;
    index[0]=1;
    data=AllocBuffer(1);
    data[0]=GetScalar(2);
  } else {
    data=GetSeries(2,&dim,index);
    if(data==NULL)
      exit(1);
  }

  if(dim>2) exit(3);

  /* Output File Open */
  fp=fopen(fname,"w");
  if(fp==NULL)
    exit(2);

  /* Data Output */
#if ( defined(i386) || defined(__alpha) )
  mat.type=0;
#else
  mat.type=1000;
#endif
  mat.imgf=0;
  mat.namelen = strlen(dname)+1;
  switch(dim){
  case 1:
    mat.rows=index[0];
    mat.cols=1;
    break;
  case 2:
    mat.rows=index[0];
    mat.cols=index[1];
    mat.type+=100;
    break;
  }
  fwrite(&mat,sizeof(mat),1,fp);
  fwrite(dname, mat.namelen*sizeof(char),1,fp);

  for(i=0;i<mat.rows;i++){
    for(j=0;j<mat.cols;j++){
      fwrite(&data[i*mat.cols+j],sizeof(double),1,fp);
    }
  }
  /* Output File Close */
  fclose(fp);
  FreeBuffer(data);
  return 0;
}
