#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

typedef struct {
  int dim;
  int index[10];
  int length;
  Buffer *data;
} Buffer_Struct;

int main()
{
  int i,j,k,l;
  Buffer_Struct *bs;

  int stop_flag;        /* Number of Input Data */

  char *dm_fmt;
  char *fname;
  char *format;
  double *data_buf;

  FILE *fp;
  int max_length,format_length;

  read_syscom();

  /* Get Output File Name*/
  fname=GetString(0);
  if(fname==NULL)
    exit(1);

  /* Get Output Format String */
  format=GetString(1);
  if(format==NULL)
    exit(1);

  /* Format String Check */
  stop_flag=0;
  format_length=strlen(format);
  for(i=0;i<format_length;i++){
    if((format[i]=='%')&&(format[i+1]!='%'))
      stop_flag++;
  }


  /* Get Series Buffers */
  bs=(Buffer_Struct *)malloc(sizeof(Buffer_Struct)*stop_flag);
  /* Format String Analysis */
  for(i=0;i<stop_flag;i++){
    bs[i].data=GetSeries(2+i,&bs[i].dim,bs[i].index);
    if(bs[i].data==NULL){
      bs[i].data=GetSnapshot(2+i,&bs[i].dim,bs[i].index);
      if(bs[i].data==NULL){
	free(bs);
	exit(1);
      }
    } else {
      bs[i].length=IndexSize(bs[i].dim,bs[i].index);
      if(bs[i].dim>1){
	fprintf(stdout,"Warning : arg[%d] isn't 1 dimension data\n",i+3);
      }
    }
  }

  /* Chack Max Buffer size */
  max_length=bs[0].length;
  for(i=0;i<stop_flag;i++){
    if(max_length<bs[i].length)
      max_length=bs[i].length;
  }

  /* Open Output File */
  fp=fopen(fname,"w");
  if(fp==NULL)
    exit(2);

  /* Data Output */
  data_buf=(double *)malloc(sizeof(double)*stop_flag);
  dm_fmt=(char *)malloc(sizeof(char)*format_length+1);
  for(i=0;i<max_length;i++){
    /* Correct Data */
    for(j=0;j<stop_flag;j++){
      if(bs[j].length > i){
	data_buf[j]=bs[j].data[i];
      } else {
	data_buf[j]=0.0;
      }
    }

    /* Format String Analysis */
    k=0;l=0;
    for(j=0;j<format_length;j++){
      /* if it find "%" symbol  */
      if(format[j]=='%'){
	dm_fmt[l++]='%';
	while(1){
	  /* Bad Format. goto Error */
	  if(j>=format_length){
	    fclose(fp);
	    exit(1);
	  }
	  switch(format[++j]){
	  case 'd':
	  case 'i':
	  case 'o':
	  case 'u':
	  case 'x':
	  case 'X': dm_fmt[l++]=format[j];dm_fmt[l]='\0';l=0;
	            fprintf(fp,dm_fmt,(int)data_buf[k]); k++; goto loop;
	  case 'f':
	  case 'e':
	  case 'E':
	  case 'g': 
	  case 'G': dm_fmt[l++]=format[j];dm_fmt[l]='\0';l=0;
                    fprintf(fp,dm_fmt,data_buf[k]); k++; goto loop;
          case '%': dm_fmt[l++]=format[j]; goto loop;
	  default : dm_fmt[l++]=format[j]; break;
	  }
	}
      } else {
	dm_fmt[l++]=format[j];
      }
      loop: ;
    }
    dm_fmt[l]='\0';
    fprintf(fp,dm_fmt);
  }

  /* Output File Close */
  fclose(fp);

  /* Free Buffer Memory */
  for(i=0;i<stop_flag;i++){
    FreeBuffer(bs[i].data);
  }
  free(dm_fmt);
  free(data_buf);
  free(bs);

  return 0;
}
