#include <stdio.h>
#include <stdlib.h>
#include "dcm_fifo.h"

DCM_FIFO_CELL *DCM_FIFO_CELL_New(){
  DCM_FIFO_CELL *ret;
  ret=(DCM_FIFO_CELL*)malloc(sizeof(DCM_FIFO_CELL));
  if(ret==NULL) exit(8); /* Out of Memory */
  ret->data=0.0;
  ret->next=NULL;
  return ret;
}

DCM_FIFO *DCM_FIFO_New(){
  DCM_FIFO *ret;
  ret=(DCM_FIFO*)malloc(sizeof(DCM_FIFO));
  if(ret==NULL) exit(8); /* out of memory */
  ret->top=NULL;
  ret->last=NULL;
  ret->size=0;
  return ret;
}

void DCM_FIFO_Init(DCM_FIFO *fifo){
  DCM_FIFO_CELL *it;
  for(it=fifo->top;fifo->top!=NULL;it=fifo->top){
    fifo->top=it->next;
    free(it);
  }
  fifo->top=NULL;
  fifo->last=NULL;
  fifo->size=0;
}

void DCM_FIFO_Delete(DCM_FIFO *fifo){
  DCM_FIFO_Init(fifo);
  free(fifo);
}

void DCM_FIFO_push(DCM_FIFO *fifo, double d){
  DCM_FIFO_CELL *it;
  it=DCM_FIFO_CELL_New();
  if(fifo->size==0) fifo->top=it;
  else fifo->last->next=it;
  fifo->last=it;
  it->data=d;
  fifo->size++;
}

double DCM_FIFO_pop(DCM_FIFO *fifo){
  double d;
  DCM_FIFO_CELL *it;
  it=fifo->top;
  if(fifo->size==0)exit(9); /* illegal memory access */
  d=it->data;
  fifo->top=it->next;
  free(it);
  fifo->size--;
  return d;
}

DCM_FIFO_LIST *DCM_FIFO_LIST_New(){
  DCM_FIFO_LIST *ret;
  ret=(DCM_FIFO_LIST*)malloc(sizeof(DCM_FIFO_LIST));
  if(ret==NULL)exit(8); /* out of memory */
  ret->top=NULL;
  ret->last=NULL;
  ret->size=0;
  return ret;
}

void DCM_FIFO_LIST_Add(DCM_FIFO_LIST *list, DCM_FIFO *add){
  DCM_FIFO_LIST_CELL *cell;
  cell=(DCM_FIFO_LIST_CELL*)malloc(sizeof(DCM_FIFO_LIST_CELL));
  if(cell==NULL)exit(8); /* out of memory */
  cell->fifo=add;
  if(list->size==0){
    list->top=cell;
  }else{
    list->last->next=cell;
  }
  list->last=cell;
  cell->next=NULL;
  list->size++;
}

void DCM_FIFO_LIST_Delete(DCM_FIFO_LIST *list){
  unsigned long i;
  DCM_FIFO_LIST_CELL *it;
  for(i=0;i<list->size;i++){
    it=list->top;
    list->top=it->next;
    DCM_FIFO_Delete(it->fifo);
    free(it);
  }
  free(list);
}

DCM_FIFO *DCM_FIFO_LIST_Get(DCM_FIFO_LIST *list, unsigned long pos){
  unsigned long i;
  DCM_FIFO_LIST_CELL *it;
  if(pos>=list->size)exit(9); /* illegal memory access */
  it=list->top;
  for(i=0;i<pos;i++){ it=it->next; }
  return it->fifo;
}

unsigned long DCM_FIFO_LIST_TotalSize(DCM_FIFO_LIST *list){
  unsigned long total;
  DCM_FIFO_LIST_CELL *it;
  total=0;
  for(it=list->top;it!=NULL;it=it->next){ total+=it->fifo->size; }
  return total;
}
  
