#ifndef __DCM_FIFO_H__
#define __DCM_FIFO_H__

typedef struct _DCM_FIFO_CELL {
  double data;
  struct _DCM_FIFO_CELL *next;
} DCM_FIFO_CELL ;

typedef struct {
  DCM_FIFO_CELL *top,*last;
  unsigned long size;
} DCM_FIFO ;

typedef struct _DCM_FIFO_LIST_CELL {
  DCM_FIFO            *fifo;
  struct _DCM_FIFO_LIST_CELL *next;
} DCM_FIFO_LIST_CELL ;

typedef struct {
  unsigned long size;
  DCM_FIFO_LIST_CELL *top,*last;
} DCM_FIFO_LIST ;

/* DCM_FIFO_CELL *DCM_FIFO_CELL_New(); */
DCM_FIFO      *DCM_FIFO_New();
void           DCM_FIFO_Init(DCM_FIFO *);
void           DCM_FIFO_Delete(DCM_FIFO *);
void           DCM_FIFO_push(DCM_FIFO *, double);
double         DCM_FIFO_pop(DCM_FIFO *);

DCM_FIFO_LIST *DCM_FIFO_LIST_New();
void DCM_FIFO_LIST_Add(DCM_FIFO_LIST *, DCM_FIFO *);
void DCM_FIFO_LIST_Delete(DCM_FIFO_LIST *);
DCM_FIFO *DCM_FIFO_LIST_Get(DCM_FIFO_LIST *, unsigned long);
unsigned long DCM_FIFO_LIST_TotalSize(DCM_FIFO_LIST *list);
#endif
