/*
  

                                                                  
     DR-M2a եޥåȤSATELLITEǡץ   
     (Ȥϣͣ.ڤDR-M2a -> Canopus ץ)              
                               Modified by okumura  1999.12.21    

  
*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#define	PATHLENGTH	128
#define LINELENGTH	256
#define	CH_NUM		16       /* ͥ Ƥ */

/*
===============================================================================
   إå¤Τ 
===============================================================================
*/
typedef struct
{
    char      	fname_base[PATHLENGTH];
    int 	num_series;
    double    	slope[CH_NUM];
    double    	y_offset[CH_NUM];
    long      	num_samps;
    char	name_ch[CH_NUM][PATHLENGTH];
    double    	samp_freq;
    int       	input_range;
} DR_hdr;

/*
===============================================================================
   SmallEndian to BigEndian ѴѶ
===============================================================================
*/
typedef union
{
    short	sval;
    char	cval[2];
} char_short;

#ifdef _DEBUG
/*
===============================================================================
  ǥХå Header ɽؿ
===============================================================================
*/
void print_header(DR_hdr *hdr){
  int i;
  printf("filename   : %s\n",hdr->fname_base);
  printf("num series : %d\n",hdr->num_series);
  for(i=0;i<hdr->num_series;i++)
    printf("slope %2d   : %f\n",i,hdr->slope[i]);
  printf("num samps  : %ld\n",hdr->num_samps);
  for(i=0;i<hdr->num_series;i++)
    printf("name ch %2d : %s\n",i,hdr->name_ch[i]);
  printf("samp freq  : %f\n",hdr->samp_freq);
  printf("inp  range : %d\n",hdr->input_range);
}
#endif

/* 
===============================================================================
   ʲ, إåե뤫ξɤ߽Фؿ
   ͤϥإå¤ DR_hdr ˥åȤ롥

  줾ΥȤϥޥ˥奢뤫ȴ补
===============================================================================

===============================================================================
   NUM_SERIES: Ͽͥ
===============================================================================
*/
void RH_num_series( DR_hdr *hdr, char *buf)
{
    char    	str1[LINELENGTH];
    int     	num;

    sscanf( buf, "%s %d", str1, &num );
    hdr->num_series = num;
}

/* 
===============================================================================
   SLOPE: ƥͥñ̤Ѵ Y = ax + b η aͤƥͥ뤴Ȥ
   "."Ƕڤäɽâ, xA/Dͤ, aͤ 1bitʬǽǤ
===============================================================================
*/
void RH_slope( DR_hdr *hdr, char *buf )
{
    char    	str1[LINELENGTH];
    double  	slope;
    int     	i;

    sscanf( buf, "%s %lf", str1, &slope );
    hdr->slope[0] = slope;
    for ( i = 1; i < hdr->num_series; i++ )
    {
	sscanf( buf, ",%lf", &slope );
        hdr->slope[i] = slope;
    }
}

/* 
===============================================================================
   Y_OFFSET: ƥͥѴ Y = ax + b  b ͤ *26667ǳä
   ͤ"."Ƕڤäɽ
===============================================================================
*/
void RH_yoffset( DR_hdr *hdr, char *buf )
{
    char	str1[LINELENGTH];
    double  	y_offset;
    int     i;

    sscanf( buf, "%s %lf", str1, &y_offset );
    hdr->y_offset[0] = y_offset;
    for ( i = 1; i < hdr->num_series; i++ )

    {
	sscanf( buf, ",%lf", &y_offset );
	hdr->y_offset[i] = y_offset;
    }
}

/* 
===============================================================================
   NUM_SAMPS: ƥͥΥǡIDμϿǡ
===============================================================================
*/
void RH_samps( DR_hdr *hdr, char *buf )
{
    char    	str1[LINELENGTH];
    long   	samps;

    sscanf( buf, "%s %ld", str1, &samps );
    hdr->num_samps = samps;
}

/* 
===============================================================================
   Ϥ16ʸޤǤCH-?ο̾, ǥեȤ CH_?
===============================================================================
*/
void RH_name_ch( DR_hdr *hdr, char *buf, int ch_num )
{
    char    	str1[LINELENGTH];
    char  	name_ch[LINELENGTH];

    sscanf( buf, "%s %s", str1, name_ch );
    strcpy( hdr->name_ch[ch_num - 1], name_ch );
}

/* 
===============================================================================
   ץ󥰼ȿ1Hz100kHz 1, 2, 5 ƥåס
===============================================================================
*/
void RH_freq( DR_hdr *hdr, char *buf )
{
    char    	str1[LINELENGTH];
    char    	str2[LINELENGTH];
    double  	freq;

    sscanf( buf, "%s %s", str1, str2 );
    if ( strstr( str2, "MHz" ) != NULL )
    {
	str2[strlen( str2 ) - strlen( "MHz" )] = '\0';
	sscanf( str2, "%lf\n", &freq );
	hdr->samp_freq = freq * 1000000.0;
    }
    else if ( strstr( str2, "KHz" ) != NULL )
    {
	str2[strlen( str2 ) - strlen( "KHz" )] = '\0';
	sscanf( str2, "%lf\n", &freq );
	hdr->samp_freq = freq * 1000.0;
    }
    else if ( strstr( str2, "Hz" ) != NULL )
    {
	str2[strlen( str2 ) - strlen( "Hz" )] = '\0';
	sscanf( str2, "%lf\n", &freq );
	hdr->samp_freq = freq;
    }
}

/* 
===============================================================================
   ʥϥ󥸤 1V, 2V, 5V, 10VλؼŰ󥸡 
===============================================================================
*/
void RH_range( DR_hdr *hdr, char *buf )
{
    char    	str1[LINELENGTH];
    char    	str2[LINELENGTH];
    int     	range;

    sscanf( buf, "%s %s", str1, str2 );
    str2[strlen( str2 ) - strlen( "V" )] = '\0';
    sscanf( str2, "%d", &range );
    hdr->input_range = range;
}

/*
===============================================================================
   إåեɤ߹ߤȹ¤Τؤ
   hdr.fname_base˥ե̾Υ١ʬ뤹뤳

   ɤ߹ǤǡϣģҤꤷƤȡ
    ͥ̾ѴΥե̾Ѥ롥
    ͤϥפȥեåȤꤷƤѴǡФǤʤ 
      ģҤɽŬڤͤȤʤ롥
    ʳϾꤵ餷Τ, ä˹ͤʤƤɤ
===============================================================================
*/
void ReadHeader( DR_hdr *hdr )
{
    FILE    	*fp;
    char    	filename[PATHLENGTH];
    char    	buf[LINELENGTH + 1];
    char    	key[LINELENGTH + 1];

    strcpy( filename, hdr->fname_base );                /* ե̾ */
    strcat( filename, ".hdr" );
    if( access(filename, R_OK) == -1 ){
      strcpy( filename, hdr->fname_base );
      strcat( filename, ".HDR" );
      if( access(filename, R_OK) == -1 ){
	exit( 2 );
      }
    }

    if ( ( fp = fopen( filename, "r" ) ) == NULL )
    {
	exit( 2 );                                      /*      */
    }

    while ( fgets( buf, LINELENGTH, fp ) != NULL )     /* 뤰󤷤 */
    {                                                  /* פȤ */
	sscanf( buf, "%s", key );

	if ( strcmp( key, "NUM_SERIES" ) == 0 )
	{
	    RH_num_series( hdr, buf );
	    continue;
	}
	if ( strcmp( key, "SLOPE" ) == 0 )
	{
	    RH_slope( hdr, buf );
	    continue;
	}
	if ( strcmp( key, "Y_OFFSET" ) == 0 )
	{
	    RH_yoffset( hdr, buf );
	    continue;
	}
	if ( strcmp( key, "NUM_SAMPS" ) == 0 )
	{
	    RH_samps( hdr, buf );
	    continue;
	}
	if ( !strncmp( key, "NAME_CH",7 ) ) {
	  int num;
	  if ( key[8] == '\0' ) /* 1 */
	    num=(int)(key[7]-'0');
	  else                  /* 2 */
	    num=(int)(key[7]-'0')*10 + (key[8]-'0');
	  RH_name_ch( hdr, buf, num);
	  continue;
	}
	if ( strcmp( key, "SAMPLE_FREQUENCY" ) == 0 )
	{
	    RH_freq( hdr, buf );
	    continue;
	}
	if ( strcmp( key, "INPUT_RANGE" ) == 0 )
	{
	    RH_range( hdr, buf );
	    continue;
	}
    }
    fclose( fp );
}

/*
===============================================================================
   Endian Ѵؿ for sparc series

   ѡ꡼ϥǡ¤Ӥ㤦餷ä, ä
===============================================================================
*/
#if !(defined(i386) || defined(__alpha))
short chg_endian( short sval )
{
    char_short	le, be;

    le.sval = sval;

    be.cval[0] = le.cval[1];
    be.cval[1] = le.cval[0];

    return be.sval;
}
#endif

/*
===============================================================================
   ǡɤ߹

   ץ, ͥǡɤ߹, ƥͥͤ˽äƥǡ
   Ѵ롥ƻΥǡϢʤäƵϿƤ뤿, ̡ɤ߹Τϸ
   ΨǤޤȤƽ, ͥʬޤȤ֤
===============================================================================
*/
float *ReadData_f( DR_hdr *hdr )
{
    long	i;
    int		j;
    char	filename[PATHLENGTH];
    FILE	*fp;
    float	*buf;
    short    	buf2[CH_NUM];

    if ( ( buf = (float*)malloc( hdr->num_series * hdr->num_samps * sizeof( float ) ) ) == NULL )
    {
	exit( 8 );                                   /* ,  */
    }

    strcpy( filename, hdr->fname_base );
    strcat( filename, ".dat" );                         /* ե̾ */
    if( access(filename, R_OK) == -1 ){
      strcpy( filename, hdr->fname_base );
      strcat( filename, ".DAT" );
      if( access(filename, R_OK) == -1 ){
	exit( 2 );
      }
    }

    if ( ( fp = fopen( filename,"rb" ) ) == NULL )
    {
	exit( 2 );                                      /*      */
    }

    for( i = 0L; i < hdr->num_samps; i++ ) /* ץ */
    {
	fread( buf2, sizeof( short ), hdr->num_series, fp );
	for ( j = 0; j < hdr->num_series; j++ ) /* ͥ */
	{
#if !(defined(i386) || defined(__alpha))
	    buf[i + hdr->num_samps * j] = chg_endian( buf2[j] ) * hdr->slope[j]
		    + hdr->y_offset[j] * hdr->input_range * hdr->input_range;
#else
	    buf[i + hdr->num_samps * j] = (float)buf2[j] * hdr->slope[j]
		    + hdr->y_offset[j] * hdr->input_range * hdr->input_range;
#endif
	}                                        /* ͤ˽äѴ */
    }                                            /* ޥ˥奢70ڡ */
    fclose( fp );                                       /* ǥ */

    return buf;                            /* ͥʬޤȤ֤ */
}

/*
===============================================================================
   , , 餬֡
===============================================================================
*/
int main( void )
{
    char    	*filename;
    char	distname[PATHLENGTH];
    DR_hdr  	hdr;
    int		i;
    float	*data;
    char	*direction;
    int		dflag = 1;
    int		index[MAX_INDEX];

    read_syscom();                  /* ɤޤʤ餷٤ */

    if ( ( filename = GetString( 0 ) ) == NULL )
    {
	exit( 2 );              /* 羭, ե뤬ʤääˤʤᤨ */
    }
    direction = (char *)GetString( 1 );
    if( direction != NULL ){
      switch( direction[0] ){
      	case 'T':
	  dflag = 0;
	  break;
	case 'D':
	  dflag = 1;
	  break;
	default:
	  dflag = 1;
	  break;
	}
    }

    strcpy( hdr.fname_base, filename );
    ReadHeader( &hdr );                               /* إåɤ߹ */
#ifdef _DEBUG
    print_header( &hdr );
#endif
    data = ReadData_f( &hdr );                         /*  ǡɤ߹  */
    for ( i = 0; i < hdr.num_series; i++ )
    {                              /* ͥ뤴Ȥ˥֤롥ޤ */
	strcpy( distname, filename );
	strcat( distname, "_" );                          /* ե̾ */
	strcat( distname, hdr.name_ch[i] ); /* إåΥͥ̾Ѥ */
	strcat( distname, ".dat" ); 
	if( dflag == 0 ){
	  WriteFile( distname, 1, (int *)&hdr.num_samps, 
		    (char *)&data[hdr.num_samps * i] );
	}else{
	  index[0] = 1;
	  index[1] = hdr.num_samps;
	  WriteFile( distname, 2, index,
		    (char *)&data[hdr.num_samps * i] );
	}
    }                                         /* 񤡤ߤ */

    return 0;                                /* ޤǤʸϤᤨ */
}                                                        /* ۤ, ʤ */
