#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

typedef struct {
  float x,y,z;
} XYZCoord;

typedef struct {
  FILE *fp;
  char label[100];
  float start;
  float step;
  int  nx;
  int  ny;
  int  nz;
  int  ndata;
  int  datatype;
  int  header_size;
  XYZCoord *table;
} DiskOut_Header;


typedef struct {
  int id;
  int dim;
  int index[10];
  Buffer *data;
} Buffer_Struct;


int Read_FMT1_Header(DiskOut_Header *diskout){
  int i;
  XYZCoord temp;

  /* read in the file header */
  fread(diskout->label,sizeof(char),80,diskout->fp);

  /* check the label */
  if(strncmp("FMT1",diskout->label,4)){
    return(4);
  }

  /* starting time */
  fread(&diskout->start,sizeof(float),1,diskout->fp);
  fprintf(stdout,"start time   : %e\n",diskout->start);

  /* time step */
  fread(&diskout->step,sizeof(float),1,diskout->fp);
  fprintf(stdout,"step time    : %e\n",diskout->step);

  /* number of data points */
  fread(&diskout->ndata,sizeof(int),1,diskout->fp);
#ifdef DEBUG
  fprintf(stdout,"data points  : %d\n",diskout->ndata);
#endif
  /* data type */
  fread(&diskout->datatype,sizeof(int),1,diskout->fp);
#ifdef DEBUG
  fprintf(stdout,"data type    : %d\n",diskout->datatype);
#endif
  /* header size */
  diskout->header_size=2*sizeof(int)+2*sizeof(float)+80+
    diskout->ndata*sizeof(XYZCoord);
#ifdef DEBUG
  fprintf(stdout,"header size  : %d\n",diskout->header_size);
#endif
  diskout->table=(XYZCoord *)malloc(diskout->ndata*sizeof(XYZCoord));
  if(fseek(diskout->fp,(long)2*sizeof(int)+2*sizeof(float)+80,0) == -1){
    return 4;
  }
  if(fread(diskout->table,diskout->ndata*sizeof(XYZCoord),1,diskout->fp) == 0){
    return 4;
  }

  /* dimension check */
  diskout->nx=1;
  diskout->ny=1;
  diskout->nz=1;
  temp.x=diskout->table[0].x;
  temp.y=diskout->table[0].y;
  temp.z=diskout->table[0].z;
  for(i=1;i<diskout->ndata;i++){
    if(temp.x!=diskout->table[i].x){
      diskout->nx++;
      temp.x=diskout->table[i].x;
    }
    if(temp.y!=diskout->table[i].y){
      diskout->ny++;
      temp.y=diskout->table[i].y;
    }
      if(temp.z!=diskout->table[i].z){
      diskout->nz++;
      temp.x=diskout->table[i].z;
    }
  }
  if(diskout->ndata!=(diskout->nx * diskout->ny * diskout->nz)){
    return 4;
  }
#ifdef DEBUG
  fprintf(stdout,"(x y z) : (%d %d %d)\n"
	  ,diskout->nx,diskout->ny,diskout->nz);
#endif
  return 0;
}

int main()
{
  int ret,datasize;
  int i,j;
  union {
    short  s;
    float  f;
    int    i;
    double d;
  }tmp;

  char *fname;
  Buffer_Struct buffer,start,step;
  DiskOut_Header diskout;

  read_syscom();

  /* Get Input File Name*/
  fname=GetString(0);
  if(fname==NULL)
    exit(1);

  diskout.fp=fopen(fname,"r");
  if(diskout.fp==NULL)
    exit(2);

  ret=Read_FMT1_Header(&diskout);
  if(ret!=0){
    fclose(diskout.fp);
    exit(ret);
  }

  if ( GetArgNum() > 1){
    start.id=GetBufferID(1);
    if(start.id != 0){
      start.index[0]=1;
      start.dim=1;
      InitBuffer(start.id,start.dim,start.index);
      start.data=(Buffer *)malloc(sizeof(Buffer));
      start.data[0]=(double)diskout.start;
      WriteBuffer(start.id,start.dim,start.index,start.data);
    }
  }

  if ( GetArgNum() > 2){
    step.id=GetBufferID(2);
    if(step.id != 0){
      step.index[0]=1;
      step.dim=1;
      InitBuffer(step.id,step.dim,step.index);
      step.data=(Buffer *)malloc(sizeof(Buffer));
      step.data[0]=(double)diskout.step;
      WriteBuffer(step.id,step.dim,step.index,step.data);
    }
  }

  /* check data size */
  switch(diskout.datatype) {
  case 2 :
    datasize = sizeof(short);
    break;
  case 3 :
    datasize = sizeof(int);
    break;
  case 4 :
    datasize = sizeof(float);
    break;
  case 5 :
    datasize = sizeof(double);
    break;
  default :
    fclose(diskout.fp);
    exit(6);
    break;
  }

  if(fseek(diskout.fp,diskout.header_size,0) == -1){
    fclose(diskout.fp);
    exit(7);
  }

  for(i=0;fread(&tmp,datasize,1,diskout.fp)!=0;i++){
    if(i==0){
      buffer.data=AllocBuffer(diskout.ndata);
    } else {
      buffer.data=(Buffer *)realloc(buffer.data,
           sizeof(Buffer)*(diskout.ndata)*(i+1));
    }
    for(j=0;j<diskout.ndata;j++){
      if(j!=0){
	if(fread(&tmp,datasize,1,diskout.fp)==0){
	  fclose(diskout.fp);
	  exit(6);
	}
      }
      switch(diskout.datatype) {
      case 2 :
	buffer.data[i*diskout.ndata+j]=(double)tmp.s;
	break;
      case 3 :
	buffer.data[i*diskout.ndata+j]=(double)tmp.i;
	break;
      case 4 :
	buffer.data[i*diskout.ndata+j]=(double)tmp.f;
	break;
      case 5 :
	buffer.data[i*diskout.ndata+j]=(double)tmp.d;
	break;
      }
    }
  }

  if(diskout.nz==1){
    if(diskout.ny==1){
      if(diskout.nx==1){
	buffer.dim=1;
	buffer.index[0]=i;
      } else {
	buffer.dim=2;
	buffer.index[0]=diskout.nx;
	buffer.index[1]=i;
      }
    } else {
      buffer.dim=3;
      buffer.index[0]=diskout.nx;
      buffer.index[1]=diskout.ny;
      buffer.index[2]=i;
    }
  } else {
    buffer.dim=4;
    buffer.index[0]=diskout.nx;
    buffer.index[1]=diskout.ny;
    buffer.index[2]=diskout.nz;
    buffer.index[3]=i;
  }
  fclose(diskout.fp);
  free(diskout.table);
  ReturnSeries(buffer.data,buffer.dim,buffer.index);
  FreeBuffer(buffer.data);
  return 0;
}
