#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "SL_macro.h"
#include "SL_cmd.h"

typedef struct {
  FILE *fp;
  char fname[64];
  int dim,index[10],length;
  Buffer *data;
} Satellite_Data;

int main()
{
  int i,j;
  int num,size;
  FILE *nrn_fp;
  char *nrn_fname;
  char dumy[128],temp[64];
  double dat1,dat2;
  Satellite_Data *sd;

  read_syscom();

  /* Get File Name */
  nrn_fname=GetString(0);
  if(nrn_fname==NULL)
    exit(1);

  /* Input File Open */
  nrn_fp=fopen(nrn_fname,"r");
  if(nrn_fp==NULL)
    exit(1);

  while(1){
    fscanf(nrn_fp,"%s",dumy);
    if(feof(nrn_fp)){
      break;
    }
    if(strcmp("Graph",dumy)){
      exit(4);
    }
    fgets(dumy,512,nrn_fp);
    fscanf(nrn_fp,"%d %d",&num,&size);

    sd=(Satellite_Data *)malloc(sizeof(Satellite_Data)*num);

    /* Satellite Data Init */
    for(i=0;i<num;i++){
      sd[i].dim=2;
      sd[i].length=size*2;
      sd[i].data=AllocBuffer(size*2);
      sd[i].index[0]=size;
      sd[i].index[1]=2;
      for(j=2;j<10;j++)
	sd[i].index[j]=0;
    }

    /* Set File Name */
    fscanf(nrn_fp,"%s",dumy);
    for(i=0;i<num;i++){
      fscanf(nrn_fp,"%s",dumy);
      if(dumy[strlen(dumy)-1]=='('){
	dumy[strlen(dumy)-1]=0;
	strcpy(sd[i].fname,dumy);
	fscanf(nrn_fp,"%s",temp);
	fscanf(nrn_fp,"%s",temp);
	if(temp[0]!=')'){
	  exit(4);
	}
      } else {
	strcpy(sd[i].fname,dumy);
      }
    }

    /* Data Set */
    for(i=0;i<size;i++){
      fscanf(nrn_fp,"%lf",&dat1);
      for(j=0;j<num;j++){
	fscanf(nrn_fp,"%lf",&dat2);
	sd[j].data[i*2]=dat1;
	sd[j].data[i*2+1]=dat2;
      }
    }

    /* Satellite File Object Data Output */
    ChangeDataSize(8);
    for(i=0;i<num;i++){
      sprintf(sd[i].fname,"%s.dat",sd[i].fname);
      printf("Output Satellite File Object : \"%s\"\n",sd[i].fname);
      WriteFile(sd[i].fname, sd[i].dim, sd[i].index, (char *) sd[i].data);
      FreeBuffer(sd[i].data);
    }
    free(sd);
  }
  return 0;
}
