/*
  

                                                                  
     DR-M2a tH[}bgSATELLITEf[^𐶐vO   
     (Ƃ͂l.؂DR-M2a -> Canopus vO)              
                                                                  

  
*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#define	PATHLENGTH	80
#define LINELENGTH	255
#define	CH_NUM		8       /* ő`l ꉞėpĂ */

/*
===============================================================================
   wb_\̂̒` 
===============================================================================
*/
typedef struct
{
    char      	fname_base[PATHLENGTH];
    int 	num_series;
    double    	slope[CH_NUM];
    double    	y_offset[CH_NUM];
    long      	num_samps;
    char	name_ch[CH_NUM][PATHLENGTH];
    double    	samp_freq;
    int       	input_range;
} DR_hdr;

/*
===============================================================================
   SmallEndian to BigEndian ̕ϊpp
===============================================================================
*/
typedef union
{
    short	sval;
    char	cval[2];
} char_short;

/* 
===============================================================================
   ȉ, wb_t@C̏ǂݏo֐QD
   l̓wb_\ DR_hdr ɃZbgD

  ꂼ̃Rg̓}jA甲D
===============================================================================

===============================================================================
   NUM_SERIES: ^`l
===============================================================================
*/
void RH_num_series( DR_hdr *hdr, char *buf)
{
    char    	str1[LINELENGTH];
    int     	num;

    sscanf( buf, "%s %d", str1, &num );
    hdr->num_series = num;
}

/* 
===============================================================================
   SLOPE: e`l̒Pʂ̕ϊ Y = ax + b ̌W a̒le`lƂ
   "."ŋ؂ĕ\DA, xA/Dl, a̒l 1bit̕\łD
===============================================================================
*/
void RH_slope( DR_hdr *hdr, char *buf )
{
    char    	str1[LINELENGTH];
    double  	slope;
    int     	i;

    sscanf( buf, "%s %lf", str1, &slope );
    hdr->slope[0] = slope;
    for ( i = 1; i < hdr->num_series; i++ )
    {
	sscanf( buf, ",%lf", &slope );
        hdr->slope[i] = slope;
    }
}

/* 
===============================================================================
   Y_OFFSET: e`l̕ϊ Y = ax + b  b ̒lW *26667Ŋ
   l"."ŋ؂ĕ\D
===============================================================================
*/
void RH_yoffset( DR_hdr *hdr, char *buf )
{
    char	str1[LINELENGTH];
    double  	y_offset;
    int     i;

    sscanf( buf, "%s %lf", str1, &y_offset );
    hdr->y_offset[0] = y_offset;
    for ( i = 1; i < hdr->num_series; i++ )

    {
	sscanf( buf, ",%lf", &y_offset );
	hdr->y_offset[i] = y_offset;
    }
}

/* 
===============================================================================
   NUM_SAMPS: e`l̃f[^őID̎^f[^D
===============================================================================
*/
void RH_samps( DR_hdr *hdr, char *buf )
{
    char    	str1[LINELENGTH];
    long   	samps;

    sscanf( buf, "%s %ld", str1, &samps );
    hdr->num_samps = samps;
}

/* 
===============================================================================
   L[͂16܂łCH-?̐M, ftHg CH_?D
===============================================================================
*/
void RH_name_ch( DR_hdr *hdr, char *buf, int ch_num )
{
    char    	str1[LINELENGTH];
    char  	name_ch[LINELENGTH];

    sscanf( buf, "%s %s", str1, name_ch );
    strcpy( hdr->name_ch[ch_num - 1], name_ch );
}

/* 
===============================================================================
   TvOg1Hz`100kHz 1, 2, 5 XebvD
===============================================================================
*/
void RH_freq( DR_hdr *hdr, char *buf )
{
    char    	str1[LINELENGTH];
    char    	str2[LINELENGTH];
    double  	freq;

    sscanf( buf, "%s %s", str1, str2 );
    if ( strstr( str2, "MHz" ) != NULL )
    {
	str2[strlen( str2 ) - strlen( "MHz" )] = NULL;
	sscanf( str2, "%lf\n", &freq );
	hdr->samp_freq = freq * 1000000.0;
    }
    else if ( strstr( str2, "KHz" ) != NULL )
    {
	str2[strlen( str2 ) - strlen( "KHz" )] = NULL;
	sscanf( str2, "%lf\n", &freq );
	hdr->samp_freq = freq * 1000.0;
    }
    else if ( strstr( str2, "Hz" ) != NULL )
    {
	str2[strlen( str2 ) - strlen( "Hz" )] = NULL;
	sscanf( str2, "%lf\n", &freq );
	hdr->samp_freq = freq;
    }
}

/* 
===============================================================================
   AiO̓W 1V, 2V, 5V, 10V̎wdWD 
===============================================================================
*/
void RH_range( DR_hdr *hdr, char *buf )
{
    char    	str1[LINELENGTH];
    char    	str2[LINELENGTH];
    int     	range;

    sscanf( buf, "%s %s", str1, str2 );
    str2[strlen( str2 ) - strlen( "V" )] = NULL;
    sscanf( str2, "%d", &range );
    hdr->input_range = range;
}

/*
===============================================================================
   wb_t@C̓ǂݍ݂ƍ\̂ւ̑
   hdr.fname_baseɃt@C̃x[XR[邱

   œǂݍłf[^͂cqŐݒ肵ĂƁD
   E `l͕ϊ̃t@CɗpD
   E l̕␳̓X[vƃItZbgŐݒ肵Ăƕϊf[^΂łȂC 
      cq̕\K؂ȒlƂȂD
   E ȊO͏ɐݒ肳炵̂, ɍlȂĂǂD
===============================================================================
*/
void ReadHeader( DR_hdr *hdr )
{
    FILE    	*fp;
    char    	filename[PATHLENGTH];
    char    	buf[LINELENGTH + 1];
    char    	key[LINELENGTH + 1];

    strcpy( filename, hdr->fname_base );                /* t@C */
    strcat( filename, ".hdr" );

    if ( ( fp = fopen( filename, "r" ) ) == NULL )
    {
	exit( 2 );                                      /*      */
    }

    while ( fgets( buf, LINELENGTH, fp ) != NULL )     /* 邮񂵂 */
    {                                                  /* vƂE */
	sscanf( buf, "%s", key );

	if ( strcmp( key, "NUM_SERIES" ) == 0 )
	{
	    RH_num_series( hdr, buf );
	    continue;
	}
	if ( strcmp( key, "SLOPE" ) == 0 )
	{
	    RH_slope( hdr, buf );
	    continue;
	}
	if ( strcmp( key, "Y_OFFSET" ) == 0 )
	{
	    RH_yoffset( hdr, buf );
	    continue;
	}
	if ( strcmp( key, "NUM_SAMPS" ) == 0 )
	{
	    RH_samps( hdr, buf );
	    continue;
	}
	if ( strcmp( key, "NAME_CH1" ) == 0 )
	{
	    RH_name_ch( hdr, buf, 1 );
	    continue;
	}
	if ( strcmp( key, "NAME_CH2" ) == 0 )
	{
	    RH_name_ch( hdr, buf, 2 );
	    continue;
	}
	if ( strcmp( key, "NAME_CH3" ) == 0 )
	{
	    RH_name_ch( hdr, buf, 3 );
	    continue;
	}
	if ( strcmp( key, "NAME_CH4" ) == 0 )
	{
	    RH_name_ch( hdr, buf, 4 );
	    continue;
	}
	if ( strcmp( key, "NAME_CH5" ) == 0 )
	{
	    RH_name_ch( hdr, buf, 5 );
	    continue;
	}
	if ( strcmp( key, "NAME_CH6" ) == 0 )
	{
	    RH_name_ch( hdr, buf, 6 );
	    continue;
	}
	if ( strcmp( key, "NAME_CH7" ) == 0 )
	{
	    RH_name_ch( hdr, buf, 7 );
	    continue;
	}
	if ( strcmp( key, "NAME_CH8" ) == 0 )
	{
	    RH_name_ch( hdr, buf, 8 );
	    continue;
	}
	if ( strcmp( key, "SAMPLE_FREQUENCY" ) == 0 )
	{
	    RH_freq( hdr, buf );
	    continue;
	}
	if ( strcmp( key, "INPUT_RANGE" ) == 0 )
	{
	    RH_range( hdr, buf );
	    continue;
	}
    }
    fclose( fp );
}

/*
===============================================================================
   Endian ̕ϊ֐ for spac series

   Xp[NV[Y̓f[^̕тႤ炵D, D
===============================================================================
*/
short chg_endian( char_short le )
{
    char_short	be;

    be.cval[0] = le.cval[1];
    be.cval[1] = le.cval[0];

    return be.sval;
}

/*
===============================================================================
   f[^ǂݍ

   Tv, `lf[^ǂݍ, e`l̕␳lɏ]ăf[^
   ϊDẽf[^AȂċL^Ă邽, ʁXɓǂݍނ̂͌
   Dł܂Ƃ߂ď, S`l܂Ƃ߂ĕԂD
===============================================================================
*/
float *ReadData_f( DR_hdr *hdr )
{
    long	i;
    int		j;
    char	filename[PATHLENGTH];
    FILE	*fp;
    float	*buf;
    short    	buf2[CH_NUM];

    if ( ( buf = (float*)malloc( hdr->num_series * hdr->num_samps * sizeof( float ) ) ) == NULL )
    {
	exit( 3 );                                   /* ꏊ, ꏊ */
    }

    strcpy( filename, hdr->fname_base );
    strcat( filename, ".dat" );                         /* t@C */

    if ( ( fp = fopen( filename,"rb" ) ) == NULL )
    {
	exit( 4 );                                      /*      */
    }

    for( i = 0L; i < hdr->num_samps; i++ ) /* Tv */
    {
	fread( buf2, sizeof( short ), hdr->num_series, fp );
	for ( j = 0; j < hdr->num_series; j++ ) /* `l */
	{
#ifdef sun
	    buf[i + hdr->num_samps * j] = chg_endian( buf2[j] ) * hdr->slope[j]
		    + hdr->y_offset[j] * hdr->input_range * hdr->input_range;
#else
	    buf[i + hdr->num_samps * j] = (float)buf2[j] * hdr->slope[j]
		    + hdr->y_offset[j] * hdr->input_range * hdr->input_range;
#endif
	}                                        /* ␳lɏ]ĕϊ */
    }                                            /* }jA70y[WQ */
    fclose( fp );                                       /* AfBIX */

    return buf;                            /* S`l܂Ƃ߂ĕԂD */
}

/*
===============================================================================
   , , 炪{ԁD
===============================================================================
*/
int main( void )
{
    char    	*filename;
    char	distname[PATHLENGTH];
    DR_hdr  	hdr;
    int		i;
    float	*data;
    char	*direction;
    int		dflag = 1;
    int		index[MAX_INDEX];

    read_syscom();                  /* ǂ܂Ȃ炵Dׂ */

    if ( ( filename = GetString( 0 ) ) == NULL )
    {
	exit( 1 );              /* 叫, t@CȂbɂȂ߂ */
    }
    direction = (char *)GetString( 1 );
    if( direction != NULL ){
      switch( direction[0] ){
      	case 'T':
	  dflag = 0;
	  break;
	case 'D':
	  dflag = 1;
	  break;
	defaults:
	  dflag = 1;
	  break;
	}
    }

    strcpy( hdr.fname_base, filename );
    ReadHeader( &hdr );                               /* wb_ǂݍ */
    data = ReadData_f( &hdr );                         /*  f[^ǂݍ  */
    for ( i = 0; i < hdr.num_series; i++ )
    {                              /* `lƂɃZ[uD܂ */
	strcpy( distname, filename );
	strcat( distname, "_" );                          /* t@C */
	strcat( distname, hdr.name_ch[i] ); /* wb_̃`lgp */
	strcat( distname, ".dat" ); 
	if( dflag == 0 ){
	  WriteFile( distname, 1, (int *)&hdr.num_samps, 
		    (char *)&data[hdr.num_samps * i] );
	}else{
	  index[0] = 1;
	  index[1] = hdr.num_samps;
	  WriteFile( distname, 2, index,
		    (char *)&data[hdr.num_samps * i] );
	}
    }                                                     /* ݂` */

    return 0;                                /* ܂łΕ͂߂ */
}                                                           /* ق, Ȃ */
