#include <stdio.h>
#include <signal.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
  
int main()
{
  register int  i;
  FILE         *fp;
  char          str[FILE_LENGTH];
  char         *base;
  GpmWinID      win[MAX_WIN];
  
  read_syscom();

  base = get_tmpdir();
  sprintf(str, "%s%s", base, WIN_FNAME);

  if (access(str, 0) == -1)
    return 0;
  
  if((fp = fopen(str, "r")) != NULL) {
    fread( (char *)win, sizeof(GpmWinID), MAX_WIN, fp );
    fclose(fp);
    unlink(str); 
  } else
    return 0;
  
  for (i = 0; i < 10; i++) {
    if (win[i].pid != 0 && win[i].pid != -1 )
      kill(win[i].pid , SIGHUP);
  }

  sprintf(str, "%s%s", base, GPM_file);
  unlink(str);
  sprintf(str, "%s%s", base, GPM_file2);
  unlink(str);
  return 0;
}
