/****************************************************************
*       DRAW GRAPH     For EWS                                  *
*---------------------------------------------------------------*
*     graph( IC1,IC2,I3,I4,I5,I6,F7 )                           *
*       IC1 : y axis data ------------buf_num[0]                *
*       IC2 : x axis data ------------time_freq[1],buf_num[1]   *
*       I3  : xy axis display type----axis_type                 *
*       I4  : display line type-------line_type                 *
*       I5  : I6-1 ten oki hyouji-----increment                 *
*       I6  : center symbol type------symbol_type               *
*       F7  : size  of center symbol--center_symbol             *
*---------------------------------------------------------------*
*            S.Hitomi           DATE : 1992, 12, 1              *
*            K.Takebe           DATE : 1994,  3, 5              *
****************************************************************/
#include <stdio.h>
#include <string.h>
#include <math.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
#include "graph_sub.h"

float **xdata, **ydata;

int
main()
{
  int          dimx, indexx[MAX_INDEX];
  int          dimy, indexy[MAX_INDEX];
  int          axis_type, line_type, symbol_type, increment;
  int          n_series, nx_series, ny_series;
  char         *str, time_freq_x = '?', time_freq_y = '?';
  float        center_symbol, rleng;
  Buffer       *bufx, *bufy;
  int          length, is;
  register int i;
  
  /********* Load system parameter **********/
  read_syscom();
  regpm();
  if (checktodvi() == True)
    writegpm();
  
  /********* Get X-Y Data from SATELLITE Language *********/
  /* Get Y-Data */
  str = (char *) GetString(0);
  if (strlen(str) == 1)
    time_freq_y = *str;
  bufy = (Buffer *)GetSeries(0, &dimy, indexy);
  
  /* Get X-Data */
  str = (char *) GetString(1);
  if (strlen(str) == 1)
    time_freq_x = *str;
  bufx = (Buffer*)GetSeries(1, &dimx, indexx);
  
  if(bufx == NULL && bufy == NULL)
    exit(17);
  
  /********* Get Parameter from SATELLITE Language *********/
  axis_type     = (int)   GetScalar(2);
  line_type     = (int)   GetScalar(3);
  increment     = (int)   GetScalar(4);
  symbol_type   = (int)   GetScalar(5);
  center_symbol = (float) GetScalar(6);

  
  /********** Parameters Check *********/
  if (axis_type < 0 || axis_type > 4 ) /* Log or Linear Axis */
    exit(20);

  if ( axis_type != 0 )
    GpmCont.axisType = (short) (axis_type % 4); /* if type = 4, put on 0 */
  /* if axis_type = 0, graph will be draw within scale command setting */

  disp_scale_mode(GpmCont.xMode, GpmCont.yMode);/* Scale Auto or Manual */
  
  if (symbol_type < 0 || symbol_type > 31)	/* Set Center Symbol */
    exit(28);

  /* Increment */
  increment = (increment <= 0) ? 1 : (short) increment;
  
  /* Length of Center Symbol */
  rleng = (center_symbol <= 0.0) ? 0.25 : center_symbol;
  
  /********** Data Check *********/
  if(bufx == NULL) {
    dimx = dimy;
    CopyIndex(indexx, indexy, dimy);
    bufx = (Buffer *)CAllocBuffer(IndexSize(dimx, indexx));
  }
  if(bufy == NULL) {
    dimy = dimx;
    CopyIndex(indexy, indexx, dimx);
    bufy = (Buffer *)CAllocBuffer(IndexSize(dimy, indexy));
  }
  nx_series = IndexSize(dimx - 1, SubIndex(indexx));
  ny_series = IndexSize(dimy - 1, SubIndex(indexy));
  nx_series = (nx_series == 0) ? 1 : nx_series;
  ny_series = (ny_series == 0) ? 1 : ny_series;
  
  /********* Memory Allocation for FLOAT DATA *********/
  xdata = (float **) malloc(nx_series * sizeof(float *));
  for (i = 0; i < nx_series; i++)
    xdata[i] = (float *) malloc(indexx[0] * sizeof(float));
  
  ydata = (float **) malloc(ny_series * sizeof(float *));
  for (i = 0; i < ny_series; i++)
    ydata[i] = (float *) malloc(indexy[0] * sizeof(float));
  
  /*********** Set Y-Scale ***********/
  set_data(time_freq_x, dimx, indexx, bufx);
  set_data(time_freq_y, dimy, indexy, bufy);
  
  btof(dimx, indexx, bufx, xdata);
  btof(dimy, indexy, bufy, ydata);
  
  is = ( zerop(nx_series, xdata) &&
	( ( GpmCont.axisType == 1 ) || ( GpmCont.axisType == 3 ) ))
    || ( zerop(ny_series, ydata) &&
	( ( GpmCont.axisType == 2 ) || ( GpmCont.axisType == 3 ) ));
  SetXscale(xdata, nx_series, indexx[0], is);
  SetYscale(ydata, ny_series, indexy[0], is);
  
  /**********  GPM Window OPEN ***********/
  OpenWindow();
  SetScale();
  
  /**********   Drawing Loop   ********/
  n_series = Min(nx_series, ny_series);
  length   = Min(indexx[0], indexy[0]);
  for (i = 0; i < n_series; i++) {
    /***** DRAW GRAPH *****/
    graph(&xdata[i][is], &ydata[i][is],
	  length - is, (int) increment,
	  (int) line_type, (int) symbol_type, rleng);
  }
  puts("");
  CloseWindow();
  write_syscom();
  wrgpm();
  return 0;
}
