/* 
 * LINE.C 
 *
 * T.KOBAYASHI 1.4.89 
 *
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
  
  
int
main()
{
  float rnumer[4];
  char  *ialpha;

  /* LOAD SYSTEM PARAMETER */
  read_syscom();
  regpm();

  rnumer[0] = (float)GetScalar(0);
  rnumer[1] = (float)GetScalar(1);
  rnumer[2] = (float)GetScalar(2);
  rnumer[3] = (float)GetScalar(3);
  ialpha    =        GetString(4);

  if (checktodvi() == True)
    writegpm();

  /* LINE DRAW */
  gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device,
	GpmCont.winNum);
  
  gnewpen(GpmCont.gColor);
  gpen(GpmCont.gLineWidth, GpmCont.gLineType, 0);
  gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
  gfactor(GpmCont.factor);

  if ( ialpha != NULL && strlen(ialpha) > 0 && ialpha[0] == 'B') {
    if ( strlen(ialpha) > 1 && ialpha[1] == 'F')
      gbox(rnumer[0], rnumer[1], rnumer[2], rnumer[3], 3, 0.);
    else
      gbox(rnumer[0], rnumer[1], rnumer[2], rnumer[3], 1, 0.);
  } else {
    gplot(rnumer[0], rnumer[1], 0);
    gplot(rnumer[2], rnumer[3], 2);
  }
  
  gclose();
  
  write_syscom();
  wrgpm();
  return 0;
}
