/*****************************************************
*   Set Le1gth of Axis                               *
*----------------------------------------------------*
*    size  len1 , len2                               *
*      len1 : length of x-axis                       *
*      len2 : length of y-axis                       *
*----------------------------------------------------*
*                  1986 , 7 , 4                      *
*****************************************************/
#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"


int
main()
{
  float xsize, ysize;
  
  /***** Load System Parameter *****/
  read_syscom();
  regpm();
  
  xsize = (float)GetScalar(0);
  ysize = (float)GetScalar(1);

  if ( xsize <= 0.0 || ysize <= 0.0 )
    exit(2);
  
  GpmCont.xSize = xsize;
  GpmCont.ySize = ysize;
  
  /***** Store System Parameter *****/
  write_syscom();
  wrgpm();
  return 0;
}
