#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif


#define REAL_REAL	0
#define INT_REAL	1
#define REAL_INT	2
#define INT_INT		3

#define NON	0
#define REAL	1
#define INTEGER 2

#define ON_THE_AXIS	0
#define UNDER_THE_AXIS	1

#define LNR_LNR 0
#define LOG_LNR 1
#define LNR_LOG 2
#define LOG_LOG 3

#define Match(a,b)	(!strcmp(a,b))

static int   LabelFormat _ANSI_ARGS_((int side, char *axis_label,
				      int label_type));
static void  AxisType    _ANSI_ARGS_((int side, float *x, float *y,
				      int *label_pos, float *theta));
static void  errorCheck  _ANSI_ARGS_((int a, int b, int c));


int
main()
{
  int    label_pos, igrx, igry, itype;
  int    index, label_type, labFormat;
  int    title_no;
  float  theta;
  float  x, y, fmin, fmax, chr_size, scale_x, scale_y;
  char   *ttl_p, *axis_label, *axis_bar;
  
  
  /* LOAD SYSTEM PARAMETER */
  read_syscom();
  regpm();

  if (checktodvi() == True)
    writegpm();
  
  title_no         = (int)  GetScalar(0) - 1;
  GpmCont.axisDraw = (char) GetScalar(1);
  axis_bar         =        GetString(2);
  axis_label       =        GetString(3);
  chr_size         = (float)GetScalar(4);
  itype            = (int)  GetScalar(5);
  label_type       = (int)  GetScalar(6);
  scale_x          = (float)GetScalar(7);
  scale_y          = (float)GetScalar(8);
  index            = (int)  GetScalar(9);

  errorCheck((int)GpmCont.axisDraw, itype, label_type);
  
  igrx = ( itype == 1 || itype == 3) ? 1 : 0;
  igry = ( itype == 2 || itype == 3) ? 1 : 0;
  igrx *=(int) (GpmCont.fLineType + 1);
  igry *=(int) (GpmCont.fLineType + 1);
  
  gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device,
	GpmCont.winNum);
  gfactor(GpmCont.factor);
  gnewpen(GpmCont.fColor);
  gpen(GpmCont.fLineWidth, GpmCont.fLineType, 0 );
  gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
  gfont(GpmCont.fontType);
  
  /* DRAW X-AXIS */
  if (Match(axis_bar, "X") || Match(axis_bar, "XY")) {
    ttl_p = GpmCont.title_x[title_no];
    
    AxisType('X', &x, &y, &label_pos, &theta);
    labFormat = LabelFormat('X', axis_label, label_type);
    if (GpmCont.axisType == LNR_LNR || GpmCont.axisType == LNR_LOG) {
      if (index == 1)           
	labFormat *= -1;
      fmin = GpmCont.xMin;
      fmax = GpmCont.xMax;
      gaxis(x, y, GpmCont.xSize, theta, fmin, fmax,
	    scale_x, labFormat, label_pos, ttl_p,
	    chr_size, igrx, GpmCont.ySize);
    } else {
      fmin = (GpmCont.xMin > 0.0 ) ?
	(float)log10(fabs((double)(GpmCont.xMin)))       : 1.0e-37;
      fmax = (GpmCont.xMax > 0.0 ) ?
	      (float)log10(fabs((double)(GpmCont.xMax))) : 1.0e-37;

      gaxisl(x, y, GpmCont.xSize, theta, fmin, fmax,
	     labFormat, label_pos, ttl_p, chr_size, igrx,
	     GpmCont.ySize);
    }
  }
  /* DRAW Y-AXIS */
  if (Match(axis_bar, "Y") || Match(axis_bar, "XY")) {
    ttl_p = GpmCont.title_y[title_no];
    
    AxisType('Y', &x, &y, &label_pos, &theta);
    labFormat = LabelFormat('Y', axis_label, label_type);
    if (GpmCont.axisType == LNR_LNR || GpmCont.axisType == LOG_LNR) {
      if (index == 1)            
	labFormat *= -1;
      fmin = GpmCont.yMin;
      fmax = GpmCont.yMax;
      gaxis(x, y, GpmCont.ySize, theta, fmin, fmax,
	    scale_y, labFormat, label_pos, ttl_p, chr_size,
	    igry, GpmCont.xSize);
    } else {
      fmin = (GpmCont.yMin > 0.0 ) ?
	(float)log10(fabs((double)(GpmCont.yMin)))       : 1.0e-37;
      fmax = (GpmCont.yMax > 0.0 ) ?
	      (float)log10(fabs((double)(GpmCont.yMax))) : 1.0e-37;

      gaxisl(x, y, GpmCont.ySize, theta, fmin, fmax,
	     labFormat, label_pos, ttl_p, chr_size, igry,
	     GpmCont.xSize);
    }
    
  }
  gclose();
  
  /* STORE SYSTEM PARAMETER */
  write_syscom();
  wrgpm();
  return 0;
}


#define  OutOfRange(x,MiN,MaX)	(x < MiN || x > MaX)

static void
errorCheck( a, b, c)
    int a, b, c;
{
  /* AXIS DRAW STYLE   (0 .. 3) */
  if (OutOfRange( a, 1, 4))
    exit(20);
  
  /* GRID DRAW   (0 ... 3)  */
  if (OutOfRange( b, 0, 3))
    exit(21);
  
  /* SCALE FORMAT TYPE  (0 ... 3) */
  if (OutOfRange( c, 0, 3))
    exit(22);
}


#define LEFT_LOW 1
#define LEFT_UP 2
#define RIGHT_LOW 3
#define RIGHT_UP 4

static void
AxisType(side, x, y, label_pos, theta)
     int            side;
     float          *x, *y;
     int            *label_pos;
     float          *theta;
{
  *x = *y = 0.0;
  
  if (side == 'X') {
    *label_pos = UNDER_THE_AXIS;
    if (GpmCont.axisDraw == LEFT_UP ||
	GpmCont.axisDraw == RIGHT_UP) {
      *y = GpmCont.ySize;
      *label_pos = ON_THE_AXIS;
    };
    
    *theta = 0.0;
    
  } else if (side == 'Y') {
    *label_pos = ON_THE_AXIS;
    if (GpmCont.axisDraw == RIGHT_LOW ||
	GpmCont.axisDraw == RIGHT_UP) {
      *x = GpmCont.xSize;
      *label_pos = UNDER_THE_AXIS;
    };
    
    *theta = M_PI/2.0;
  }
}

static int
LabelFormat(side, axis_label, label_type)
     int    side;
     char  *axis_label;
     int    label_type;
{
  int             labFormat = REAL;
  
  switch (label_type) {
  case INT_INT:
    labFormat = INTEGER;
    break;
  case REAL_REAL:
    labFormat = REAL;
    break;
  case INT_REAL:
    labFormat = (side == 'X') ? INTEGER : REAL;
    break;
  case REAL_INT:
    labFormat = (side == 'X') ? REAL : INTEGER;
    break;
  }
  
  /* Mismatch */
  if (axis_label[0] != side && axis_label[1] != side)
    labFormat = NON;
  
  return labFormat;
}
