#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
  
  
int
main()
{
  int        w_no;
  char       str[FILE_LENGTH];
  FILE      *w_file;
  GpmWinID   win[MAX_WIN];
  
  read_syscom();
  regpm();

  w_no = (int)GetScalar(0);
  if (w_no < 1 || w_no > MAX_WIN)
    exit(35);
  
  w_no--;
  
  strcpy(str, get_tmpdir());
  strcat(str, WIN_FNAME);
  
  if (access(str, 0) == -1)
    exit(34);
  
  w_file = fopen(str, "r");
  fread((char *)win, sizeof(GpmWinID), MAX_WIN, w_file);
  fclose(w_file);
  
  if ( w_no == GpmCont.winNum )
    exit(0); /* nothing to do, because of same window */
  
  if ( win[w_no].pid == 0)
    exit(24);
  
  strcpy(str, get_tmpdir());
  strcat(str, GPM_file2);
  
  if (access(str, 0) == -1)
    exit(34);
  
  wrgpm2( GpmCont.winNum );
  GpmCont.winNum = w_no;
  regpm2( GpmCont.winNum );

  wrgpm();
  write_syscom();
  return 0;
}
