/*****************************************************
*                                                    *
*   DRAW CONTOUR LINE     New Parameter              *
*                                                    *
*   C Version  Rel 1.0    T.Kobayashi  90/08/31      *
*   Buffer Version        T.Kobayashi  90/08/31      *
*   on SATELLITE Language S.Hitomi     92/11/17      *
*                                                    *
*****************************************************/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"

extern void contln _ANSI_ARGS_((float **alt, int **ksw, int nx, int ny,
				float heit[], int nhd, int kh,
				double hx, double hy, int mode));

int
main()
{
  float **data, heit[500];
  int   **data2;
  double step, zMax, zMin;
  int   index[MAX_INDEX];
  int   bufno, i, j, kh, viewpoint, nx, ny, mode;
  char  *timeaxis;
  double rmin, rmax, hx, hy;
  
  
  /* LOAD SYSTEM PARAMETER */
  read_syscom();
  regpm();
  
  if (checktodvi() == True)
    writegpm();
  
  /* this command needs 5 parameters */
  bufno     = GetBufferID(0);
  step      = GetScalar(1);
  timeaxis  = GetString(2);
  viewpoint = ((int)GetScalar(3) > 0 ) ? 1 : -1;
  mode      = ((int)GetScalar(4) > 0 ) ? 1 : 0;
  
  if ( bufno == 0 || GetBufferInfo(bufno, index) != 2)
    exit(16);

  if ( step <= 0.0 ) {
    printf("illegal step\n");
    exit(2);
  }  

  if ( *timeaxis == 'X' || *timeaxis == 'x' ) {
    nx = index[0];
    ny = index[1];
  } else {
    nx = index[1];
    ny = index[0];
  }
  
  data2 = (int **) _malloc2d(nx, ny, sizeof(int));
  data  = ldata(bufno, nx, ny, timeaxis, viewpoint);
  if(data == NULL)
    exit(4);
  
  rmin = data[0][0];
  rmax = data[0][0];
  
  for (i = 0; i < nx; i++)
    for (j = 0; j < ny; j++) {
      if (data[i][j] > rmax)
	rmax = data[i][j];
      if (data[i][j] < rmin)
	rmin = data[i][j];
    }
  
  hx = GpmCont.xSize / (float) (nx - 1);
  hy = GpmCont.ySize / (float) (ny - 1);

  if ( GpmCont.xMode == 0 ) {
    GpmCont.xMin = 0.0;
    GpmCont.xMax = (float)(nx-1);
  }

  if ( GpmCont.yMode == 0 ) {
    GpmCont.yMin = 0.0;
    GpmCont.yMax = (float)(ny-1);
  }
  GpmCont.axisType = 0;

  if ( GpmCont.zMode == 0 ) {
    GpmCont.zMin = zMin = rmin;
    GpmCont.zMax = zMax = rmax;
  } else {
    zMin = GpmCont.zMin;
    zMax = GpmCont.zMax;
/*
    if ( GpmCont.zType == 1 ) {
      zMin = (zMin > 0.0 ) ? log10(zMin) : -10;
      zMax = (zMax > 0.0 ) ? log10(zMax) :  10;
    }
*/
  }  

  kh = 0;
  for (i = 1; i <= 1000; i++) {
    kh++;
    heit[kh - 1] = zMin + (double) (i - 1) * step;

    if (heit[kh - 1] > zMax || heit[kh - 1] > rmax) {
      kh--;
      if (kh <= 0)
	exit(25);
      break;
    }
    if (heit[kh - 1] < rmin)
      kh--;
    if (kh == 500)
      break;
  }
  
  printf("  Matrix Size  %d x %d\n", nx, ny);
  printf("  (scale: min = %g, max = %g,", zMin, zMax);
  printf(" data: min = %g, max = %g)\n", rmin, rmax);
  
  gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device,GpmCont.winNum);
  gfactor(GpmCont.factor);
  gnewpen(GpmCont.gColor);
  gpen(GpmCont.gLineWidth, GpmCont.gLineType, 0);
  gorigin(GpmCont.xOrigin, GpmCont.yOrigin);

  i = 500;
  contln(data, data2, nx, ny, heit, i, kh, hx, hy, mode);
  gplot( mgraph.xpre, mgraph.ypre, 2);
  
  gclose();
  wrgpm();
  write_syscom();
  return 0;
}
