#include <X11/Xlib.h>
#include <stdio.h>
#include <math.h>
#include "GPMdef.h"
#include "GPMwin.h"

#define IPENMODE 1

/******************************************************
 *                                                    *
 *   contour line                                     *
 *                                                    *
 ******************************************************/
static void cpen   _ANSI_ARGS_((double data, double amin, double amax));
static void search _ANSI_ARGS_((float **alt, int **ksw, int nx, int ny,
				double hx, double hy, double hv, int kv,
				int ia, int ja, int *it, int *jt, int ks,
				int *irep));
void        contln _ANSI_ARGS_((float **alt, int **ksw, int nx, int ny,
				float heit[], int nhd, int kh,
				double hx, double hy, int mode));

void
contln(alt, ksw, nx, ny, heit, nhd, kh, hx, hy, mode)
     float **alt, heit[];
     double hx, hy;
     int   **ksw, nx, ny, nhd, kh, mode;
{
  double hv, w, w1, v = 0.0, v1;
  int   i, ia, irep, it, j, ja, jt, k, ks = 0, kv, kx, ky;
  
  for (i = 0; i < nx; i++)
    for (j = 0; j < ny; j++)
      ksw[i][j] = 0;
  
  for (k = 1; k <= kh; k++) {
    kv = k;
    hv = heit[kv - 1];
    if ( mode )
      cpen(hv, heit[0], heit[kh - 1]);
    
    for (kx = 1; kx <= nx; kx++) {
      for (ky = 2; ky <= ny; ky++) {
	if (kx != 1) {
	  w1 = alt[kx - 2][ky - 2] - hv;
	  w  = alt[kx - 1][ky - 2] - hv;
	  if (w1 > 0.0 && w < 0.0) {
	    ia = kx - 1;
	    ja = ky - 1;
	    it = 0;
	    jt = 1;
	    ks = 1;
	    search(alt,ksw,nx,ny,hx,hy,hv,kv,ia,ja,&it,&jt,ks,&irep);
	  }
	  if (w1 < 0.0 && w > 0.0) {
	    ia = kx;
	    ja = ky - 1;
	    it = 0;
	    jt = 1;
	    ks = -1;
	    search(alt,ksw,nx,ny,hx,hy,hv,kv,ia,ja,&it,&jt,ks,&irep);
	  }
	}
	v1 = alt[kx - 1][ky - 2] - hv;
	if (ksw[kx - 1][ky - 2] == kv)
	  continue;
	v = alt[kx - 1][ky - 1] - hv;
	if (ksw[kx - 1][ky - 1] == kv)
	  continue;
	
	/* alt(kx,ky-1)  >  hv */
	if (v1 > 0.0) {
	  if (v >= 0.0)
	    continue;
	  irep = 0;
	  if (kx != nx) {
	    ia = kx;
	    ja = ky - 1;
	    it = 1;
	    jt = 0;
	    ks = -1;
	    search(alt,ksw,nx,ny,hx,hy,hv,kv,ia,ja,&it,&jt,ks,&irep);
	    if (irep >= 2)
	      continue;
	  }
	  if (kx == 1)
	    continue;
	  ia = kx;
	  ja = ky - 1;
	  it = -1;
	  jt = 0;
	  ks = 1;
	  ksw[ia - 1][ja - 1] = 0;
	  search(alt,ksw,nx,ny,hx,hy,hv,kv,ia,ja,&it,&jt,ks,&irep);
	  continue;
	} else if (v1 < 0.0) {
	  
	  /* alt(kx, ky - 1) < hv */
	  if (v <= 0.0)
	    continue;
	  irep = 0;
	  if (kx != nx) {
	    ia = kx;
	    ja = ky;
	    it = 1;
	    jt = 0;
	    ks = 1;
	    search(alt,ksw,nx,ny,hx,hy,hv,kv,ia,ja,&it,&jt,ks,&irep);
	    if (irep >= 2)
	      continue;
	  }
	  if (kx == 1)
	    continue;
	  ia = kx;
	  ja = ky;
	  it = -1;
	  jt = 0;
	  ks = -1;
	  ksw[ia - 1][ja - 1] = 0;
	  search(alt,ksw,nx,ny,hx,hy,hv,kv,ia,ja,&it,&jt,ks,&irep);
	  continue;
	} else {
	  /* alt(kx,ky-1)  ==  hv */
	  ia = kx;
	  ja = ky - 1;
	  search(alt,ksw,nx,ny,hx,hy,hv,kv,ia,ja,&it,&jt,ks,&irep);
	}
      }
      if (kx == nx)
	continue;
      if (v == 0.0) {
	ia = kx;
	ja = ny;
	search(alt,ksw,nx,ny,hx,hy,hv,kv,ia,ja,&it,&jt,ks,&irep);
      }
    }
  }
}



/******************************************************
 *                                                    *
 *    Draw Contour Line                               *
 *                                                    *
 ******************************************************/
static void
search(alt, ksw, nx, ny, hx, hy, hv, kv, ia, ja, it, jt, ks, irep)
     float **alt;
     double hx, hy, hv;
     int   **ksw, nx, ny, kv, ia, ja, *it, *jt, ks, *irep;
{
  float alx, alxt, aly, alyt;
  float rt, ua1, ua2, ud1, ud2, ud3, va1, va2, vd1, vd2;
  int   iait, iat, iav, ii, ip, itv, jajt, jav, jtv, k, l, ln;
  
  /* To Draw Contour Line */
  ua1 = alt[ia - 1][ja - 1];
  if (ua1 != hv) {
    
    itv = ks * (*jt);
    jtv = -ks * (*it);
    iait = ia + itv;
    jajt = ja + jtv;
    ua2 = alt[iait - 1][jajt - 1];
    rt = (ua1 - hv) / (ua1 - ua2);
    alx = hx * ((float) (ia - 1) + rt * (float) itv);
    aly = hy * ((float) (ja - 1) + rt * (float) jtv);

    gplot(alx, aly, 0);
    
    ln = 800;
    *irep = 0;
    
    for (l = 2; l <= ln; l++) {
      if (ksw[ia - 1][ja - 1] == kv)
	return;
      iav = ia + *it;
      jav = ja + *jt;
      if (iav <= 0 || iav > nx || jav <= 0 || jav > ny) {
	ksw[ia - 1][ja - 1] = kv;
	return;
      }
      va1 = alt[iav - 1][jav - 1];
      ud1 = ua1 - hv;
      vd1 = va1 - hv;
      
      if (vd1 <= 0.0) {
	
	/* va1  <=  hv */
	*irep += 1;
	rt = (ua1 - hv) / (ua1 - va1);
	alx = hx * ((float) (ia - 1) + rt * (float) *it);
	aly = hy * ((float) (ja - 1) + rt * (float) *jt);
	gplot(alx, aly, IPENMODE);
	if (vd1 == 0.0)
	  return;
	itv = *it;
	*it = -ks * *jt;
	*jt = ks * itv;
	ua2 = va1;
	if (*irep >= 4) {
	  ksw[ia - 1][ja - 1] = kv;
	  return;
	}
	continue;
      }
      /* va1  >  hv */
      *irep = 0;
      itv = ks * (*jt);
      jtv = -ks * (*it);
      iav = iav + itv;
      jav = jav + jtv;
      va2 = alt[iav - 1][jav - 1];
      vd2 = va2 - hv;
      
      if (vd2 <= 0.0) {
	rt = (va1 - hv) / (va1 - va2);
	alx = hx * ((float) (ia + *it - 1) + rt * (float) itv);
	aly = hy * ((float) (ja + *jt - 1) + rt * (float) jtv);
	gplot(alx, aly, IPENMODE);
	if (vd2 == 0.0)
	  return;
	ksw[ia - 1][ja - 1] = kv;
	ia = ia + *it;
	ja = ja + *jt;
	ua1 = va1;
	ua2 = va2;
	continue;
      }
      ud2 = ua2 - hv;
      itv = ks * *jt;
      jtv = -ks * *it;
      rt = (ua2 - hv) / (ua2 - va2);
      alx = hx * ((float) (ia + itv - 1) + rt * (float) (*it));
      aly = hy * ((float) (ja + jtv - 1) + rt * (float) (*jt));
      gplot(alx, aly, IPENMODE);
      if (ud2 == 0.0)
	return;
      ksw[ia - 1][ja - 1] = kv;
      ia = ia + (*it) + itv;
      ja = ja + (*jt) + jtv;
      *it = itv;
      *jt = jtv;
      ua1 = va2;
    }
    return;
  } else {
    if (ksw[ia - 1][ja - 1] == kv)
      return;
    
    /* Alt(ia,ja)  ==  hv */
    alx = hx * (float) (ia - 1);
    aly = hy * (float) (ja - 1);
    alxt = hx * (float) ia;
    alyt = hy * (float) ja;
    ip = 0;
    if (ia != nx) {
      ud1 = alt[ia][ja - 1] - hv;
      if (ud1 == 0.0) {
	gplot(alx, aly, 0);
	gplot(alxt, aly, IPENMODE);
	ip = 1;
      }
    }
    if (ja != ny) {
      ud2 = alt[ia - 1][ja] - hv;
      if (ud2 == 0.0) {
	gplot(alx, aly, 0);
	gplot(alx, alyt, IPENMODE);
	ip = 1;
      } else {
	
	ii = 1;
	for (k = 1; k <= 2; k++) {
	  iat = ia + ii;
	  alxt = hx * (float) (iat - 1);
	  if (iat >= 1 && iat <= nx) {
	    ud1 = alt[iat - 1][ja - 1] - hv;
	    ud3 = alt[iat - 1][ja] - hv;
	    if (ud1 != 0.0 && ud3 == 0.0) {
	      gplot(alx, aly, 0);
	      gplot(alxt, alyt, IPENMODE);
	      ip = 1;
	    } else {
	      if (ud2 * ud3 < 0.0) {
		rt = ud2 / (ud2 - ud3);
		alxt = hx * ((float) (ia - 1) + rt * (float) ii);
		gplot(alx, aly, 0);
		gplot(alxt, alyt, IPENMODE);
		ip = 1;
	      }
	    }
	  }
	  ii = -1;
	}
      }
    }
    if (ip != 0) {
      ksw[ia - 1][ja - 1] = kv;
    }
  }
}


static void
cpen(data, amin, amax)
     double data, amin, amax;
{
  double level;
  
  level = (data - amin) / (amax - amin);
  grainbow(level);
}
