/************************************************
*                                               *
*        DRAW LINE                              *
*                                               *
*************************************************
*                                               *
*        DRAW   C1, I2                          *
*-----------------------------------------------*
*                                               *
*        C1   :   X or Y                        *
*                                               *
*        I2   :  LEVEL                          *
*                                               *
*************************************************
*                                               *
*        T.KOBAYASHI         12/22/88           *
*                                               *
************************************************/
#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"

int
main()
{
  char  *alpha;
  int   axis;
  float val, point, rmax, rmin, rleng;
  
  
  /* LOAD SYSTEM PARAMETER */
  read_syscom();
  regpm();

  alpha =        GetString(0);
  val   = (float)GetScalar(1);
  
  if (checktodvi() == True)
    writegpm();
  
  /* SET PARAMETER */
  switch (*alpha) {
  case 'X':  axis = 0; break;
  case 'Y':  axis = 1; break;
  default:
    exit(20);
  }
  
  if (axis == 1) {
    if (GpmCont.axisType == 2 || GpmCont.axisType == 3)
      val = (val > 0.0 ) ? (float) log10((double) val) : -110.0;
    rleng = GpmCont.ySize; /* spara.y_leng */
    switch (GpmCont.axisType) {
    case 2: case 3:
      rmax = (GpmCont.yMax > 0.0) ?
	(float)log10(fabs((double)GpmCont.yMax)) : -100.0;
      rmin = (GpmCont.yMin > 0.0) ?
	(float)log10(fabs((double)GpmCont.yMin)) : -100.0;
      if ( rmax == rmin )
	rmin = rmax -1.0;
      break;
    case 0: case 1: default:
      rmax = GpmCont.yMax;
      rmin = GpmCont.yMin;
      break;
    }
  } else {
    if (GpmCont.axisType == 1 || GpmCont.axisType == 3)
      val = (val > 0.0 ) ? (float) log10((double) val) : -110.0;
    rleng = GpmCont.xSize;
    switch (GpmCont.axisType) {
    case 1: case 3: 
      rmax = (GpmCont.xMax > 0.0) ?
	(float)log10(fabs((double)GpmCont.xMax)) : -100.0;
      rmin = (GpmCont.xMin > 0.0) ?
	(float)log10(fabs((double)GpmCont.xMin)) : -100.0;
      if ( rmax == rmin )
	rmin = rmax -1.0;
      break;
    case 0: case 2: default:
      rmax = GpmCont.xMax;
      rmin = GpmCont.xMin;
      break;
    }
  }

  /* DRAW LINE */
  if (val < rmin || val > rmax)
    printf("drawl: not draw line (over range).\n");
  else {
    point = (val - rmin) / (rmax - rmin) * rleng;

    gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device, GpmCont.winNum);
    gnewpen(GpmCont.fColor);
    gpen(GpmCont.fLineWidth, GpmCont.fLineType, 0);
    gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
    gfactor(GpmCont.factor);

    if (axis == 0) {
      gplot(point, 0.0, 0);
      gplot(point, GpmCont.ySize, 2);
    } else {
      gplot(0.0, point, 0);
      gplot(GpmCont.xSize, point, 2);
    }

    gclose();
  }
  
  write_syscom();
  wrgpm();
  return 0;
}
