/**********************************************************************
*            S.Hitomi           DATE : 1992, 12, 1                    *
*            K.Takebe           DATE : 1993, 12, 8                    *
**********************************************************************/

#include <stdio.h>
#include <string.h>
#include <math.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
#include "graph_sub.h"

int
main()
{
  int          dimx = 1, indexx[MAX_INDEX];
  int          dimy = 1, indexy[MAX_INDEX];
  int          axis_type, line_type, symbol_type, increment;
  char         *str1, *str2, time_freq_x = '?', time_freq_y = '?';
  float        **xdata, **ydata;
  float        **dat1, **dat2, tmp, maximum, minimum;
  float        dxMin, dxMax, dyMin, dyMax;
  float        xdlt, ydlt, *max, *min;
  float        center_symbol, rleng, rleng1;
  Buffer       *bufx, *bufy, *bufz, *bufx1, *bufy1;
  Buffer       *btmp, *btmp1, *btmp2, *bufz1;
  int          *indexz;
  int          length, is;
  register int i, j;
  
  /********* Load system parameter **********/
  read_syscom();
  regpm();
  if (checktodvi() == True)
    writegpm();
  
  /********* Get X-Y Data from SATELLITE Language *********/
  /* Get Y-Data */
  str1 = (char *) GetString(0);
  if (strlen(str1) == 1)
    time_freq_y = *str1;
  bufy = (Buffer *)GetSeries(0, &dimy, indexy);
  
  /* Get X-Data */
  str2 = (char *) GetString(1);
  if (strlen(str2) == 1)
    time_freq_x = *str2;
  bufx = (Buffer*)GetSeries(1, &dimx, indexx);
  
  if( bufx == NULL && bufy == NULL )
    exit(17);
  else if (( bufx != NULL && dimx == 1 && bufy == NULL ) ||
           ( bufy != NULL && dimy == 1 && bufx == NULL ) ||
           ( bufx != NULL && bufy != NULL && dimx == 1 && dimy == 1))
    exit(17);

  if (( dimx > 2 && dimy > 2 ) || 
      ( bufx != NULL && dimx == 2 && !(indexx[1] == 3 || indexx[1] == 2 ))||
      ( bufy != NULL && dimy == 2 && !(indexy[1] == 3 || indexy[1] == 2 )))
    exit(17);


  /********* Get Parameter from SATELLITE Language *********/
  axis_type     = (int)   GetScalar(2);
  line_type     = (int)   GetScalar(3);
  increment     = (int)   GetScalar(4);
  symbol_type   = (int)   GetScalar(5);
  center_symbol = (float) GetScalar(6);

  
  /********** Parameters Check *********/
  if (axis_type < 0 || axis_type > 4)	/* Log or Linear Axis */
    exit(20);

  if ( axis_type != 0 )
    GpmCont.axisType = (short) (axis_type % 4); /* if type = 4, put on 0 */
  /* if axis_type = 0, graph will be draw within scale command setting */
  
  disp_scale_mode(GpmCont.xMode, GpmCont.yMode);
  
  if (symbol_type < 0 || symbol_type > 31)	/* Set Center Symbol */
    exit(28);

  /* Increment */
  increment = (increment <= 0) ? 1 : (short) increment;
  
  /* Length of Center Symbol */
  rleng = (center_symbol <= 0.0) ? 0.5 : center_symbol;
  
  /********** Data Check *********/
  if(bufx == NULL) {
    indexx[0] = indexy[0];
    bufx = (Buffer *)CAllocBuffer(indexx[0]);
  } else if ( bufy == NULL ) {
    indexy[0] = indexx[0];
    bufy = (Buffer *)CAllocBuffer(indexy[0]);
  }
  
  if ( bufx == NULL || bufy == NULL )
    exit(8);

  /*********** Set Y-Scale ***********/
  set_data(time_freq_x, dimx, indexx, bufx);
  set_data(time_freq_y, dimy, indexy, bufy);

  if( dimx == 1 ) {
    dimx = 2;
    indexx[1] = 1;
  }
  if ( dimy == 1 )  {
    dimy = 2;
    indexy[1] = 1;
  }
  
  length = Min(indexx[0], indexy[0]);

  if ( indexx[1] == 2 || indexy[1] == 2 ) {
    if ( indexx[1] == 2 ) {
      bufz   = bufx;
      indexz = indexx;
    } else {
      bufz   = bufy;
      indexz = indexy;
    }
    indexz[1]++;
    
    btmp  = (Buffer*)CAllocBuffer(IndexSize(dimx,indexz));
    bufz1 = bufz +1;
    btmp1 = btmp +1;
    btmp2 = btmp +2;

    for ( i = 0; i < length; i++ ) {
      j = i*2;
      btmp [i*3] = bufz[j];
      btmp1[i*3] = bufz[j] - bufz1[j]; 
      btmp2[i*3] = bufz[j] + bufz1[j]; 
    }
    if ( indexx[1] == 1 ) {
      bufx1 = bufx;
      bufy1 = btmp;
    } else {
      bufx1 = btmp;
      bufy1 = bufy;
    }
  } else {
    bufx1 = bufx;
    bufy1 = bufy;
  }    
    
  /********* Memory Allocation for FLOAT DATA *********/
  xdata = (float **) malloc( indexx[1] * sizeof(float *));
  for (i = 0; i < indexx[1]; i++)
    xdata[i] = (float *) malloc(indexx[0] * sizeof(float));
  
  ydata = (float **) malloc( indexy[1] * sizeof(float *));
  for (i = 0; i < indexy[1]; i++)
    ydata[i] = (float *) malloc(indexy[0] * sizeof(float));
  
  btof(dimx, indexx, bufx1, xdata); /* Buffer to Float */
  btof(dimy, indexy, bufy1, ydata); /* Buffer to Float */

  is = ( zerop(indexx[1], xdata) &&
	( ( GpmCont.axisType == 1 ) || ( GpmCont.axisType == 3 ) ))
    || ( zerop(indexy[1], ydata) &&
	( ( GpmCont.axisType == 2 ) || ( GpmCont.axisType == 3 ) ));

  if ( indexx[1] == 1 ) {
    dat1 = xdata;
    dat2 = ydata;
  } else {
    dat1 = ydata;
    dat2 = xdata;
  }
  min  = dat2[1];
  max  = dat2[2];

  SetXscale(xdata, indexx[1], indexx[0], is);
  SetYscale(ydata, indexy[1], indexy[0], is);

  /**********  GPM Window OPEN ***********/
  OpenWindow();
  SetScale();
  GetDrawScale( &dxMin, &dxMax, &dyMin, &dyMax );

  /**********   Drawing Loop   ********/
  if ( line_type < 3 || line_type >= 6 ) {
    xdlt = (dxMax - dxMin) / GpmCont.xSize;
    ydlt = (dyMax - dyMin) / GpmCont.ySize;
    rleng1 =  rleng / 2.0;
    if ( indexx[1] == 1 )
      for ( j = is; j < length; j += (int) increment ) {
	tmp     = ( dat1[0][j] - dxMin ) / xdlt;
	maximum = ( max [j]    - dyMin ) / ydlt;
	minimum = ( min [j]    - dyMin ) / ydlt;
	gplot( tmp,         maximum, 0 );
	gplot( tmp,         minimum, 1 );
	gplot( tmp - rleng1, maximum, 0 );
	gplot( tmp + rleng1, maximum, 1 );
	gplot( tmp - rleng1, minimum, 0 );
	gplot( tmp + rleng1, minimum, 2 );
      }
    else
      for ( j = is; j < length; j += (int) increment ) {
	tmp     = ( dat1[0][j] - dyMin ) / ydlt;
	maximum = ( max [j]    - dxMin ) / xdlt;
	minimum = ( min [j]    - dxMin ) / xdlt;
	gplot(maximum, tmp,         0 );
	gplot(minimum, tmp,         1 );
	gplot(maximum, tmp - rleng, 0 );
	gplot(maximum, tmp + rleng, 1 );
	gplot(minimum, tmp - rleng, 0 );
	gplot(minimum, tmp + rleng, 2 );
      }
  }
  if ( line_type < 6 )
    graph(&xdata[0][is], &ydata[0][is], length - is, (int)increment,
	  (int) line_type, (int) symbol_type, rleng);
  
  puts("");
  CloseWindow();
  write_syscom();
  wrgpm();
  return 0;
}
