#include <stdio.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"

char *gpm_dvifile;

extern int gpm_colorps_mode;


int paramCheck( argc, argv, name, mode, trayflag )
    int argc;
    char *argv[], **name;
    int *mode;
    int *trayflag;
{
  int i, flag;

  gpm_colorps_mode = 0;
  *trayflag = 0;

  *name = NULL;
  flag  = 0;
  *mode = 0;
  for ( i = 1; i < argc; i++ ) {
    if ( strcmp(argv[i],"-rv") == 0 ) {
      *mode = 1;
    } else if ( strcmp(argv[i],"-cps") == 0 ) {
      gpm_colorps_mode = 1;
    } else if ( strcmp(argv[i],"-tray") == 0 ) {
      *trayflag = 1;
    } else if ( *name == NULL ) {
      *name = argv[i];
      flag = 1;
    }
    
  }
  return flag;
}

int main(argc, argv)
    int    argc;
    char  *argv[];
{
  int     num;
  int     result;
  int     div     = RAINBOW_DIVNUM;
  int     basecol = RAINBOW_BASECOL;
  int     rollflag = 0;
  int     lwidth, ltype;
  int     pageNumber = 1, mode;
  int     paperSize, orientation, device;
  int     trayflag = 0;
  
  if ( paramCheck( argc, argv, &gpm_dvifile, &mode, &trayflag ) == 0 ) {
    strcpy( GpmCont.dvifile, "GPMDVIFILE1" );
    gpm_dvifile = GpmCont.dvifile;
  } else {
    strcpy( GpmCont.dvifile, gpm_dvifile );
  }

  opendvi_for_read();
  if ( readdvihead() == -1 ) {
    fprintf( stderr, "%s: %s is not GPM dvi file.\n\7", argv[0], gpm_dvifile );
    exit(1);
  }
  
  lseek( dvi_fd, strlen(gpm_head) + 5L, 0 );


  paperSize   = mdev.number  = GpmCont.paper;
  orientation = mdev.irotate = GpmCont.orientation;
  device      = GpmCont.device;

  getlength(mdev.number, &mgraph.xmax, &mgraph.ymax, mdev.irotate);
  
  mgraph.xmin = 0.0;
  mgraph.ymin = 0.0;
  
  ps_initAdobe((int)paperSize, (int)orientation, argv[0], gpm_dvifile );
  ps_init();
  if (trayflag) {
    ps_setTray((int)paperSize, (int)orientation);
  }
  ps_page(pageNumber);
  ps_open();
  ps_rainbow_mode(mode);
  
  do {
    
    result = readgpm();
    
    if ( rollflag == 1 && result > 0 ) {
      pageNumber++;
      ps_page(pageNumber);
    }

    if (result != 0) {
      
      ps_ginit();
      ps_factor((double)gpm_param.factor);
      ps_origin((double)gpm_param.xorg, (double)gpm_param.yorg);
      
      do {
	num = readdvi();
	
	if (num > 0) {
	  
	  switch (num) {
	    
	  case NPLOT:
	    if (gpm_plot.rainbow <= 0)
	      ps_color((int) gpm_plot.color);
	    else
	      ps_rainbow((double)(gpm_plot.rainbow)/(div*basecol));
	    
	    lwidth = (int) gpm_plot.lwidth;
	    ltype  = (int) gpm_plot.ltype;
	    
	    ps_lwidth(lwidth);
	    ps_ltype(ltype);
	    
	    ps_plot(gpm_plot.x, gpm_plot.y, (int)gpm_plot.ipen_mode);
	    rollflag = 0;
	    break;

	  case NBOX:
	    lwidth = (int) gpm_box.lwidth;
	    ltype = (int) gpm_box.ltype;
	    
	    ps_lwidth(lwidth);
	    ps_ltype(ltype);
	    
	    ps_box(gpm_box.x1,gpm_box.y1,gpm_box.x2,gpm_box.y2,gpm_box.mode,
		   gpm_box.level,(int)gpm_box.color);
	    rollflag = 0;
	    break;

	  case NCSYMBOL:
	    ps_color((int) gpm_csymbol.color);
	    ps_lwidth((int) gpm_csymbol.lwidth);
	    ps_csymbol(gpm_csymbol.x, gpm_csymbol.y, (int)gpm_csymbol.cdata,
		       gpm_csymbol.height);
	    rollflag = 0;
	    break;

	  case NLABEL:
	    ps_color((int) gpm_label.color);
	    ps_string(gpm_label.x,gpm_label.y,gpm_label.ichar,gpm_label.height,
		      gpm_label.theta, gpm_label.mode, gpm_label.font);
	    rollflag = 0;
	    break;

	  case NROLL:
	    ps_roll();
	    rollflag = 1;
	    break;
	  }
	}
      } while (num > 0);
    }
  } while (result > 0);
  
  closedvi();
  
  if (rollflag == 0)
    ps_roll();
  
  ps_pages(pageNumber);
  ps_close();
  return 0;
}
