#include <stdio.h>
#include <string.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"

void CloseWindow      _ANSI_ARGS_((void));
void OpenWindow       _ANSI_ARGS_((void));
void disp_scale_mode  _ANSI_ARGS_((int mode1, int mode2));
void scalg            _ANSI_ARGS_((float **data, float *amin, float *amax,
				   int n, int m, int is));
void scale            _ANSI_ARGS_((float **data, float *amin, float *amax,
				   int n, int m));
void btof             _ANSI_ARGS_((int dim, int *index,
				   Buffer *buf, float **data));
void set_data         _ANSI_ARGS_((int type, int dim, int *index,
				   Buffer *buf));
void SetScale         _ANSI_ARGS_((void));
void GetDrawScale     _ANSI_ARGS_((float *xMin, float *xMax,
				   float *yMin, float *yMax ));
void SetXscale        _ANSI_ARGS_((float **xdata, int n, int m, int is));
void SetYscale        _ANSI_ARGS_((float **ydata, int n, int m, int is));
int  zerop            _ANSI_ARGS_((int n_series, float **data));

static int  convert_to_log _ANSI_ARGS_((float **data, int n, int m, int is ));

/* zero at 0 data point : return value 0 or 1 */
int
zerop(n_series, data)
    int             n_series;
    float         **data;
{
  int             is = 0;
  register int    i;
  for (i = 0; i < n_series; i++) {
    if (data[i][0] == 0.0) {
      is = 1;
      break;
    }
  }
  return is;
}


static int
convert_to_log( data, n, m, is )
     float **data;
     int n, m, is;
{
  int i, j, erflag = 0;

  for (i = 0; i < n; i++)
    for ( j = is; j < m; j++) {
      if ( data[i][j] > 0.0 ) {
	data[i][j] = (float)log10((double)data[i][j]);
      } else {
	data[i][j] = -38.0;
	erflag = -1;
      }
    }
  if ( erflag != 0 ) {
    fprintf(stderr, "graph: Warning ... %s\n",
	    "used negative values in log scale mode");
  }
  return erflag;
}


void
SetYscale(ydata, n, m, is)
    float **ydata;
    int    n, m, is;
{
  /*********** Set Y-Scale ***********/
  if (GpmCont.axisType == 0 || GpmCont.axisType == 1) {
    if ( GpmCont.yMode == 0 ) /* AUTO MODE */
      scale(ydata, &GpmCont.yMin, &GpmCont.yMax, n, m);
  } else {
    convert_to_log( ydata, n, m, is);
    if ( GpmCont.yMode == 0 ) /* AUTO MODE */
      scalg(ydata, &GpmCont.yMin, &GpmCont.yMax, n, m, is );
  }
}


void
SetXscale(xdata, n, m, is)
    float  **xdata;
    int      n, m, is;
{
  /*********** Set X-Scale ***********/
  if (GpmCont.axisType == 0 || GpmCont.axisType == 2 ) {
    if ( GpmCont.xMode == 0 )
      scale(xdata, &GpmCont.xMin, &GpmCont.xMax, n, m);
  } else {		/* axis_type 1 or 3 */
    convert_to_log( xdata, n, m, is);
    if ( GpmCont.xMode == 0 )
      scalg(xdata, &GpmCont.xMin, &GpmCont.xMax, n, m, is);
  }
}

void
SetScale()
{
  if (GpmCont.axisType == 1 || GpmCont.axisType == 3 ) {
    if ( GpmCont.xMin <= 0.0) GpmCont.xMin = 1.0e-37;
    if ( GpmCont.xMax <= 0.0) GpmCont.xMax = 1.0e-37;
  }
  if (GpmCont.axisType == 2 || GpmCont.axisType == 3 ) {
    if ( GpmCont.yMin <= 0.0) GpmCont.yMin = 1.0e-37;
    if ( GpmCont.yMax <= 0.0) GpmCont.yMax = 1.0e-37;
  }

  switch (GpmCont.axisType) {
  case 0:
    gscale(GpmCont.xMin, GpmCont.yMin,
	   GpmCont.xMax, GpmCont.yMax);
    break;
  case 1:
    gscale(log10((double)fabs(GpmCont.xMin)), GpmCont.yMin,
	   log10((double)fabs(GpmCont.xMax)), GpmCont.yMax);
    break;
  case 2:
    gscale(GpmCont.xMin, log10(fabs((double)GpmCont.yMin)),
	   GpmCont.xMax, log10(fabs((double)GpmCont.yMax)));
    break;
  case 3:
    gscale(log10(fabs((double)GpmCont.xMin)),
	   log10(fabs((double)GpmCont.yMin)),
	   log10(fabs((double)GpmCont.xMax)),
	   log10(fabs((double)GpmCont.yMax)));
    break;
  }
}

void
GetDrawScale( xMin, xMax, yMin, yMax )
     float *xMin, *xMax, *yMin, *yMax;
{
  switch (GpmCont.axisType) {
  case 0: case 2:
    *xMin = GpmCont.xMin;
    *xMax = GpmCont.xMax;
    break;
  case 1: case 3:
    *xMin = log10((double)fabs(GpmCont.xMin));
    *xMax = log10((double)fabs(GpmCont.xMax));
    break;
  }
  switch (GpmCont.axisType) {
  case 0: case 1:
    *yMin = GpmCont.yMin;
    *yMax = GpmCont.yMax;
    break;
  case 2: case 3:
    *yMin = log10(fabs((double)GpmCont.yMin));
    *yMax = log10(fabs((double)GpmCont.yMax));
    break;
  }
}


void
set_data(type, dim, index, buf)
    int             type, dim, *index;
    Buffer         *buf;
{
  register int    i;
  double          p, delta;
  int            index2[MAX_INDEX];
  int             n = index[0];
  int             siz = IndexSize(dim, index);
  
  switch (type) {
  case 'T':
    printf("(Time scale)");
    for (i = 0; i < siz; i++) {
      rIndex(i, index2, dim, index);
      p = (double)index2[0];
      buf[i] = 1000.0 / (double)syscom.sam_freq * p;
    }
    break;
  case 'F':
    printf("(Frequency scale)");
    delta = (double)syscom.sam_freq / (double) ((n - 1) * 2.0);
    for (i = 0; i < siz; i++) {
      rIndex(i, index2, dim, index);
      p = (double)index2[0];
      buf[i] = delta * p;
    }
    break;
  case 'D':
    printf("(Data point scale)");
    for (i = 0; i < siz; i++) {
      rIndex(i, index2, dim, index);
      p = (double)index2[0];
      buf[i] = p;
    }
    break;
  default:
    break;
  }
}

void
btof(dim, index, buf, data)
    int             dim, *index;
    Buffer         *buf;
    float         **data;
{
  register int    i, j, k;
  int             index2[MAX_INDEX];
  int             siz = IndexSize(dim, index);
  
  for (i = 0; i < siz; i++) {
    rIndex(i, index2, dim, index);
    k = Index(SubIndex(index2), dim - 1, SubIndex(index));
    j = index2[0];
    data[k][j] = (float) buf[i];
  }
}


void
scale(data, amin, amax, n, m)
    float **data;
    float *amin, *amax;
    int    n, m;
{
  register int    i, j;
  double dmin, dmax;
  
  dmax = dmin = data[0][0];
  for (i = 0; i < n; i++) {
    for (j = 0; j < m; j++) {
      if (data[i][j] < dmin)
	dmin = data[i][j];
      else if (data[i][j] > dmax)
	dmax = data[i][j];
    }
  }  
  if (dmax == dmin) {
    if (dmax == 0.0) {
      dmax = 1.0;
      dmin = -1.0;
    } else {
      dmax += 0.05 * fabs(dmax);
      dmin -= 0.05 * fabs(dmin);
    }
  } else {
    dmax += 0.05 * fabs(dmax);
  }
  *amin = (float)dmin;
  *amax = (float)dmax;
}


void
scalg(data, amin, amax, n, m, is)
    float **data;
    float *amin, *amax;
    int   n, m, is;
{
  register int    i, j;
  double          dmin, dmax;
  
  dmax = dmin = data[0][is];
  for (i = 0; i < n; i++)
    for (j = is; j < m; j++) {
      if (data[i][j] > dmax)
	dmax = data[i][j];
      else if (data[i][j] < dmin)
	dmin = data[i][j];
    }

  if      ( dmin < -37.0 ) *amin = 1.0e-37;
  else if ( dmin >  38.0 ) *amin = 1.0e38;
  else
    *amin = (float)pow(10.0,dmin);

  if      ( dmax < -37.0 ) *amax = 1.0e-37;
  else if ( dmax >  38.0 ) *amax = 1.0e38;
  else
    *amax = (float)pow(10.0,dmax);
}


void
disp_scale_mode(mode1, mode2)
    int             mode1, mode2;
{
  /***** Scale Auto or Manual *****/
  int mode = mode1+2*mode2;

  switch (mode) {
  case 1:
    printf(" Fixed Scale[ x ] ... ");
    break;
  case 2:
    printf(" Fixed Scale[ y ] ... ");
    break;
  case 3:
    printf(" Fixed Scale[ x & y ] ... ");
    break;
  case 0:
    printf(" Auto Scaling ... ");
    break;
  }
}

void
OpenWindow()
{
  gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device,
	GpmCont.winNum);
  gnewpen(GpmCont.gColor);
  gpen(GpmCont.gLineWidth, GpmCont.gLineType, 0);
  gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
  gfsize(GpmCont.xSize, GpmCont.ySize);
  
  gfactor(GpmCont.factor);
  glimit(0.0, 0.0, GpmCont.xSize, GpmCont.ySize);
}

void
CloseWindow()
{
  glimit(0.0, 0.0, 0.0, 0.0);
  gflush();
  gclose();
}
