/************************************************
*                                               *
*        3-D GRAPHIC COMMAND                    *
*                                               *
*************************************************
*                                               *
* GSOLM IFIL,RHV1,RHV2,IFUC1,IFUC2,IFUC3,IFUC4, *
*       ICLR                                    *
*       IFIL        : FILE NUMBER               *
*       RHV1 , RHV2 : AREA TYPE                 *
*       IFUC1 , IFUC2 , IFUC3 , IFUC4           *
*                                               *
*                                               *
*     SATELITE Version          90/08/03        *
*            C Version          90/08/25        *
*       Buffer Version          90/08/30        *
*    SATELLITE Version          94/03/07        *
*                                               *
*               Coded By  T.Kobayashi           *
*            Modified By  K.Takebe              *
*            Modified By  H.Ashida              *
*                                               *
************************************************/
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

extern void  solm0r _ANSI_ARGS_((float **a2, int **ia2, int nx, int ny,
				 int mx, int my, float amxn[], float *rhv,
				 int *ifunc, float xypl[2][2], 
				 int iipen1, int iipen2, int mode ));

static void isort  _ANSI_ARGS_((float **a, int nx, int ny));

int
main()
{
  static char def_axis[2] = "X";
  int   index[MAX_INDEX];
  int   bufno, ifunc[4], icol, xdiv, ydiv;
  int   i, j, nx, ny, mx, my, viewpoint, mode;
  int   **ia;
  float rhv[2], amxn[2], xypl[2][2], **a;
  char  *timeaxis;

  float x1 = 0.0, x2 = 0.0, x3 = 0.0, x4 = 0.0;
  float y1 = 0.0, y2 = 0.0, y3 = 0.0, y4 = 0.0;
  float rhx, rhy, axleng, ayleng, azleng, axorg, ayarg, fontsize;
  float xMin, xMax, yMin, yMax, zMax, zMin;
  int   apy, apz;
  
  /* LOAD SYSTEM PARAMETER */
  read_syscom();
  regpm();
  
  bufno = GetBufferID(0);
  if ( bufno == 0 || GetBufferInfo(bufno, index) != 2) {
    exit(16); /* buffer dimension mismatch */
  }

  rhv[0]    = (float)GetScalar(1);
  rhv[1]    = (float)GetScalar(2);
  ifunc[0]  = (int)  GetScalar(3); /* hide line */
  ifunc[1]  = (int)  GetScalar(4);
  ifunc[2]  = (int)  GetScalar(5);
  ifunc[3]  = (int)  GetScalar(6);
  icol      = (int)  GetScalar(7);
  xdiv      = (int)  GetScalar(8);
  ydiv      = (int)  GetScalar(9);
  timeaxis  =        GetString(10);
  viewpoint = ((int) GetScalar(11) > 0 ) ? 1 : -1;
  mode      = ((int) GetScalar(12) > 0 ) ? 1 : 0;
  fontsize  = (float)GetScalar(13);

  if ( timeaxis == NULL )
    timeaxis = def_axis;

  if ( fontsize <= 0.0 )
    fontsize = 3.5;

  if (checktodvi() == True)
    writegpm();
  
  xypl[0][0] = GpmCont.xOrigin;
  xypl[0][1] = GpmCont.yOrigin;
  xypl[1][0] = GpmCont.xSize;
  xypl[1][1] = GpmCont.ySize;

  /* Load Data */
  if ( *timeaxis == 'X' || *timeaxis == 'x' ) {
    nx = index[0];
    ny = index[1];
  } else {
    nx = index[1];
    ny = index[0];
  }

  ia = (int **)_malloc2d(nx, ny, sizeof(int));

  a = ldata(bufno, nx, ny, timeaxis, 1);
  if (a == NULL)
    exit(4); /* buffer read error */

  if ( xdiv < 1 ) xdiv = 1;
  if ( ydiv < 1 ) ydiv = 1;
  thinout(a, &nx, &ny, xdiv, ydiv);
  if ( viewpoint > 0 )
    isort(a, nx, ny);
  
  mx = nx - 1;
  my = ny - 1;

  if ( GpmCont.xMode == 0 ) {
    GpmCont.xMin = xMin  = 0;
    GpmCont.xMax = xMax  = my;
  } else {
    xMin  = GpmCont.xMin;
    xMax  = GpmCont.xMax;
/*
    if ( GpmCont.xType == 1 ) {
      xMin = (xMin > 0.0 ) ? log10(xMin) : 0;
      xMax = (xMax > 0.0 ) ? log10(xMax) : my;
    }
*/
  }

  if ( GpmCont.yMode == 0 ) {
    GpmCont.yMin = yMin  = 0;
    GpmCont.yMax = yMax  = mx;
  } else {
    yMin  = GpmCont.yMin;
    yMax  = GpmCont.yMax;
/*
    if ( GpmCont.yType == 1 ) {
      yMin = (yMin > 0.0 ) ? log10(yMin) : 0;
      yMax = (yMax > 0.0 ) ? log10(yMax) : mx;
    }
*/
  }
  GpmCont.axisType = 0;
  
  zMin = a[0][0];
  zMax = a[0][0];
  
  for (i = 0; i < nx; i++)
    for (j = 0; j < ny; j++) {
      if (a[i][j] > zMax) zMax = a[i][j];
      if (a[i][j] < zMin) zMin = a[i][j];
    }

  if ( GpmCont.zMode == 0 ) {
    GpmCont.zMin = amxn[0] = zMin;
    GpmCont.zMax = amxn[1] = zMax;
  } else {
    amxn[0] = GpmCont.zMin;
    amxn[1] = GpmCont.zMax;
/*
    if ( GpmCont.zType == 1 ) {
      amxn[0] = (amxn[0] > 0.0 ) ? log10(amxn[0]) : -1.0;
      amxn[1] = (amxn[1] > 0.0 ) ? log10(amxn[1]) :  0.0;
    }
*/
  }

  printf("  Matrix Size  %d x %d\n", nx, ny);
  printf("  (scale: min = %g, max = %g,", amxn[0], amxn[1]);
  printf(" data: min = %g, max = %g)\n", zMin, zMax);
  
  gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device, GpmCont.winNum);
  gfactor(GpmCont.factor);
  gfont(GpmCont.fontType);
  gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
  
  /* 3D Frame Draw */
  if (ifunc[3] != 0) {
    gpen( GpmCont.fLineWidth, GpmCont.fLineType, 0);
    gnewpen(ifunc[3]);
    rhx = (float) fabs((double) rhv[0]);
    rhy = (float) fabs((double) rhv[1]);
    y1 = 0.0;
    y2 = xypl[1][1] * rhy;
    y3 = xypl[1][1] * (1.0 - rhy);
    y4 = xypl[1][1];
    
    if (rhv[0] * rhv[1] > 0) {
      x1 = 0.0;
      x2 = xypl[1][0] * rhx;
      x3 = xypl[1][0] * (1.0 - rhx);
      x4 = xypl[1][0];
      
      axorg = 0.0;
      ayarg = (float)(fabs(atan((double)(y2-y1)/(double)(x4-x3))));
      apy = 1;
      apz = 0;
    } else {
      x4 = 0.0;
      x3 = xypl[1][0] * rhx;
      x2 = xypl[1][0] * (1.0 - rhx);
      x1 = xypl[1][0];
      
      axorg = xypl[1][0] * rhx;
      ayarg = (float)(M_PI-fabs(atan((double)(y2-y1)/(double)(x4-x3))));
      apy = 0;
      apz = 1;
    }
    gplot(x1, y1, 0);
    gplot(x1, y3, -1);
    gplot(x2, y2, -1);
    gplot(x3, y1, -2);
    
    gplot(x4, y2, 0);
    gplot(x4, y4, -1);
    gplot(x2, y2, -1);
    gplot(x3, y1, -2);
    
    gplot(x2, y4, 0);
    gplot(x2, y2, -1);
    gplot(x1, y3, -1);
    gplot(x4, y4, -2);
    
    /* Draw ZERO Level */
    if (icol != 0) {
      ifunc[0] = 1;
      for (i = 0; i < nx; i++)
	for (j = 0; j < ny; j++)
	  a[i][j] = 0.0;
      gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
      gpen( GpmCont.gLineWidth, GpmCont.gLineType, 0);
      solm0r(a, ia, nx, ny, mx, my, amxn, rhv, ifunc, xypl,
	     GpmCont.gColor, icol, mode );

      /* not good code ! */
      free(a); a = NULL;
      a = ldata(bufno, nx, ny, timeaxis, 1);
      if (a == NULL)
	exit(4); /* buffer read error */

      if ( xdiv < 1 ) xdiv = 1;
      if ( ydiv < 1 ) ydiv = 1;
      thinout(a, &nx, &ny, xdiv, ydiv);
      if ( viewpoint > 0 )
	isort(a, nx, ny);
    }

    axleng = xypl[1][0] * (1.0 - rhx);
    ayleng = (float) sqrt((double) ((x4 - x3) * (x4 - x3)
				    + (y2 - y1) * (y2 - y1)));
    azleng = xypl[1][1] * (1.0 - rhy);
    
    gpen( GpmCont.fLineWidth, GpmCont.fLineType, 0);
    gnewpen(ifunc[3]);

    /* X Axis */
    gaxis(axorg, 0.0, axleng, (float) 0, xMin, xMax,
	  0.0, 2, 1, GpmCont.title_x[0], fontsize, 0, 0.0);

    /* Y Axis */
    gaxis(x3, 0.0, ayleng, (float)ayarg, yMin, yMax,
	  0.0, 2, apy, GpmCont.title_y[0], fontsize, 0, 0.0);
    /* Z Axis */
    gaxis(x1, 0.0, azleng, (float)(M_PI/2.0), amxn[0], amxn[1],
	  0.0, 1, apz, GpmCont.title_z[0], fontsize, 0, 0.0);
  }

  gpen( GpmCont.gLineWidth, GpmCont.gLineType, 0);
  gnewpen(GpmCont.gColor);
  solm0r(a, ia, nx, ny, mx, my, amxn, rhv, ifunc, xypl,
	 GpmCont.gColor, GpmCont.fColor, mode );
  
  if (ifunc[3] != 0) {
    gpen( GpmCont.fLineWidth, GpmCont.fLineType, 0);
    gnewpen(ifunc[3]);
    gplot(x3, y3, 0);
    gplot(x3, y1, -1);
    gplot(x1, y3, -1);
    gplot(x4, y4, -2);
  }
  gclose();
  wrgpm();
  /* STORE SYSTEM PARAMETER */
  write_syscom();
  return 0;
}

static void
isort(a, nx, ny)
     float	**a;
     int	nx, ny;
{
  register int i;
  int	half = nx / 2;
  float	*tmp;
  for(i = 0; i < half; i++) {
    tmp = a[i];
    a[i] = a[nx - i - 1];	
    a[nx - i - 1] = tmp;
  }
}

