#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"

static float  **a;
static int    **ia;
static int      ipen1, ipen2;

static float    ak1x, ak1y, alef, alow, amax, amin;
static float    arig, asig, aupp, bsig, dvd, eps;
static float    h, hib, hif, higb, higf, highq, hight, hori;

static int      i1, ias, ibas, idir, idis;
static int      ihid, iic, incr, ipen;
static int      isbl, iskr, itotal;
static int      ix, ixd, ixq, ixylm, iy, iyd, iyend, iyq, iysta;
static int      /*lcorn,*/ mesh, mxp1, myp1;

static float    px1, py1, rh, rv, trans, v, vert;
static float    xm, xorg, xp, xq, xshif, xshim;
static float    ym, yorg, yp, yq, yshif, yshim, ysmax, ysmin, ysq;

static void   ting             _ANSI_ARGS_((void));
static void   ting_sub         _ANSI_ARGS_((void));
static void   ting_sub2        _ANSI_ARGS_((void));
static void   point_check      _ANSI_ARGS_((void));
static int    point_check_sub  _ANSI_ARGS_((void));
static void   pre1             _ANSI_ARGS_((void));
static void   pre2             _ANSI_ARGS_((void));
static void   point_draw       _ANSI_ARGS_((void));
static void   sub1             _ANSI_ARGS_((void));
static void   cpen1            _ANSI_ARGS_((double data));
static void   cpen2            _ANSI_ARGS_((double data));
static double  sign             _ANSI_ARGS_((double val, double flag));

void  solm0r _ANSI_ARGS_((float **a2, int **ia2, int nx, int ny,
				 int mx, int my, float amxn[], float *rhv,
				 int *ifunc, float xypl[2][2], 
				 int iipen1, int iipen2, int mode ));

void isort  _ANSI_ARGS_((float **a, int nx, int ny));
void (*CPEN)_ANSI_ARGS_((double val));
int  IPENMODE;



void
solm0r(a2, ia2, nx, ny, mx, my, amxn, rhv, ifunc, xypl,
       iipen1, iipen2, mode )
     float  **a2, amxn[], xypl[2][2], rhv[];
     int    **ia2, nx, ny, mx, my, ifunc[], mode;
     int   iipen1, iipen2;
/***********************************************************************
 *****                   solm0r   Library List                     *****
 ***********************************************************************
 *                                                                     *
 *   Display of Solid Figure of Two variable , single valued function  *
 *   Defined on Rectangular Cordinate    z=f(x,y)                      *
 *   Mapping onto y-z Plane                                            *
 *                                                                     *
 ***********************************************************************
 *          C Version Rel. 1.0      1990/ 8/24      T.Kobayashi        *
 ***********************************************************************/
{
  CPEN     = mode ? cpen2 : cpen1;
  IPENMODE = mode ? 2 : 1;

  a = a2;
  ia = ia2;
  ipen1 = iipen1;
  ipen2 = iipen2;
  
  itotal = nx * ny;
  iic = 0;
  mxp1 = mx + 1;
  myp1 = my + 1;
  rh = rhv[0];
  rv = rhv[1];
  amin = amxn[0];
  amax = amxn[1];
  if (amax <= amin) {
    trans = amin;
    amin = amax;
    amax = trans;
  }
  if (amax == amin)
    amax = amin + 1.0;
  xorg = xypl[0][0];
  yorg = xypl[0][1];
  hori = xypl[1][0];
  vert = xypl[1][1];
  
  gplot(xorg, yorg, 0);
  ihid = ifunc[0];
  ixylm = ifunc[1];
  ibas = ifunc[2] + 1;
  
  if (ibas < 1)
    ibas = 1;
  if (ibas > 3)
    ibas = 3;
  
  if (fabs((double) rh) >= 0.999)
    rh = sign(0.999, rh);
  if (fabs((double) rv) >= 0.999)
    rv = sign(0.999, rv);
  if (fabs((double) rh) <= 0.00001)
    rh = sign(0.00001, rh);
  h = ( rh * (float) my /
       ((float) mx * (1.0 - (float) fabs((double) rh))));
  if (rh < 0.0) {
    alef = 0.0;
    arig = (float) my - h * (float) mx;
  } else {
    alef = -h * (float) mx;
    arig = (float) my;
  }
  
  v = ( rv * (amax - amin) /
       ((float) mx * (1.0 - (float) fabs((double) rv))));
  if (rv < 0.0) {
    aupp = (amax - amin) / (1.0 + rv) + amin;
    alow = amin;
  } else {
    aupp = amax;
    alow = -((amax - amin) / (1.0 - rv) - amax);
  }
  
  ak1x = hori / (arig - alef);
  ak1y = vert / (aupp - alow);
  
  /***** Generation of Table  -ia- *****/
  if (ihid != 0) {
    for (iy = 0; iy < myp1; iy++)
      for (ix = 0; ix < mxp1; ix++)
	ia[ix][iy] = 1;
  } else {		/* Hidden Line Proc */
    mesh = 1;
    for (iy = 0; iy < myp1; iy++)
      for (ix = 0; ix < mxp1; ix++) {
	xm = (float) ix;
	ym = (float) iy;
	xshif = ym - h * xm;
	hight = a[ix][iy];
	if (hight < amin)
	  hight = amin;
	if (hight > amax)
	  hight = amax;
	yshif = hight - v * xm;
	point_check();
	ia[ix][iy] = isbl;
      }
  }
  
  /***** Curve Ting *****/
  mesh = 2;
  if (ixylm != 2) {
    idir = 1;
    for (iy = 0; iy < myp1; iy++)
      for (ix = 0; ix < mx; ix++) {
	ias = ia[ix][iy] + ia[ix + 1][iy];
	ting();
      }
  }
  if (ixylm != 1) {
    idir = 2;
    for (ix = 0; ix < mxp1; ix++)
      for (iy = 0; iy < my; iy++) {
	ias = ia[ix][iy] + ia[ix][iy + 1];
	ting();
      }
  }

  /***** Skirt Drawing *****/
  if (ibas != 1 && ihid == 0 ) {
    if ( mode )
      gnewpen(7);
    if (h < 0.0) {
      iskr = 1;
      iy = 0;
      for (ix = 0; ix < mxp1; ix++) {
	sub1();
      }
      ix = mxp1 - 1;
      
      if (v * ((float) ibas - 2.0) <= 0.0) {
	ixd = 0;
	iyd = 0;
	ipen = 0;
	if (ibas == 3)
	  hight = amax;
	else
	  hight = amin;;
	pre2();
	point_draw();
	
	ixd = mxp1 - 1;
	iyd = 0;
	ipen = IPENMODE;
	CPEN(a[ix][iy]);
	if (ibas == 3)
	  hight = amax;
	else
	  hight = amin;;
	pre2();
	point_draw();
      }
      iysta = 1;
      iyend = myp1;
    } else {
      iysta = 0;
      iyend = my;
    }
    
    iskr = 2;
    ix = mxp1 - 1;
    for (iy = iysta; iy < iyend; iy++) {
      sub1();
    }
    iy = iyend - 1;
    
    if (v * ((float) ibas - 2.5) <= 0.0) {
      ixd = mxp1 - 1;
      iyd = 0;
      ipen = 0;
      if (ibas == 3)
	hight = amax;
      else
	hight = amin;;
      pre2();
      point_draw();
      
      ixd = mxp1 - 1;
      iyd = myp1 - 1;
      ipen = IPENMODE;
      CPEN(a[ix][iy]);
      if (ibas == 3)
	hight = amax;
      else
	hight = amin;
      pre2();
      point_draw();
    }
    if (h > 0.0) {
      iskr = 3;
      iy = myp1 - 1;
      for (ix = 0; ix < mxp1; ix++) {
	sub1();
      }
      ix = mxp1 - 1;
      
      if (v * ((float) ibas - 2.5) <= 0.0) {
	ixd = 0;
	iyd = myp1 - 1;
	ipen = 0;
	if (ibas == 3)
	  hight = amax;
	else
	  hight = amin;;
	pre2();
	point_draw();
	
	ixd = mxp1 - 1;
	iyd = myp1 - 1;
	ipen = IPENMODE;
	CPEN(a[ix][iy]);
	if (ibas == 3)
	  hight = amax;
	else
	  hight = amin;;
	pre2();
	point_draw();
      }
    }
    if (v * ((float) ibas - 2.5) > 0.0) {
      if (ibas == 3)
	hight = amax;
      else
	hight = amin;;
      for (ix = 0; ix < mxp1; ix++) {
	ixd = ix;
	iyd = 0;
	ipen = 0;
	
	pre2();
	point_draw();
	
	ixd = ix;
	iyd = myp1 - 1;
	ipen = IPENMODE;
	CPEN(a[ix][iy]);
	pre2();
	point_draw();
      }
      ix = mxp1 - 1;
      
      for (iy = 0; iy < myp1; iy++) {
	ixd = 0;
	iyd = iy;
	ipen = 0;
	pre2();
	point_draw();
	
	ixd = mxp1 - 1;
	iyd = iy;
	ipen = IPENMODE;
	CPEN(a[ix][iy]);
	pre2();
	point_draw();
      }
    }
  }

  /***** Edge Line (Plotter Plane) Drawing *****/
  /*	if (lcorn == 0) {
	gplot(0.0, 0.0, 0);
	gplot(0.0, vert, 1);
	gplot(hori, vert, 1);
	gplot(hori, 0.0, 1);
	gplot(0.0, 0.0, 1);
	} */
  gplot(mgraph.xpre, mgraph.ypre, 2);
}

/*************************
 ***** Ting Routine ******
 *************************/
static void
ting()
{
  if (ias == 0)
    return;
  if (ias == 2) {
    ting_sub2();
    return;
  }
  asig = 2.0 * ((float) ia[ix][iy] - 0.5);
  dvd = 0.5;
  xm = (float) ix;
  ym = (float) iy;
  switch (idir) {
  case 1:
    xp = xm + dvd;
    yp = ym;
    higf = a[ix + 1][iy];
    break;
  case 2:
    xp = xm;
    yp = ym + dvd;
    higf = a[ix][iy + 1];
    break;
  }
  higb = a[ix][iy];
  
  for (i1 = 0; i1 < 7; i1++) {
    if (idir == 1) {
      hight = higb + (xp - xm) * (higf - higb);
    } else {
      hight = higb + (yp - ym) * (higf - higb);
    }
    if (hight < amin)
      hight = amin;
    if (hight > amax)
      hight = amax;
    xshif = yp - h * xp;
    yshif = hight - v * xp;
    point_check();
    
    dvd = dvd * 0.5;
    bsig = 2.0 * ((float) isbl - 0.5);
    if (idir == 1) {
      xp = xp + bsig * sign(dvd, asig);
    } else {
      yp = yp + bsig * sign(dvd, asig);
    }
  }
  
  if (idir == 1) {
    hight = higb + (xp - xm) * (higf - higb);
  } else {
    hight = higb + (yp - ym) * (higf - higb);
  }
  if (hight < amin)
    hight = amin;
  if (hight > amax)
    hight = amax;
  xshim = yp - h * xp;
  yshim = hight - v * xp;
  if (asig < 0.0) {
    xshif = xshim;
    yshif = yshim;
    ipen = 0;
    point_draw();
    ting_sub();
    return;
  }
  if (((idir == 1) && (ix == 0)) || ((idir == 2) && (iy == 0))) {
    hight = higb;
    if (hight < amin)
      hight = amin;
    if (hight > amax)
      hight = amax;
    xshif = ym - h * xm;
    yshif = hight - v * xm;
    ipen = 0;
    point_draw();
  }
  xshif = xshim;
  yshif = yshim;
  ipen = IPENMODE;
  CPEN(a[ix][iy]);
  point_draw();
}

static void
ting_sub()
{
  hight = higf;
  if (hight < amin)
    hight = amin;
  if (hight > amax)
    hight = amax;
  if (idir == 1) {
    xshif = ym - h * (xm + 1.0);
    yshif = hight - v * (xm + 1.0);
  } else {
    xshif = (ym + 1.0) - h * xm;
    yshif = hight - v * xm;
  }
  ipen = IPENMODE;
  CPEN(a[ix][iy]);
  point_draw();
}

static void
ting_sub2()
{
  if (((idir == 1) && (ix == 0)) || ((idir == 2) && (iy == 0))) {
    ixd = ix;
    iyd = iy;
    ipen = 0;
    pre1();
    pre2();
    point_draw();
  }
  if (idir == 1) {
    ixd = ix + 1;
    iyd = iy;
  } else {
    ixd = ix;
    iyd = iy + 1;
  }
  ipen = IPENMODE;
  CPEN(a[ix][iy]);
  pre1();
  pre2();
  point_draw();
}


/***** Search Cross Line and                       *****
 ***** Determine If Object Point is Visible or not *****/
static void
point_check()
{
  ysmin = 1.0e+10;
  ysmax = -1.0e+10;
  isbl = 1;
  if (ixylm != 1) {
    idis = 1;
    for (ixq = ix + 1; ixq < mxp1; ixq++) {
      xq = (float) ixq;
      yq = xshif + h * xq;
      if (yq < 0.0)
	break;
      iyq = (int) yq;
      if (iyq >= myp1 - 1)
	break;
      eps = yq - (float) iyq;
      if (point_check_sub() == -1)
	return;
    }
  }
  if (ixylm == 2)
    return;
  idis = 2;
  if (h < 0.0) {
    if (mesh != 1 && idir != 1) {
      iyq = iy + 1;
      incr = -1;
    } else {
      iyq = iy;
      incr = -1;
    }
  } else {
    iyq = iy;
    incr = 1;
  }
  
  while (1) {
    iyq = iyq + incr;
    if ((iyq < 0) || (iyq >= myp1))
      return;
    yq = (float) iyq;
    xq = (yq - xshif) / h;
    ixq = (int) xq;
    if (ixq >= mxp1 - 1)
      return;
    eps = xq - (float) ixq;
    if (point_check_sub() == -1)
      return;
  }
}

static int
point_check_sub()
{
  hib = a[ixq][iyq];
  if (idis == 1) {
    hif = a[ixq][iyq + 1];
  } else {
    hif = a[ixq + 1][iyq];
  }
  highq = hib + eps * (hif - hib);
  if (highq < amin)
    highq = amin;
  if (highq > amax)
    highq = amax;
  ysq = highq - v * xq;
  if (ysq < ysmin)
    ysmin = ysq;
  if (ysq > ysmax)
    ysmax = ysq;
  if (ibas == 1) {
    if ((ysmax > yshif) && (yshif > ysmin)) {
      isbl = 0;
      return (-1);
    }
  } else if (ibas == 2) {
    if (ysmax > yshif) {
      isbl = 0;
      return (-1);
    }
  } else {
    if (yshif > ysmin) {
      isbl = 0;
      return (-1);
    }
  }
  return (0);
}


static void
pre1()
{
  hight = a[ixd][iyd];
  if (hight < amin)
    hight = amin;
  if (hight > amax)
    hight = amax;
}


static void
pre2()
{
  xshif = (float) iyd - h * (float) ixd;
  yshif = hight - v * (float) ixd;
}


static void
point_draw()
{
  px1 = ak1x * (xshif - alef);
  py1 = ak1y * (yshif - alow);
  
  gplot(px1, py1, ipen);
}


static void
sub1()
{
  ixd = ix;
  iyd = iy;
  ipen = 0;
  pre1();
  pre2();
  point_draw();
  
  ipen = IPENMODE;
  CPEN(a[ix][iy]);
  if (ibas == 3)
    hight = amax;
  else
    hight = amin;;
  pre2();
  point_draw();
}


static void
cpen1(data)
     double  data;
{
  if (data < 0.0)
    gnewpen(ipen1);
  else
    gnewpen(ipen2);
}


static void
cpen2(data)
     double  data;
{
  double  level = (data - amin) / (amax - amin);

  grainbow(level);
}


static double
sign(val, flag)
     double  val, flag;
{
  return (flag < 0.0) ? (-1.0 * val) : (val);
}
