/*********************************************
*          GSTAT Command Vergion             *
*             UNIX arranged by Y.Miyamoto    *
*                     (03/13/91)             *
*********************************************/
#include <stdio.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"

#ifndef FONT_MAX
#define FONT_MAX 12
#endif

int
main()
{
  int             i;
  
  static char    *fonttype[FONT_MAX] = {
    "Times Roman", "Times Italic", "Times Bold", "Times Bold Italic",
    "Helvetica", "Helvetica Oblique", "Helvetica Bold",
    "Helvetica Bold Oblique",
    "Courier", "Courier Oblique", "Courier Bold", "Courier Bold Oblique"};

  /************** read parameter **************/
  read_syscom();
  regpm();
  
  for (i = 0; i < TITLE_MAX; i++) {
    GpmCont.title_x[i][TITLE_LEN-1] = '\0';
    GpmCont.title_y[i][TITLE_LEN-1] = '\0';
    GpmCont.title_z[i][TITLE_LEN-1] = '\0';
  }
  
  puts("-------------------------------------");
  puts("GPM COMMON PARAMETERS");
  if ( GpmCont.winNum < 0 )
    printf("No Current Window\n");
  else
    printf("Current Window = No. %d\n", GpmCont.winNum+1 );
  puts("-------------------------------------");
  printf  ("Paper Size: ");
  switch( GpmCont.paper ) {
  case 0: printf("A4"); break;
  case 1: printf("B4"); break;
  default:
    printf("Free Size(%.2fmm x %.2fmm)",
	   GpmCont.paperWidth, GpmCont.paperHeight );
    break;
  }    
  printf  (", Orientation: ");
  if ( GpmCont.orientation == 0 ) printf("0 (Portrait)\n");
  else                            printf("1 (Landscape)\n");
  
  if ( GpmCont.device == 0 )
    printf  ("No DVIFILE\n");
  else
    printf  ("DVIFILEPATH = \"%s\"\n", GpmCont.dvifile);
  puts("-------------------------------------");
  printf ("Factor    : %.4f\n", GpmCont.factor);
  printf ("Origin    : (%.2f mm, %.2f mm)\n",
	  GpmCont.xOrigin, GpmCont.yOrigin);
  printf ("Size      : (%.2f mm, %.2f mm)\n",
	  GpmCont.xSize, GpmCont.ySize);
  printf ("Font Type : %d (%s)\n",
	  GpmCont.fontType+1, fonttype[(int)GpmCont.fontType]);
  printf ("Frame Line: Width %d, Type %d, Color %d\n",
	  GpmCont.fLineWidth+1, GpmCont.fLineType+1, GpmCont.fColor);
  printf ("Graph Line: Width %d, Type %d, Color %d\n",
	  GpmCont.gLineWidth+1, GpmCont.gLineType+1, GpmCont.gColor);
  printf ("Scale type: X=%d, Y=%d, Z=%d (0:Normal 1:Log)\n",
	  GpmCont.xType, GpmCont.yType, GpmCont.zType);
  printf ("Scale mode: X=%d, Y=%d, Z=%d (0:Auto 1:Fixed 2:Default)\n",
	  GpmCont.xMode, GpmCont.yMode, GpmCont.zMode);
  printf ("Scale X = min:%g, max:%g\n",
	  GpmCont.xMin, GpmCont.xMax);
  printf ("Scale Y = min:%g, max:%g\n",
	  GpmCont.yMin, GpmCont.yMax);
  printf ("Scale Z = min:%g, max:%g\n",
	  GpmCont.zMin, GpmCont.zMax);

  for ( i = 0; i < TITLE_MAX; i++ ) {
    printf ("TITLE %d:\n", i+1 );
    printf ("  X: \"%s\"\n", GpmCont.title_x[i] );
    printf ("  Y: \"%s\"\n", GpmCont.title_y[i] );
    printf ("  Z: \"%s\"\n", GpmCont.title_z[i] );
  }
  puts("-------------------------------------");

  return 0;
}
