#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"


int
main()
{
  int            numer;
  char          *ialpha;
  int            status;
  unsigned int   width, height;
  Pixmap         bitmap;
  int            x_hot, y_hot;
  double          dx, dy;
  int            idx = 0, idy = 0;
  int            wx, wy;
  XWindowAttributes atr;

  read_syscom();
  regpm();

  ialpha  = GetString(0);
  dx      = GetScalar(1);
  dy      = GetScalar(2);
  numer   = (int) GetScalar(3);
  
  gopen( GpmCont.paper, GpmCont.orientation, GpmCont.device,
	GpmCont.winNum ) ;
  gnewpen( GpmCont.gColor ) ;
  gpen( GpmCont.fLineWidth, GpmCont.fLineType,0);
  gorigin( GpmCont.xOrigin, GpmCont.yOrigin ) ;
  gfactor( GpmCont.factor ) ;

  status = XReadBitmapFile( gpm_display, gpm_window,ialpha,
			   &width,&height,&bitmap,&x_hot,&y_hot);

  if (status==BitmapOpenFailed) exit(38);
  if (status==BitmapFileInvalid) exit(39);
  if (status==BitmapNoMemory) exit(40);

  if (numer != 0) {

    XGetWindowAttributes(gpm_display, gpm_window, &atr);
    wx = atr.width;
    wy = atr.height;

    if ( numer == 1) {

      idx = dx + mgraph.xorg * mdev.ffx ;
      idy = wy - dy - height - mgraph.yorg * mdev.ffy ;
    }
    else if ( numer == 2) {

      idx = dx ;
      idy = wy - dy - height ;
    }
  }

  else {
    idx=( dx + mgraph.xorg ) * mdev.ffx;
    idy=mdev.iyleng-((dy + mgraph.yorg) * mdev.ffy)-height;
  }

  /* XSetFillStyle(gpm_display,gpm_gc,FillStippled); */
  /* XSetTSOrigin(gpm_display,gpm_gc,idx % width, idy % height); */
  /* XSetStipple(gpm_display,gpm_gc,bitmap); */
  /* XFillRectangle(gpm_display,gpm_window,gpm_gc,idx,idy,width,height); */

  /* Modified by kitahara & okumura */
  XSetClipOrigin(gpm_display,gpm_gc,idx, idy);
  XSetClipMask(gpm_display,gpm_gc,bitmap);
  XFillRectangle(gpm_display,gpm_window,gpm_gc,idx,idy,width,height);
  XFillRectangle(gpm_display,gpm_pixmap,gpm_gc,idx,idy,width,height);
  XSetClipMask(gpm_display,gpm_gc,None);

  gflush();
  gclose() ;

  wrgpm() ;
  write_syscom() ;
  return 0;
}
