/***************************
 * GPM Parameter Structure *
 *       Coded by K.Takebe *
 ***************************/
#ifndef GPM_DEF_H
#define GPM_DEF_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <math.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#define DVI_DEFAULT      "GPMDVIFILE"
#define	GPM_file         "GPM"
#define	GPM_file2        "GPM2"


#ifndef SEEK_SET
#define SEEK_SET         0  /* Set file pointer to "offset"              */
#define SEEK_CUR         1  /* Set file pointer to current plus "offset" */
#define SEEK_END         2  /* Set file pointer to EOF plus "offset"     */
#endif

#ifdef FILE_LENGTH
#undef FILE_LENGTH
#endif

#define FILE_LENGTH      256


#ifndef COLOR_YES
#define COLOR_YES       1
#endif
#ifndef COLOR_NO
#define COLOR_NO        0
#endif

#define MAX_COLOR        11
#define RAINBOW_BASECOL  5
#define RAINBOW_DIVNUM   8
#define MAX_WIN          10

#define TITLE_MAX        3
#define TITLE_LEN        256

#define NPLOT            1
#define NBOX             2
#define NCSYMBOL         3
#define NLABEL           4
#define NROLL            5


typedef struct GpmContext_ {
  /* device parameters */
  char    winNum;               /* window number (0--MAX_WIN-1)     */
  char    device;               /* 0: window, 1: window and dvifile, 2: file*/
  char    dvifile[FILE_LENGTH]; /* dvi file path                    */
  char    orientation;          /* 0: portrait, 1: landscape        */
  char    paper;                /* 0: a4, 1: b4, 2: free            */
  float   paperWidth;           /* paper width  [mm]                */
  float   paperHeight;          /* paper height [mm]                */
  /* common parameters */
  float   factor;        /* scale factor > 0.0               */
  float   xOrigin;       /* position of x origin [mm]        */
  float   yOrigin;       /* position of y origin [mm]        */
  float   xSize;         /* drawing area width  [mm]         */
  float   ySize;         /* drawing area height [mm]         */
  float   fontHeight;    /* font height [mm]                 */
  char    fontType;      /* font type ( 1--12 )              */
  char    fLineWidth;    /* frame line width [mm] (0: 0.1mm) */
  char    gLineWidth;    /* graph line width [mm] (0: 0.1mm) */
  char    fLineType;     /* frame dash type (1--7)           */
  char    gLineType;     /* graph dash type (1--7)           */
  char    fColor;        /* frame color (0--7)               */
  char    gColor;        /* graph color (0--7)               */

  /* for draw graph */
  char    axisType;      /* axis type (0: LnrLnr, 1: LogLnr, *
			  *            2: LnrLog, 3: LogLog) */
  char    axisDraw;      /* axis draw (0: L_L, 1: L_U,       *
			  *            2: R_L, 3: R_U )      */
  char    xType;         /* scaling function of axis-x       */
  char    yType;         /* scaling function of axis-y       */
  char    zType;         /* scaling function of axis-z       *
			  *      0: Normal(Linear), 1: Log10 */
  char    xMode;         /* scaling mode of axis-x           */
  char    yMode;         /* scaling mode of axis-y           */
  char    zMode;         /* scaling mode of axis-z           *
			  *                0: Auto, 1: Fixed */
  float   xMin;          /* x minimum (convert Normal mode ) */
  float   yMin;          /* y minimum (convert Normal mode ) */
  float   zMin;          /* z minimum (convert Normal mode ) */
  float   xMax;          /* x maximum (convert Normal mode ) */
  float   yMax;          /* y maximum (convert Normal mode ) */
  float   zMax;          /* z maximum (convert Normal mode ) */

  /* title buffer */
  char	  title_x[TITLE_MAX][TITLE_LEN];
  char	  title_y[TITLE_MAX][TITLE_LEN];
  char	  title_z[TITLE_MAX][TITLE_LEN];
  
} GpmContext;


typedef struct _Mdev {
  char          number;
  char          mode;
  char          irotate;
  char          todvi;
  unsigned int  ixleng;
  unsigned int  iyleng;
  float         xleng;
  float         yleng;
  float         ffx;
  float         ffy;
} Mdev;


typedef struct _Mgraph {
  float   xmin;
  float   ymin;
  float   xmax;
  float   ymax;
  float   xorg;
  float   yorg;
  float   xaxis;
  float   yaxis;
  float   factor;
  float   xpre;
  float   ypre;
  int     cline;
} Mgraph;


typedef struct _Mpen {
  char   icolor;
  char   isize;
  char   itype;
  char   imode;
  char   rainbow;
} Mpen;


typedef struct _Mscale {
  float   xdat_min;
  float   ydat_min;
  float   xdat_max;
  float   ydat_max;
} Mscale;


typedef struct _Msymbol {
  char            cdata;
  char            font;
  float           height;
  float           wph;
  float           theta;
} Msymbol;


typedef struct _Mwin {
  unsigned int    ixleng;
  unsigned int    iyleng;
  float           ffx;
  float           ffy;
  int             color;
  int             stdcmap;
} Mwin;


typedef struct _Plot {
  float          x;
  float          y;
  char           ipen_mode;
  char           color;
  char           rainbow;
  char           ltype;
  char           lwidth;
} Plot;


typedef struct _Box {
  float          x1;
  float          y1;
  float          x2;
  float          y2;
  float          level;
  char           mode;
  char           color;
  char           ltype;
  char           lwidth;
} Box;


typedef struct _Csymbol {
  float          x;
  float          y;
  char           cdata;
  float          height;
  float          theta;
  char           color;
  char           lwidth;
} Csymbol;


typedef struct _Label {
  float          x;
  float          y;
  float          height;
  float          theta;
  unsigned char  ilen;
  char          *ichar;
  char           mode;
  char           color;
  char           font;
} Label;


typedef struct _Param {
  unsigned char endmark;
  float         factor;
  float         xorg;
  float         yorg;
} Param;


typedef struct _Devpara {
  float         xorg;
  float         yorg;
  int           color;
  float         level;
} Devpara;


#ifndef _RW_GPM_
extern GpmContext  GpmCont;
extern Mdev        mdev;
extern Mgraph      mgraph;
extern Mpen        mpen;
extern Mscale      mscale;
extern Msymbol     msymbol;
extern Mwin        mwin;
#endif /* _RW_GPM_ */

#ifndef _GPM_DVI_
extern int         dvi_fd;
extern char        gpm_head[];
extern Plot        gpm_plot;
extern Box         gpm_box;
extern Csymbol     gpm_csymbol;
extern Label       gpm_label;
extern Param       gpm_param;
#endif /* _GPM_DVI_ */

#include "GPMproto.h"

#endif /* GPM_DEF_H */
