/***************************
  Prototype Decl.
 ***************************/
#ifndef GPM_PROTO_H
#define GPM_PROTO_H

#undef _ANSI_ARGS_
#if ( defined(__STDC__) && !defined(NO_PROTOTYPE)) || defined(USE_PROTOTYPE)
#   define _USING_PROTOTYPES_ 1
#   define _ANSI_ARGS_(x)       x
#else
#   define _ANSI_ARGS_(x)       ()
#endif

/* psfunc.c */
extern void    ps_origin        _ANSI_ARGS_((double x, double y));
extern void    ps_color         _ANSI_ARGS_((int color));
extern void    ps_rainbow       _ANSI_ARGS_((double level));
extern void    ps_plot          _ANSI_ARGS_((double x, double y, int mode));
extern void    ps_factor        _ANSI_ARGS_((double factor));
extern void    ps_box           _ANSI_ARGS_((double x1, double y1,
					     double x2, double y2, int mode,
					     double level, int color));
extern void    ps_lwidth        _ANSI_ARGS_((int width));
extern void    ps_ltype         _ANSI_ARGS_((int type));
extern void    ps_char          _ANSI_ARGS_((double x, double y));
extern void    ps_string        _ANSI_ARGS_((double x, double y, char *str,
					     double height, double theta,
					     int centermode, int font));
extern void    ps_flag          _ANSI_ARGS_((int sw));
extern void    ps_csymbol       _ANSI_ARGS_((double x, double y, int cdata,
					     double height));
extern void    ps_open          _ANSI_ARGS_((void));
extern void    ps_close         _ANSI_ARGS_((void));
extern void    ps_init          _ANSI_ARGS_((void));
extern void    ps_roll          _ANSI_ARGS_((void));
extern void    ps_end           _ANSI_ARGS_((void));
extern void    ps_rainbow_mode  _ANSI_ARGS_((int mode));
extern void    ps_ginit         _ANSI_ARGS_((void));
extern void    ps_initAdobe     _ANSI_ARGS_((int paperSize, int orientation,
					     char *creator, char *infilename));
extern void    ps_setTray       _ANSI_ARGS_((int paperSize, int orientation));
extern void    ps_page          _ANSI_ARGS_((int pageNumber));
extern void    ps_pages         _ANSI_ARGS_((int pageNumber));

/* rwgpm.c */
extern int     regpm            _ANSI_ARGS_((void));
extern int     wrgpm            _ANSI_ARGS_((void));
extern int     createGpm2       _ANSI_ARGS_((void));
extern int     regpm2           _ANSI_ARGS_((int win_num));
extern int     wrgpm2           _ANSI_ARGS_((int win_num));

/* ldata.c */
extern char  **_malloc2d        _ANSI_ARGS_((int x, int y, int size));
extern float **ldata            _ANSI_ARGS_((int buffno, int nx, int ny,
					     char *timeaxis, int viewpoint));
extern void    thinout          _ANSI_ARGS_((float **buf, int *nx, int *ny,
					     int xdiv, int ydiv));

/* gpmdvi.c */
extern int     readdvihead      _ANSI_ARGS_((void));
extern void    createdvi        _ANSI_ARGS_((char *fname, int number,
					     int irotate, int todvi));
extern int     checktodvi       _ANSI_ARGS_((void));
extern void    opendvi          _ANSI_ARGS_((void));
extern void    opendvi_for_read _ANSI_ARGS_((void));
extern void    closedvi         _ANSI_ARGS_((void));

extern int     readgpm          _ANSI_ARGS_((void));
extern int     readdvi          _ANSI_ARGS_((void));
extern void    writegpm         _ANSI_ARGS_((void));

extern void    getlength        _ANSI_ARGS_((int number, float *x, float *y,
					     int rotate));
#ifdef GPM_LIB
extern double getfontwidth       _ANSI_ARGS_((int c, double length, int font));
extern double getstrwidth        _ANSI_ARGS_((char *str, double height,
					     int font));
extern double trans_func         _ANSI_ARGS_((double x1, double y1,
					     double x2, double y2, double x));
 
extern void  writeplot          _ANSI_ARGS_((double x, double y, int ipen_mode));
extern void  writebox           _ANSI_ARGS_((double x1, double y1,
					     double x2, double y2,
					     int mode, double level));
extern void  writecsymbol       _ANSI_ARGS_((double x, double y));
extern void  writelabel         _ANSI_ARGS_((double x, double y, char *ichar,
					     double height, double theta,
					     int imode));
extern void  writeroll          _ANSI_ARGS_((void));
#endif
#endif
