/***************************
 * GPM Window Structure    *
 *       Coded by K.Takebe *
 ***************************/
#ifndef GPM_WIN_H
#define GPM_WIN_H

#include <X11/Xlib.h>
#include <X11/Xutil.h>

typedef struct	GpmWinID_ {
  Window  wid;
  Pixmap  pix;
  int     pid;
} GpmWinID;

#define WIN_FNAME "WINDOWS"

#ifndef _GPMX1_
extern Window             gpm_window;
extern Pixmap             gpm_pixmap;
extern Display           *gpm_display;
extern int                gpm_screen;
extern int                gpm_depth;
extern Colormap           gpm_cmap;
extern GC                 gpm_gc;
extern XStandardColormap  gpm_smap;
extern unsigned int       gpm_color[];
extern unsigned int       gpm_rainbow[];
extern char              *colorname[];
extern int                flags;
#endif

/* gpmx1.c */
extern void     gopen             _ANSI_ARGS_((int paper, int orientation,
					       int device, int win_num));
extern void     gclose            _ANSI_ARGS_((void));
extern void     gflush            _ANSI_ARGS_((void));
extern void     createrainbow     _ANSI_ARGS_((void));
extern int      createWin         _ANSI_ARGS_((void));
extern GpmWinID getWindow         _ANSI_ARGS_((int win_num));
extern void     putWindow         _ANSI_ARGS_((int win_num, GpmWinID win));
extern void     set_tile_pattern  _ANSI_ARGS_((Display *display, int screen,
					       Drawable window, GC gc,
					       double level));
/* gpmx2.c */
extern void     gplot      _ANSI_ARGS_((double x, double y, int imode));
extern void     gbox       _ANSI_ARGS_((double x1, double y1,
					double x2, double y2,
					int imode, double level));
extern void     glabel     _ANSI_ARGS_((double x, double y, char *ichar,
					double height, double theta, int imode));
extern void     gfont      _ANSI_ARGS_((int type));
extern int      groll      _ANSI_ARGS_((void));
extern void     gerase     _ANSI_ARGS_((void));
extern void     gframe     _ANSI_ARGS_((void));

/* gpmx3.c */
extern void     graph      _ANSI_ARGS_(( float*, float*, int, int,
					int, int, double ));
extern void     gaxis      _ANSI_ARGS_(( double, double, double, double,
					double, double, double, int, int,
					char*, double, int, double )); 
extern void     gaxisl     _ANSI_ARGS_(( double, double, double, double,
					double, double, int, int, 
					char*, double, int, double ));

/* gpmx4.c */
extern void     gcsize     _ANSI_ARGS_((double size));
extern void     gfactor    _ANSI_ARGS_((double factor));
extern void     gfsize     _ANSI_ARGS_((double x, double y));
extern void     glimit     _ANSI_ARGS_((double xmin, double ymin,
					double xmax, double ymax));
extern void     gnewpen    _ANSI_ARGS_((int color));
extern void     gorigin    _ANSI_ARGS_((double x, double y));
extern void     gpen       _ANSI_ARGS_((int ip_size, int ip_type,
					int ip_mode));
extern void     gscale     _ANSI_ARGS_((double xmin, double ymin,
					double xmax, double ymax));
extern void     grainbow   _ANSI_ARGS_((double level));

/* gpmx5.c */
extern void     plot       _ANSI_ARGS_((double x, double y, int ipen_mode));
extern int      csymbol    _ANSI_ARGS_((double x, double y));
extern void     label      _ANSI_ARGS_((double x, double y, char *ichar,
					double height, double theta, int mode));
extern void     box        _ANSI_ARGS_((double x1, double y1,
					double x2, double y2,
					int mode, double level));
#ifdef GPM_LIB 
extern void     roll       _ANSI_ARGS_((void));

extern void     GpmSet_color            _ANSI_ARGS_((int color, int rainbow));
extern void     GpmSet_dash_width_dmode _ANSI_ARGS_((int itype, int isize,
						     int imode));
#endif

#endif /* GPM_WIN_H */
