#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "SL_macro.h"

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#ifdef HAVE_GETTIMEOFDAY

static struct timeval  tp;
static struct timezone tzp;
static unsigned long   tv_sec;
static long            tv_usec;
static unsigned long   ntime;
static long            nusec;

void
store_start_time()
{
  gettimeofday(&tp, &tzp);
  tv_sec  = tp.tv_sec;
  tv_usec = tp.tv_usec;
}

void
wait_msec(waittime)
    int waittime;
{
  waittime *= 1000;
#ifdef HAVE_USLEEP
  gettimeofday(&tp, &tzp);
  ntime = tp.tv_sec-tv_sec;
  nusec = (long)(ntime*1000000+tp.tv_usec-tv_usec);
  waittime -= (int)nusec;
  if (waittime > 0)
    usleep(waittime);
#else
  do {
    gettimeofday(&tp, &tzp);
    ntime = tp.tv_sec-tv_sec;
    nusec = (long)(ntime*1000000+tp.tv_usec-tv_usec);
  } while ( nusec < (long)waittime);
#endif
}

void
wait_msec2(waittime)
    int waittime;
{
  waittime *= 1000;

#ifdef HAVE_USLEEP
  usleep(waittime);
#else
  gettimeofday(&tp, &tzp);
  tv_sec  = tp.tv_sec;
  tv_usec = tp.tv_usec;

  do {
    gettimeofday(&tp, &tzp);
    ntime = tp.tv_sec-tv_sec;
    nusec = (long)(ntime*1000000+tp.tv_usec-tv_usec);
  } while ( nusec < (long)waittime);
#endif

}

#else /* HAVE_GETTIMEOFDAY */

#ifdef HAVE_SYS_TIMEB_H
#include <sys/timeb.h>
#endif

static struct timeb tp;
static long btime;
static unsigned short bmilisec;
static long ntime;
static long nmilisec;

void
store_start_time()
{
  ftime(&tp);
  btime=tp.time;
  bmilisec=tp.millitm;
}

void
wait_msec(waittime)
    int waittime;
{
#ifdef HAVE_USLEEP
    ftime(&tp);
    ntime = tp.time-btime;
    nmilisec = (long)(ntime*1000+tp.millitm-bmilisec);
    waittime -= (int)nmilisec;
    if (waittime > 0)
      usleep(waittime*1000);
#else
  do {
    ftime(&tp);
    ntime = tp.time-btime;
    nmilisec = (long)(ntime*1000+tp.millitm-bmilisec);
  } while ( nmilisec < (long)waittime );
#endif
}

void
wait_msec2(waittime)
    int waittime;
{
#ifdef HAVE_USLEEP
  usleep(waittime*1000);
#else
  ftime(&tp);
  btime=tp.time;
  bmilisec=tp.millitm;

  do {
    ftime(&tp);
    ntime = tp.time-btime;
    nmilisec = (long)(ntime*1000+tp.millitm-bmilisec);
  } while ( nmilisec < (long)waittime );
#endif
}

#endif /* HAVE_GETTIMEOF_DAY */
