#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"

#define LBL_LEN 	1024

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

int
main()
{
  int   ilen, dmode;
  char  in[LBL_LEN];
  char  *imode, *lbl_str, *file_check;
  int	type;
  double high, xorg, yorg, xpos, ypos, theta, co, si;
  FILE  *fpi;

#ifdef HAVE_MEMSET
  memset(in, 0, LBL_LEN);
#else
  bzero(in, LBL_LEN);
#endif
  
  /*** LOAD SYSTEM PARAMETER ***/
  read_syscom();
  regpm();

  if (checktodvi() == True)
    writegpm();
  
  imode   = GetString(0);
  xorg    = GetScalar(1);
  yorg    = GetScalar(2);
  high    = GetScalar(3);
  theta   = GetScalar(4);
  lbl_str = GetString(5);
  dmode   = (int)  GetScalar(6);


  /*************************************
    "I" : STRING PARAMETER 5
    "F" : STRING FILE
    **************************************/

  switch (*imode) {
  case 'f': case 'F':  type = 'f'; break;
  case 'i': case 'I':
  default: type = 'i';
  }
  
  xpos = xorg;
  ypos = yorg;
  
  if ( lbl_str == NULL )
    exit(2);
  
  if (type == 'f') {	/* input from FILE */
    fpi = fopen( lbl_str, "r");
    if (fpi == NULL)
      exit(38);
    file_check = fgets(in, LBL_LEN, fpi);

    gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device,
	  GpmCont.winNum);
    gfactor(GpmCont.factor);
    gnewpen(GpmCont.fColor);
    gfont(GpmCont.fontType);
    gpen(GpmCont.fLineWidth, GpmCont.fLineType, 0 );

    co = cos((double)theta/180*M_PI);
    si = sin((double)theta/180*M_PI);

    while (file_check != NULL) {
      ilen = strlen(in);
      if (ilen > 0 && in[ilen - 1] == '\n') {
	in[ilen] = '\0';
	--ilen;
      }
      gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
      glabel(xpos, ypos, in, high, theta, dmode);
      xpos = xpos + high*1.2*si;
      ypos = ypos - high*1.2*co;
      file_check = fgets(in, LBL_LEN, fpi);
    }
    gclose();
    fclose(fpi);

  } else {

    if ( strlen(lbl_str) == 0 || (strlen(lbl_str) == 1 && lbl_str[0] == ' ' ))
      exit(0);
  
    gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device,
	  GpmCont.winNum);
    gfactor(GpmCont.factor);
    gnewpen(GpmCont.fColor);
    gpen(GpmCont.fLineWidth, GpmCont.fLineType, 0 );
    gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
    gfont(GpmCont.fontType);
    glabel(xpos, ypos, lbl_str, high, theta, dmode);
    gclose();
  }
  return 0;
}
