#include <stdio.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#define  GPM_LIB
#define  _GPM_DVI_
#include "GPMdef.h"
#include "GPMfmt.h"
  
int         dvi_fd = -1;
char        gpm_head[] = "gpm dvi file 2";
Plot        gpm_plot;
Box         gpm_box;
Csymbol     gpm_csymbol;
Label       gpm_label;
Param       gpm_param;

static int Endian = 0;

#ifndef True
#define True  1
#define False 0
#endif

static void  readplot           _ANSI_ARGS_((void));
static void  readbox            _ANSI_ARGS_((void));
static void  readcsymbol        _ANSI_ARGS_((void));
static void  readlabel          _ANSI_ARGS_((void));
static void  readroll           _ANSI_ARGS_((void));

static int   cpu_type _ANSI_ARGS_((void));
static void  reverse  _ANSI_ARGS_((char *s, int siz));


void
getlength(number, x, y, rotate)
     int    number;
     float *x, *y;
     int    rotate;
{
  static float dev_length[][2] = {
    { 210.0, 294.0 },  /* A4 Paper */
    { 257.0, 364.0 },  /* B4 Paper */
    { 150.0, 150.0 }}; /* Free Size */
  
  if ((number >= 0) && (number <= 2)) {
    if (rotate == 0) {
      *x = dev_length[number][0];
      *y = dev_length[number][1];
    } else {
      *x = dev_length[number][1];
      *y = dev_length[number][0];
    }
  } else {
    *x = 9999.0;
    *y = 9999.0;
  }
}

/*************************************************************
 *  getfontwidth()                                           *
 ************************************************************/

double
getfontwidth( c, height, font )
     int    c;
     double height;
     int    font;
{
  int    *fontbuffer;
  double  length;
  
  fontbuffer = GPMFontWidth[font%12];

  length = ((double)fontbuffer[c - 32] * height / 1000.0);
  
  return length;
}


/************************************************************
 *  getstrwidth()                                            *
 ************************************************************/
double
getstrwidth( str, height, font )
     char   *str;
     double  height;
     int     font;
{
  int    *fontbuffer;
  int     i;
  double  length;
  int     c;
  
  fontbuffer = GPMFontWidth[font%12];
  
  length = 0;
  for ( i = 0; i < strlen(str); i++) {
    c = *(str + i);
    length += ((double)fontbuffer[c - 32] * height / 1000.0);
  }
  
  return length;
}




double
trans_func(x1, y1, x2, y2, x)
     double  x1, y1, x2, y2, x;
{
  double    val;

  if ( x1-x2 != 0.0 ) 
    val = (y1 - y2) / (x1 - x2) * (x - x2) + y2;
  else
    val = y2;

  return (val);
}


int
readdvihead()
{
  int  result;
  char buf[256];
  
  if (dvi_fd == -1)
    opendvi();


  result = lseek(dvi_fd, 0L, SEEK_SET);
  result = read(dvi_fd, (char *) buf, strlen(gpm_head) + 1);
  result = strcmp(buf, gpm_head);
  if (result != 0 )
    return -1;

  result = read(dvi_fd, &(mdev.number),  sizeof(char));
  result = read(dvi_fd, &(mdev.irotate), sizeof(char));
  result = read(dvi_fd, &(mdev.todvi),   sizeof(char));

  GpmCont.paper       = mdev.number;
  GpmCont.orientation = mdev.irotate;
  GpmCont.device      = mdev.todvi;

  Endian              = cpu_type(); 
 
  return 0;
}


void
createdvi(fname, number, irotate, todvi)
     char *fname;
     int   number, irotate, todvi;
{
  int          fd;

  char cnumber = (char)number;
  char crotate = (char)irotate;
  char ctodvi  = (char)todvi;

  if (creat(fname, 0644) == -1)
    exit(30);
  
  fd = open(fname, O_RDWR, 0644);

  if (fd != -1) {
    write(fd, (char *) gpm_head, strlen(gpm_head)+1 );
    write(fd, &cnumber, sizeof(char));
    write(fd, &crotate, sizeof(char));
    write(fd, &ctodvi,  sizeof(char));

    strcpy( GpmCont.dvifile, fname);
    close(fd);
    Endian = cpu_type();
  }
}



int
checktodvi()
{
  int  device;
  int  result;
  
  device = (int)GpmCont.device;
  
  if (device != 0)
    result = True;
  else
    result = False;
  
  mdev.todvi = (char) result;
  
  return result;
}


void
opendvi()
{
  dvi_fd = open( GpmCont.dvifile, O_RDWR, 0644);
  if (dvi_fd == -1) {
    fprintf(stderr, "Cannot open %s\n", GpmCont.dvifile);
    exit(31);
  }
  lseek(dvi_fd, (long) 0, SEEK_END);

  Endian = cpu_type();
}

void
opendvi_for_read()
{
  dvi_fd = open( GpmCont.dvifile, O_RDONLY);
  if (dvi_fd == -1) {
    fprintf(stderr, "Cannot open %s\n", GpmCont.dvifile);
    exit(31);
  }
  lseek(dvi_fd, (long) 0, SEEK_END);

  Endian = cpu_type();
}


void
closedvi()
{
  if (close(dvi_fd) == -1)
    exit(32);
}


void
writegpm()
{
  unsigned char comnum;
  Param temp;
  
  if (mdev.todvi != 0) {

    if (dvi_fd == -1)
      opendvi();
    
    comnum = 0x80;
    write(dvi_fd, (char *) &comnum, sizeof(unsigned char));

    gpm_param.endmark = temp.endmark = 0x80;
    gpm_param.factor  = temp.factor  = GpmCont.factor;
    gpm_param.xorg    = temp.xorg    = GpmCont.xOrigin;
    gpm_param.yorg    = temp.yorg    = GpmCont.yOrigin;

    if ( Endian != 0 ) {
      reverse((char*)&(temp.factor),sizeof(float));
      reverse((char*)&(temp.xorg)  ,sizeof(float));
      reverse((char*)&(temp.yorg)  ,sizeof(float));
    }
    
    write(dvi_fd, (char *)&temp, sizeof(Param));
  }
}

void
writeplot(x, y, ipen_mode)
     double  x, y;
     int     ipen_mode;
{
  char num;
  Plot temp;
  
  if (mdev.todvi != 0) {
    if (dvi_fd == -1)
      opendvi();
    
    num = NPLOT;
    write(dvi_fd, (char *) &num, sizeof(char));
    
    gpm_plot.x         = temp.x         = x;
    gpm_plot.y         = temp.y         = y;
    gpm_plot.ipen_mode = temp.ipen_mode = (char) ipen_mode;
    gpm_plot.color     = temp.color     = (char) mpen.icolor;
    gpm_plot.rainbow   = temp.rainbow   = (char) mpen.rainbow;
    gpm_plot.lwidth    = temp.lwidth    = (char) mpen.isize;
    gpm_plot.ltype     = temp.ltype     = (char) mpen.itype;

    if ( Endian != 0 ) {
      reverse((char*)&temp.x, sizeof(float));
      reverse((char*)&temp.y, sizeof(float));
    }
    
    write(dvi_fd, (char *) &temp, sizeof(Plot));

  }
}

void
writebox(x1, y1, x2, y2, mode, level)
     double  x1, y1, x2, y2, level;
     int     mode;
{
  char num;
  Box  temp;
  
  if (mdev.todvi != 0) {
    if (dvi_fd == -1)
      opendvi();
    
    num = NBOX;
    write(dvi_fd, &num, sizeof(char));

    gpm_box.x1     = temp.x1     = x1;
    gpm_box.y1     = temp.y1     = y1;
    gpm_box.x2     = temp.x2     = x2;
    gpm_box.y2     = temp.y2     = y2;
    gpm_box.level  = temp.level  = (float)level;
    gpm_box.mode   = temp.mode   = (char) mode;
    gpm_box.color  = temp.color  = (char) mpen.icolor;
    gpm_box.ltype  = temp.ltype  = (char) mpen.itype;
    gpm_box.lwidth = temp.lwidth = (char) mpen.isize;
    
    if ( Endian != 0 ) {
      reverse((char*)&temp.x1   , sizeof(float));
      reverse((char*)&temp.y1   , sizeof(float));
      reverse((char*)&temp.x2   , sizeof(float));
      reverse((char*)&temp.y2   , sizeof(float));
      reverse((char*)&temp.level, sizeof(float));
    }
    
    write(dvi_fd, (char *) &temp, sizeof(Box));
  }
}

void
writecsymbol(x, y)
     double  x, y;
{
  char num;
  Csymbol temp;
  
  if (mdev.todvi != 0) {
    if (dvi_fd == -1)
      opendvi();
    
    num = NCSYMBOL;
    write(dvi_fd, &num, sizeof(char));
    
    gpm_csymbol.x      = temp.x      = x;
    gpm_csymbol.y      = temp.y      = y;
    gpm_csymbol.cdata  = temp.cdata  = (char) msymbol.cdata;
    gpm_csymbol.height = temp.height = (float)msymbol.height;
    gpm_csymbol.theta  = temp.theta  = (float)msymbol.theta;
    gpm_csymbol.color  = temp.color  = (char) mpen.icolor;
    gpm_csymbol.lwidth = temp.lwidth = (char) mpen.isize;

    if ( Endian != 0 ) {
      reverse((char*)&temp.x,      sizeof(float));
      reverse((char*)&temp.y,      sizeof(float));
      reverse((char*)&temp.height, sizeof(float));
      reverse((char*)&temp.theta,  sizeof(float));
    }
    
    write(dvi_fd, (char *) &temp, sizeof(Csymbol));

  }
}


void
writelabel(x, y, ichar, height, theta, imode)
     double  x, y, height;
     char   *ichar;
     double  theta;
     int     imode;
{
  char num;
  Label temp;

  if (mdev.todvi != 0) {
    if (dvi_fd == -1)
      opendvi();
    
    num = NLABEL;
    write(dvi_fd, &num, sizeof(char));
    
    gpm_label.x      = temp.x      = x;
    gpm_label.y      = temp.y      = y;
    gpm_label.ilen   = temp.ilen   = (unsigned char) strlen(ichar);
    gpm_label.ichar  = temp.ichar  = (char *) ichar;
    gpm_label.height = temp.height = height;
    gpm_label.theta  = temp.theta  = theta;
    gpm_label.mode   = temp.mode   = (char) imode;
    gpm_label.color  = temp.color  = (char) mpen.icolor;
    gpm_label.font   = temp.font   = (char) msymbol.font;

    if ( Endian != 0 ) {
      reverse((char*)&temp.x     , sizeof(float));
      reverse((char*)&temp.y     , sizeof(float));
      reverse((char*)&temp.height, sizeof(float));
      reverse((char*)&temp.theta,  sizeof(float));
    }
    
    write(dvi_fd, (char *) &temp.x     , sizeof(float));
    write(dvi_fd, (char *) &temp.y     , sizeof(float));
    write(dvi_fd, (char *) &temp.ilen  , sizeof(unsigned char));
    write(dvi_fd, (char *) temp.ichar  , (int)gpm_label.ilen + 1);
    write(dvi_fd, (char *) &temp.height, sizeof(float));
    write(dvi_fd, (char *) &temp.theta,  sizeof(float));
    write(dvi_fd, (char *) &temp.mode,   sizeof(char));
    write(dvi_fd, (char *) &temp.color , sizeof(char));
    write(dvi_fd, (char *) &temp.font  , sizeof(char));

  }
}


void
writeroll()
{
  char  num;
  
  if (mdev.todvi != 0) {
    if (dvi_fd == -1)
      opendvi();
    num = NROLL;
    write(dvi_fd, (char *) &num, sizeof(char));

  }
}


int
readgpm()
{
  int result;
  
  if (dvi_fd == -1)
    opendvi();

  result = read(dvi_fd, (char *) &gpm_param, sizeof(Param));

  if ( Endian != 0 ) {
    reverse((char*)&(gpm_param.factor),sizeof(float));
    reverse((char*)&(gpm_param.xorg)  ,sizeof(float));
    reverse((char*)&(gpm_param.yorg)  ,sizeof(float));
  }

  return result;
}


int
readdvi()
{
  char num;
  int  result;
  
  if (dvi_fd == -1)
    opendvi();
  
  result = read(dvi_fd, (char *) &num, sizeof(char));

  if (result > 0) {
    switch (num) {
    case NPLOT:
      readplot();
      break;
    case NBOX:
      readbox();
      break;
    case NCSYMBOL:
      readcsymbol();
      break;
    case NLABEL:
      readlabel();
      break;
    case NROLL:
      readroll();
      break;
    }
    result = (int) num;
  } else
    result -= 1;

  return result;
}


static void
readplot()
{
  read(dvi_fd, (char *) &gpm_plot, sizeof(Plot));

  if ( Endian != 0 ) {
    reverse((char*)&gpm_plot.x, sizeof(float));
    reverse((char*)&gpm_plot.y, sizeof(float));
  }
}


static void
readbox()
{
  read(dvi_fd, (char *) &gpm_box, sizeof(Box));

  if ( Endian != 0 ) {
    reverse((char*)&gpm_box.x1   , sizeof(float));
    reverse((char*)&gpm_box.y1   , sizeof(float));
    reverse((char*)&gpm_box.x2   , sizeof(float));
    reverse((char*)&gpm_box.y2   , sizeof(float));
    reverse((char*)&gpm_box.level, sizeof(float));
  }
}


static void
readcsymbol()
{
  read(dvi_fd, (char *) &gpm_csymbol, sizeof(Csymbol));

  if ( Endian != 0 ) {
    reverse((char*)&gpm_csymbol.x     , sizeof(float));
    reverse((char*)&gpm_csymbol.y     , sizeof(float));
    reverse((char*)&gpm_csymbol.height, sizeof(float));
    reverse((char*)&gpm_csymbol.theta,  sizeof(float));
  }
}

static void
readlabel()
{
  read(dvi_fd, (char *) &gpm_label.x   , sizeof(float));
  read(dvi_fd, (char *) &gpm_label.y   , sizeof(float));
  read(dvi_fd, (char *) &gpm_label.ilen, sizeof(char) );

  if (gpm_label.ichar != NULL)
    free(gpm_label.ichar);
  gpm_label.ichar = (char *) calloc((unsigned) gpm_label.ilen + 1,
				    sizeof(char));

  read(dvi_fd, (char *)  gpm_label.ichar, (int)gpm_label.ilen + 1);
  read(dvi_fd, (char *) &gpm_label.height, sizeof(float));
  read(dvi_fd, (char *) &gpm_label.theta,  sizeof(float));
  read(dvi_fd, (char *) &gpm_label.mode,   sizeof(char));
  read(dvi_fd, (char *) &gpm_label.color,  sizeof(char));
  read(dvi_fd, (char *) &gpm_label.font,   sizeof(char));

  if ( Endian != 0 ) {
    reverse((char*)&gpm_label.x,      sizeof(float));
    reverse((char*)&gpm_label.y,      sizeof(float));
    reverse((char*)&gpm_label.height, sizeof(float));
    reverse((char*)&gpm_label.theta,  sizeof(float));
  }
}


static void
readroll()
{
}


static int
cpu_type()
{
  short i = 0x0001;
  char *c = (char *)&i;
  return ((int)c[0] == 1);
}

static void
reverse(s, siz)
    char  *s;
    int             siz;
{
  register int    i;
  register char c;
  int half = siz / 2, j = siz - 1;
  
  for (i = 0; i < half; i++) {
    c      = s[i];
    s[i]   = s[j - i];
    s[j-i] = c;
  }
}
