/**********************************************************
 *          GPM-X   Subroutine Package  NO.1              *
 *                                                        *
 *             Groval Valiable Table                      *
 *                                                        *
 *             gopen(), gclose(), gflush()                *
 *             createrainbow()                            *
 *             createWin(), getWindow(), putWindow()      *
 *                                                        *
 **********************************************************
 *         Coded    by T.Kobayashi     90/09/13           *
 *         Recoded  by Takashi Kodera  92/04/07           *
 *         Modified by K.Takebe        94/01/06           *
 **********************************************************/

#include "SL_macro.h"
#include "SL_cmd.h"
#define  GPM_LIB
#include "GPMdef.h"
#define  _GPMX1_
#include "GPMwin.h"

FILE             *gpm_fp;

Window            gpm_window;
Pixmap            gpm_pixmap;
Display          *gpm_display;
int               gpm_screen;
int               gpm_depth;
Colormap          gpm_cmap;
GC                gpm_gc;
XStandardColormap gpm_smap;
unsigned int      gpm_color[MAX_COLOR];
unsigned int      gpm_rainbow[RAINBOW_BASECOL * RAINBOW_DIVNUM + 2];
char             *colorname[MAX_COLOR] = {
#ifdef WHITE_BGCOLOR
  "White", "Blue", "Red", "Magenta",
  "Green", "Cyan", "Yellow", "Black",
#else
  "Black", "Blue", "Red", "Magenta",
  "Green", "Cyan", "Yellow", "White",
#endif /* WHITE_BGCOLOR */
  "gray80", "gray60", "gray30"
};

int               flags = DoRed | DoGreen | DoBlue;

/*
Mscale            mscale;
Mwin              mwin;
*/

#ifndef COLOR_YES
#define COLOR_YES	1
#endif
#ifndef COLOR_NO
#define COLOR_NO	0
#endif


/*********************************************************
 *        gopen                                           *
 *********************************************************/

void
gopen( paper, orientation, device, win_num )
     int  paper, orientation, device, win_num;
{
  GpmWinID           winID;
  int                result, i;
  XColor             c, color;
  XWindowAttributes  attr;
  
  if ( win_num < 0 ) {
    printf("\n");
    exit(24);
  }  

  if (device < 2) {
    gpm_display = XOpenDisplay(NULL);
    gpm_screen  = DefaultScreen(gpm_display);
    winID       = getWindow( win_num );
    gpm_window  = winID.wid;
    gpm_pixmap  = winID.pix;
    gpm_cmap    = DefaultColormap(gpm_display, gpm_screen);
    gpm_depth   = DefaultDepth(gpm_display, gpm_screen);
    mwin.color = ( gpm_depth == 1 ) ? COLOR_NO : COLOR_YES;

    XSync(gpm_display, 0);
  
    if (gpm_depth == 1) {
#ifdef WHITE_BGCOLOR
      gpm_color[0] = WhitePixel(gpm_display, gpm_screen);
#else
      gpm_color[0] = BlackPixel(gpm_display, gpm_screen);
#endif /* WHITE_BGCOLOR */
      for (i = 1; i < MAX_COLOR; i++)
#ifdef WHITE_BGCOLOR
	gpm_color[i] = BlackPixel(gpm_display, gpm_screen);
#else
	gpm_color[i] = WhitePixel(gpm_display, gpm_screen);
#endif /* WHITE_BGCOLOR */
    } else if (gpm_depth >= 4) {
      for (i = 0; i < MAX_COLOR; i++) {
	result = XAllocNamedColor(gpm_display, gpm_cmap,
				  colorname[i], &c, &color);
	if (result == 0) {
#ifdef WHITE_BGCOLOR
	  gpm_color[i] = BlackPixel(gpm_display, gpm_screen);
#else
	  gpm_color[i] = WhitePixel(gpm_display, gpm_screen);
#endif /* WHITE_BGCOLOR */
	  gpm_depth = 4;
	} else
	  gpm_color[i] = color.pixel;
      }
    }
    createrainbow();
    XGetWindowAttributes(gpm_display, gpm_window, &attr);
  
    mwin.ixleng  = attr.width;
    mwin.iyleng  = attr.height;
  } else {
    gpm_display = NULL;
    gpm_screen  = 0;
    gpm_window  = 0;
    mwin.color = COLOR_YES;
  }
  
  mdev.number  = paper; 
  mdev.irotate = orientation;
  mdev.todvi   = device;
  
  if ( mdev.todvi != 0 )
    opendvi();
  
  getlength( paper, &mdev.xleng, &mdev.yleng, orientation);
  
  mdev.ixleng = attr.width;
  mdev.iyleng = attr.height;
  
  if ( paper < 2 ) {
    
    mdev.ffx = mdev.ixleng / mdev.xleng;
    mdev.ffy = mdev.iyleng / mdev.yleng;
    
  } else {
    mdev.ffx = 3.544615;
    mdev.ffy = 3.544615;
    /*    mdev.ffy = 3.543307; */ /* assuming same dot pitch, by take */

    mdev.xleng = mdev.ixleng / mdev.ffx;
    mdev.yleng = mdev.iyleng / mdev.ffy;
    
  }
  mwin.ffx        = mdev.ffx;
  mwin.ffy        = mdev.ffy;
  
  mgraph.xmin     = 0.0;
  mgraph.ymin     = 0.0;
  mgraph.cline    = 0;
  mgraph.xmax     = mdev.xleng;
  mgraph.ymax     = mdev.yleng;
  mgraph.xorg     = 20.0;
  mgraph.yorg     = 20.0;
  mgraph.xaxis    = 100.0;
  mgraph.yaxis    = 100.0;
  mgraph.factor   = 1.0;
  mgraph.xpre     = mgraph.xorg;
  mgraph.ypre     = mgraph.yorg;

  mscale.xdat_min = 0.0;
  mscale.xdat_max = 0.0;
  mscale.ydat_min = 0.0;
  mscale.ydat_max = 0.0;

  msymbol.cdata   = 0x20;
  msymbol.height  = 2.5;
  msymbol.theta   = 0.0;
  msymbol.font    = 0;


  /* Pen Parameter Set : X-Window Version is supported by GC */
  
  if (gpm_display != NULL && gpm_window != 0)
    gpm_gc = XCreateGC(gpm_display, gpm_window, 0, NULL);
  
  gnewpen(7);
  mpen.icolor  = 7;	/* WHITE */
  mpen.rainbow = -1;
  mpen.imode   = 0;
  mpen.isize   = 0;
  mpen.itype   = 0;
}



/*********************************************************
 *        gclose                                          *
 *********************************************************/
void
gclose()
{
  gflush();
  
  if (mdev.todvi != 0)
    closedvi();
  
  if (gpm_display != NULL) {
    XFreeGC(gpm_display, gpm_gc);
    XCloseDisplay(gpm_display);
  }
}


/*********************************************************
 *        gflush                                          *
 *********************************************************/
void
gflush()
{
  if (gpm_display != NULL) 
    XFlush(gpm_display);
}


/*********************************************************
  createWin()
 *********************************************************/
int
createWin()
{
  GpmWinID  win[MAX_WIN];
  FILE     *win_fp;
  char      win_fname[FILE_LENGTH];
  int       i;

  strcpy( win_fname, get_tmpdir() );
  strcat( win_fname, WIN_FNAME );

  if ( access( win_fname, F_OK ) == 0 )
    return 1;

  win_fp = fopen( win_fname, "w" );
  if ( win_fp != NULL) {
    for ( i = 0; i < MAX_WIN; i++ ) {
      win[i].wid = (Window) 0;
      win[i].pix = (Pixmap) 0;
      win[i].pid =          0;
    }
    fwrite( (char*)win, sizeof(GpmWinID), MAX_WIN, win_fp );
    fclose(win_fp);
  } else {
    printf("createWin(): cannot open %s\n", win_fname );
    exit(0);
  }
  return 0;
}


/*********************************************************
  getWindow()
 *********************************************************/
GpmWinID
getWindow( win_num )
     int win_num;
{
  GpmWinID  win[MAX_WIN];
  FILE   *win_fp;
  char    win_fname[FILE_LENGTH];

  if ( win_num >= 0 && win_num < MAX_WIN ) {
    strcpy( win_fname, get_tmpdir() );
    strcat( win_fname, WIN_FNAME );
    win_fp = fopen( win_fname, "r" );
    
    if ( win_fp ) {
      fread( (char*)win, sizeof(GpmWinID), MAX_WIN, win_fp );
      fclose( win_fp );
    } else {
      printf("getWindow(): cannot open %s\n", win_fname );
      exit(0);
    }
  } else {
    win_num = 0;
    win[0].wid = (Window) 0;
    win[0].pix = (Pixmap) 0;
    win[0].pid =          0;
  }    
  return win[(int)win_num];
}


/*********************************************************
  putWindow()
 *********************************************************/
void
putWindow( win_num, win )
     int       win_num;
     GpmWinID  win;
{
  GpmWinID  winID[MAX_WIN];
  FILE     *win_fp;
  char      win_fname[FILE_LENGTH];

  if ( win_num >= 0 && win_num < MAX_WIN ) {
    strcpy( win_fname, get_tmpdir() );
    strcat( win_fname, WIN_FNAME );
    win_fp = fopen( win_fname, "r+" );

    if ( win_fp ) {
      fread( (char*) winID, sizeof(GpmWinID), MAX_WIN, win_fp );
      fseek( win_fp, 0L, 0 );

      winID[(int)win_num] = win;
      fwrite( (char*) winID, sizeof(GpmWinID), MAX_WIN, win_fp );
      fclose( win_fp );
    } else {
      printf("cannot open %s\n", win_fname );
      exit(0);
    }
  }
}


/*********************************************************
 *        createrainbow                                   *
 *********************************************************/
static void setCols _ANSI_ARGS_((int n, double r, double g, double b));

void
createrainbow()
{
  double	 r, g, b, level;
  int	 i, n, maxcols;
  int	div      = RAINBOW_DIVNUM;
  int	basecol  = RAINBOW_BASECOL;
  double	rbasecol = 1.0 / basecol;
  void setCols();
  
  if ( gpm_depth >= 8 ) {
    maxcols = div*basecol;
    n = 1;
    for ( i = 0; i < div; i++, n++ ) {
      level = (double)n / (double)maxcols;
      r = 0.0;
      g = 0.0;
      b = level/rbasecol;
      setCols( n-1, r, g, b );
    }
    for ( i = 0; i < div; i++, n++ ) {
      level = (double)n / (double)maxcols;
      r = 0.0;
      g = (level-rbasecol)/rbasecol;
      b = 1.0;
      setCols( n-1, r, g, b );
    }
    for ( i = 0; i < div; i++, n++ ) {
      level = (double)n / (double)maxcols;
      r = 0.0;
      g = 1.0;
      b = 1.0 - (level-rbasecol*2.0)/rbasecol;
      setCols( n-1, r, g, b );
    }
    for ( i = 0; i < div; i++, n++ ) {
      level = (double)n / (double)maxcols;
      r = (level-rbasecol*3.0)/rbasecol;
      g = 1.0;
      b = 0.0;
      setCols( n-1, r, g, b );
    }
    for ( i = 0; i <= div; i++, n++ ) {
      level = (double)n / (double)maxcols;
      r = 1.0;
      g = 1.0 - (level-rbasecol*4.0)/rbasecol;
      b = 0.0;
      setCols( n-1, r, g, b );
    }
    r = g = b = 1.0;
    setCols( n-1, r, g, b );

  } else if ((gpm_depth == 4) || (gpm_depth == 1)) {
    gpm_rainbow[0] = gpm_color[1];
    gpm_rainbow[1] = gpm_color[5];
    gpm_rainbow[2] = gpm_color[4];
    gpm_rainbow[3] = gpm_color[6];
    gpm_rainbow[4] = gpm_color[2];
    gpm_rainbow[5] = gpm_color[2];
  }
}

static void
setCols( n, r, g, b )
    int n;
    double r, g, b;
{
  XColor rainbow;
  
  rainbow.red   = ( r > 0.0 ) ? 65535 * sqrt((double)r) : 0;
  rainbow.green = ( g > 0.0 ) ? 65535 * sqrt((double)g) : 0;
  rainbow.blue  = ( b > 0.0 ) ? 65535 * sqrt((double)b) : 0;
  rainbow.flags = flags;

  XAllocColor(gpm_display, gpm_cmap, &rainbow);
  gpm_rainbow[n] = rainbow.pixel;
}

void
set_tile_pattern (display, screen, d, gc, level)
     Display *display;
     int screen;
     Drawable d;
     GC gc;
     double level;
{

  static char col_0[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  static char col_1[] = {0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00};
  static char col_2[] = {0x11, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00};
  static char col_3[] = {0x11, 0x00, 0x44, 0x00, 0x11, 0x00, 0x44, 0x00};
  static char col_4[] = {0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44};
  static char col_5[] = {0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa};
  static char col_6[] = {0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb};
  static char col_7[] = {0xee, 0xff, 0xbb, 0xff, 0xee, 0xff, 0xbb, 0xff};
  static char col_8[] = {0xee, 0xff, 0xff, 0xff, 0xbb, 0xff, 0xff, 0xff};
  static char col_9[] = {0xfe, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff};
  static char col_a[] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

  static char * col_table[] = {
    col_0, col_1, col_2, col_3, col_4, col_5,
    col_6, col_7, col_8, col_9, col_a };

  static Pixmap pixmap_table[16] = {
    (Pixmap)0,(Pixmap)0,(Pixmap)0,(Pixmap)0,
    (Pixmap)0,(Pixmap)0,(Pixmap)0,(Pixmap)0,
    (Pixmap)0,(Pixmap)0,(Pixmap)0,(Pixmap)0,
    (Pixmap)0,(Pixmap)0,(Pixmap)0,(Pixmap)0 };

  unsigned long black = BlackPixel (display, screen);
  unsigned long white = WhitePixel (display, screen);

  Pixmap bitmap;
  char  *bits;
  int    level_num;

  if      (level < 0.0) level_num =  0;
  else if (level > 1.0) level_num = 10;

  else {

    level_num = (int) (level * 11);
    if (level_num == 11) level_num = 10;
  }

  if (pixmap_table[level_num] == (Pixmap)0 ) {

    bits = *(col_table + level_num);
    bitmap = XCreateBitmapFromData (display, d, bits, 8, 8);
    pixmap_table [level_num] = bitmap;

  } else {

    bitmap = pixmap_table [level_num];
  }

  XSetStipple (display, gc, bitmap);
  XSetFillStyle (display, gc, FillOpaqueStippled);
#ifdef WHITE_BGCOLOR
  XSetForeground (display, gc, black);
  XSetBackground (display, gc, white);
#else
  XSetForeground (display, gc, white);
  XSetBackground (display, gc, black);
#endif /* WHITE_BGCOLOR */
}
