/**********************************************************
 *          GPM-X   Subroutine Package  NO.2              *
 *                                                        *
 *             gplot()  glabel()   gbox()                 *
 *             gerase() gframe() groll()                  *
 *                  Coded By  T.Kobayashi                 *
 *                                                        *
 *                            11/24/89                    *
 *                            05/01/90 Box Append         *
 *********************************************************/
#include "SL_macro.h"
#include "SL_cmd.h"
#define  GPM_LIB
#include "GPMdef.h"
#include "GPMwin.h"

/*********************************************************
 *                                                        *
 *        gplot                                           *
 *                                                        *
 *********************************************************/
void
gplot( x, y, imode )
    double  x, y;
    int   imode;
{
  if (imode > 3)
    imode = 3;
  else if (imode < -3)
    imode = -3;

  plot(x, y, imode);
}


/**********************************************************
 *                                                        *
 *        gbox                                            *
 *                                                        *
 *********************************************************/
void
gbox(x1, y1, x2, y2, imode, level)
     double x1, y1, x2, y2, level;
     int imode;
{
  box(x1, y1, x2, y2, imode, level);
}


/*********************************************************
 *                                                        *
 *        glabel                                          *
 *                                                        *
 *********************************************************/
void
glabel(x, y, ichar, height, theta, imode)
     double  x, y, height;
     char  *ichar;
     double  theta;
     int    imode;
{
  label(x, y, ichar, height, theta, imode);
}

/*********************************************************
 *                                                        *
 *        glabel                                          *
 *                                                        *
 *********************************************************/
void
gfont( type )
    int   type;
{
  msymbol.font = type;
}

/*********************************************************
 *                                                        *
 *        gframe                                          *
 *                                                        *
 *********************************************************/
void
gframe()
{
  box(0.0, 0.0, mgraph.xaxis, mgraph.yaxis, 1, -1.0 );
}


/*********************************************************
 *                                                        *
 *        gerase   ( Color Not Support )                  *
 *                                                        *
 *********************************************************/
void
gerase()
{
  /* X-Window Library Function Direct Call */
  if (gpm_display != NULL){
    GC gc;
    unsigned int w,h,pw,ph;
    Window r; int x, y; unsigned int bw,d;
    gc = XCreateGC(gpm_display, gpm_window, NULL, NULL);
    XSetForeground(gpm_display, gc, 
#ifdef WHITE_BGCOLOR
                   WhitePixel(gpm_display, gpm_screen));
#else
                   BlackPixel(gpm_display, gpm_screen));
#endif /* WHITE_BGCOLOR */
    XGetGeometry(gpm_display, gpm_pixmap, &r, &x, &y, &w, &h, &bw, &d);
    XFillRectangle(gpm_display, gpm_pixmap, gc, 0, 0, w,h);
    XGetGeometry(gpm_display, gpm_window, &r, &x, &y, &w, &h, &bw, &d);
    XFillRectangle(gpm_display, gpm_window, gc, 0, 0, w,h);
    XFreeGC(gpm_display, gc);
    /* XClearWindow(gpm_display, gpm_window); */
  }
}


/**********************************************************
 *                                                        *
 *        groll                                           *
 *                                                        *
 *********************************************************/
int
groll()
{
  if (gpm_display != NULL && gpm_window != 0){
    gerase();
    /* XClearWindow(gpm_display, gpm_window); */
  }
  
  roll();
  return True;
}
