/*********************************************************
 *                                                        *
 *          GPM-X   Subroutine Package  NO.3              *
 *                                                        *
 *        gaxis() gaxisl() graph()                        *
 **********************************************************
 *                                                        *
 *                  Coded By  T.Kobayashi                 *
 *                                                        *
 *                            11/24/89                    *
 *                                                        *
 *********************************************************/

#include <math.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#define  GPM_LIB
#include "GPMdef.h"
#include "GPMwin.h"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

static double
gpm_aint(x)
    double x;
{
  double sgn, y;
  
  sgn = ( x < 0.0 ) ? -1.0 : 1.0;
  y = floor(fabs(x));
  if ( y != 0.0 ) y *= sgn;

  return y;
}


/**********************************************************
 *                                                        *
 *        graph                                           *
 *                                                        *
 *********************************************************/
void
graph(xdata, ydata, idat_number, inc, imode, symbl, symbl_size)
     float *xdata, *ydata, symbl_size;
     int   idat_number, inc;
     int   imode, symbl;
{
  int    iflag_g, iflag_s, iflag_f, iflag_b;
  double  x, y, y0, xdlt, ydlt, xdlt_inv, ydlt_inv;
  double  xpre, ypre;
  register int    i;
  
  iflag_g = iflag_s = iflag_f = iflag_b = 0;
  
  switch (imode) {
  case 2:		/* Line & Center symbol */
    iflag_g = 1;
  case 1:		/* Center Symbol */
    iflag_s = 1;
    break;
  case 4:               /* Bar and Graph */
    iflag_g = 1;
  case 3:		/* Bar */
    iflag_b = 1;
    break;
  case 5:		/* Filled Graph */
    iflag_f = 1;
    break;
  case 0:		/* Line */
  default:
    iflag_g = 1;
    break;
  }

  xdlt = (mscale.xdat_max - mscale.xdat_min) / mgraph.xaxis;
  ydlt = (mscale.ydat_max - mscale.ydat_min) / mgraph.yaxis;

  xdlt_inv = (xdlt != 0.0) ? 1.0/xdlt : 1.0;
  ydlt_inv = (ydlt != 0.0) ? 1.0/ydlt : 1.0;

  if (inc == 0)
    inc = 1;

  x  = (xdata[0] - mscale.xdat_min) * xdlt_inv;
  y  = (ydata[0] - mscale.ydat_min) * ydlt_inv;
  if (!iflag_f) {
    if (iflag_g) {
      plot(x, y, 0);
      for (i = inc; i < idat_number-1; i += inc) {
	x = (xdata[i] - mscale.xdat_min) * xdlt_inv;
	y = (ydata[i] - mscale.ydat_min) * ydlt_inv;
	plot(x, y, 1);
      }
      x = (xdata[idat_number-1] - mscale.xdat_min) * xdlt_inv;
      y = (ydata[idat_number-1] - mscale.ydat_min) * ydlt_inv;
      plot(x, y, 2);
    } else if ( iflag_b ) {
      y0 =          - mscale.ydat_min  * ydlt_inv;
      plot(x, y0, 0);
      plot(x, y,  1);
      for (i = inc; i < idat_number-1; i += inc) {
	x = (xdata[i] - mscale.xdat_min) * xdlt_inv;
	y = (ydata[i] - mscale.ydat_min) * ydlt_inv;
	plot( x, y0, 0);
	plot( x, y,  1);
      } 
      x = (xdata[idat_number-1] - mscale.xdat_min) * xdlt_inv;
      y = (ydata[idat_number-1] - mscale.ydat_min) * ydlt_inv;
      plot( x, y0, 0);
      plot(x, y, 2);
    }

    if (iflag_s == 1) {
      x  = (xdata[0] - mscale.xdat_min) * xdlt_inv;
      y  = (ydata[0] - mscale.ydat_min) * ydlt_inv;
      msymbol.cdata  = symbl;
      msymbol.height = symbl_size;
      csymbol(x, y);
      for (i = inc; i < idat_number; i += inc) {
	x = (xdata[i] - mscale.xdat_min) * xdlt_inv;
	y = (ydata[i] - mscale.ydat_min) * ydlt_inv;
	csymbol(x, y);
      }
    }
  } else {
    xpre = x;
    ypre = y;
    y0 =          - mscale.ydat_min  * ydlt_inv;
    for ( i = inc; i < idat_number; i+= inc ) {
      x = (xdata[i] - mscale.xdat_min) * xdlt_inv;
      y = (ydata[i] - mscale.ydat_min) * ydlt_inv;
      plot(xpre, y0,   0);
      plot(xpre, ypre, 1);
      plot(x,    y,    1);
      plot(x,    y0,   1);
      plot(xpre, y0,   3);
      xpre = x;
      ypre = y;
    }
  }
}


static double
gpm_autoscale( a1, a2 )
    double a1, a2;
{
  static double t[9] =
    { 0.025, 0.05, 0.1, 0.2, 0.25, 0.5, 1.0, 2.0, 2.5 };
  static double xt[9] =
    { -0.93, -0.648, -0.347, -0.125, 0.07, 0.544, 0.657, 0.875 };

  double x, lx, y;
  double z;
  int a = 0;

  if ( a1 == a2 ) {
    z= (double)(a1/2.0);
  } else {
    x  = fabs((double)(a1 - a2));
    lx = log10(x);
    y  = lx - floor(lx);
    
    if ( y < xt[0] )                    a = 0;
    else if ( xt[0] <= y && y < xt[1] ) a = 1;
    else if ( xt[1] <= y && y < xt[2] ) a = 2;
    else if ( xt[2] <= y && y < xt[3] ) a = 3;
    else if ( xt[3] <= y && y < xt[4] ) a = 4;
    else if ( xt[4] <= y && y < xt[5] ) a = 5;
    else if ( xt[5] <= y && y < xt[6] ) a = 6;
    else if ( xt[6] <= y && y < xt[7] ) a = 7;
    else if ( xt[7] <= y )              a = 8;

    z = (double)( t[a]*pow(10.0,floor(lx)));
  }
  
  return z;
}


/*********************************************************
 *                                                        *
 *        gaxis                                           *
 *                                                        *
 *********************************************************/
void
gaxis( x, y, aleng, theta, dmin, dmax, ainc, iformat,
      imode, ctitle, size, igrid, gleng)
    double x, y, aleng, dmin, dmax, ainc, size, gleng;
    double theta;
    int   iformat, imode, igrid;
    char  *ctitle;
{
  double delt, work, count, xorg, yorg, xx, yy;
  double sleng, rcos, rsin, rad, vpos, tpos;
  double pval, ofst;
  int   inc, iflag;
  int   itype;
  long  val;
  char  cval[33], *buffer;
  
  xorg = x;
  yorg = y;
  
  GpmSet_dash_width_dmode(0, mpen.isize, (int)mpen.imode);
  GpmSet_color((int)mpen.icolor, -1 );
  
  rad = theta;
  theta = theta * 180.0 / M_PI;
  rcos = (double) cos((double) rad);
  rsin = (double) sin((double) rad);
  
  /* 10^n */
  work = (fabs((double)dmax) > fabs((double)dmin)) ? dmax : dmin;
  if (work < 0.0)  work *= -1.0;
  if (work == 0.0) work  =  1.0; 
  pval = (double) gpm_aint(log10((double) work));
  
  if ( iformat < 0 &&
      ( dmax > (double)pow(2.0,32.0) || -dmin > (double)pow(2.0,32.0))) {
    printf("axis: warning: cannot represent without index value.\n");
    iformat *= -1;
  }
  
  if ( fabs( dmax - dmin ) / (double)pow(10.0,(double)pval) < 3.0 &&
      abs(iformat) == 2 )
    pval = pval -1.0;
  
  if ((pval > 3 || pval < 0) && (iformat > 0)) {
    ofst = (double) pow((double) 10.0, (double) pval);
  } else {
    ofst = 1.0;
    pval = 0.0;
  }

  if (iformat < 0)
    iformat *= -1;

  /* Symbol Position */
  if (imode == 0) {	/* On The Axis */
    vpos = 2.0;
    tpos = vpos + size + 2.0;
    sleng = 1.5;
  } else {		/* Under The Axis */
    vpos = -2.0 - size;
    tpos = vpos - 2.0 - size;
    sleng = -1.5;
  }
  
  if (ainc == 0.0) {
    ainc = gpm_autoscale(dmin, dmax);
    if ( ainc >= 1.0 ) {
      if ( iformat == 2 /* integer scale */)
	ainc = (double)floor((double)ainc);
      ainc /= ofst;
    } else {
      pval = (double) gpm_aint(log10((double) ainc));
      pval -= ( iformat == 2 ) ? 1.0 : ( ainc < 0.1 );
      ofst = (double) pow(10.0, (double) pval);
      ainc /= ofst;
      if ( iformat != 2 && ainc == 0.25 ) ainc = 0.2;
      if ( iformat == 2 /* integer scale */)
	ainc = (double)floor((double)ainc);
    }
    if ( ainc == 0.0 ) ainc = 1.0;
  } else
    ainc /= ofst; 

  /* Axis Draw */
  dmin /= ofst;
  dmax /= ofst;
  delt = (dmax - dmin) / aleng;
  
  work = dmin / ainc;
  inc = (int)work - 1;
  
  if (igrid != 0) {
    sleng = gleng * (-(imode == 0) + (imode == 1));

    itype = igrid - 1;
    GpmSet_dash_width_dmode((int)itype, (int)mpen.isize, (int)mpen.imode);
  }

  x = aleng * rcos;
  y = aleng * rsin;
  plot(xorg, yorg, 0);
  plot(xorg + x, yorg + y, 2);

  iflag = 0;
  for (count = (double) inc * ainc; count <= dmax + 0.000001;
       count += (ainc / 2.0)) {

    iflag ^= 1;
    if (dmin-0.000001 > count)
      continue;
    
    x = (count - dmin) / delt * rcos;
    y = (count - dmin) / delt * rsin;
    
    plot(xorg + x, yorg + y, 0);
    xx = -1.0 * sleng * rsin;
    yy = sleng * rcos;
    plot(xorg + x + xx, yorg + y + yy, 2);
    
    if (iflag == 0)
      continue;
    
    /* Scale Value */
    xx = -1.0 * vpos * rsin;
    yy = vpos * rcos;
    
    if (iformat == 2) {
      val = (long) count;
      sprintf(cval, "%ld", val);
    } else if (iformat == 1) {
      if (-0.00001 < count && count < 0.00001) {
	strcpy(cval, "0.0");
      } else {
	sprintf( cval, "%.4f0", count );
	for ( buffer=cval; *buffer != '\0'; buffer++ );
	if ( *buffer == '\0' ) buffer--;
	for ( ; buffer != cval && *buffer == '0'; buffer-- );
	if ( buffer != cval && *buffer == '.' ) {
	  *(buffer+2) = '\0';
	} else {
	  if ( buffer != cval && *buffer != '0')
	    *(buffer+1) = '\0';
	}
      }
    }
    if (iformat == 1 || iformat == 2)
      glabel(xorg + x + xx, yorg + y + yy, cval, size, theta, 2);
    
  } /* for */
  
  /* Title */
  
  x = aleng / 2.0 * rcos - tpos * rsin;
  y = aleng / 2.0 * rsin + tpos * rcos;
  
  glabel(xorg + x, yorg + y, ctitle, size, theta, 2);
  
  
  /* 10 ^ pval  */
  if (pval != 0.0) {
    x = aleng * rcos - tpos * rsin;
    y = aleng * rsin + tpos * rcos;
    glabel(xorg + x, yorg + y, "* 10", size, theta, 1);
    x = -1.0 * size * 2.0 / 3.0 * rsin;
    y = size * 2.0 / 3.0 * rcos;
    val = (long) pval;
    xorg = mgraph.xpre - mgraph.xorg;
    yorg = mgraph.ypre - mgraph.yorg;
    sprintf(cval, "%ld", val);
    glabel(xorg + x, yorg + y, cval, size * 0.7, theta, 0);
  }

  GpmSet_dash_width_dmode((int)mpen.itype, (int)mpen.isize, (int)mpen.imode );
}



/*********************************************************
 *                                                        *
 *        gaxisl                                          *
 *                                                        *
 *********************************************************/
void
gaxisl(x, y, aleng, theta, dmin, dmax, iformat,
       imode, ctitle, size, igrid, gleng)
    double x, y, aleng, dmin, dmax, size, gleng;
    double theta;
    int   iformat, imode, igrid;
    char  *ctitle;
{
  double  delt, count, count2, point, xorg, yorg, xx, yy;
  double  sleng, rcos, rsin, rad, vpos, tpos;
  double  base, dstart, dend;
  int     val;
  char    cval[33];
  
  xorg = x;
  yorg = y;
  
  GpmSet_dash_width_dmode(0, (int)mpen.isize, (int)mpen.imode);
  GpmSet_color((int)mpen.icolor, -1 );
  
  rad = theta;
  theta = theta * 180.0 / M_PI;
  rcos = (double) cos((double) rad);
  rsin = (double) sin((double) rad);
  
  x = aleng * rcos;
  y = aleng * rsin;
  plot(xorg, yorg, 0);
  plot(xorg + x, yorg + y, 2);
  
  /* Symbol Position */
  if (imode == 0) {	/* On The Axis */
    vpos = 2.0;
    tpos = vpos + size * 7.0 / 6.0 + 2.0;
    sleng = 1.5;
  } else {		/* Under The Axis */
    vpos = -2.0 - size * 7.0 / 6.0;
    tpos = vpos - 2.0 - size;
    sleng = -1.5;
  }
  
  /* Axis Draw */
  delt = (dmax - dmin) / aleng;
  
  if (igrid != 0) {
    sleng = gleng * (-(imode == 0) + (imode == 1));

    GpmSet_dash_width_dmode(igrid-1, (int)mpen.isize, (int)mpen.imode);
  }
  for (count = dmin; count <= dmax + 1.0; count += 1.0) {
    base = floor(count);
    if (count == dmin) {
      dstart = 1.0;
      /*
	dstart = floor(count);
	if (dstart == count)
          dstart = 1.0;
        else
          dstart = fabs(floor((dstart - count) * 10.0));
      */

    } else
      dstart = 1.0;
    if (count == dmax) {
      dend = ceil(count);
      if (dend == count)
	dend = 1.0;
      else
	dend = fabs(floor((dend - count) * 10.0));
    } else
      dend = 9.0;

    for (count2 = dstart; count2 <= dend; count2 += 1.0) {
      point  = log10(pow(10.0, base) * count2);
      
      x = (point - dmin) / delt * rcos;
      y = (point - dmin) / delt * rsin;
      if (x > aleng || y > aleng)
	break;
      
      if ((point - dmin) > -0.00001) {
	plot(xorg + x, yorg + y, 0);
	xx = -1.0 * sleng * rsin;
	yy = sleng * rcos;
	plot(xorg + x + xx, yorg + y + yy, 2);
      } else {
	continue;
      }

      if (count2 != 1.0)
	continue;
      
      /* Scale Value */
      if (iformat != 1)
	continue;
      xx = -1.0 * vpos * rsin;
      yy = vpos * rcos;
      strcpy(cval, "10");
      glabel(xorg + x + xx, yorg + y + yy, cval, size, theta, 2);

      xx = mgraph.xpre - mgraph.xorg - 2.0 * size / 3.0 * rsin;
      yy = mgraph.ypre - mgraph.yorg + 2.0 * size / 3.0 * rcos;

      val = (int) base;
      sprintf(cval, "%d", val);
      glabel( xx, yy, cval, size * 0.5, theta, 0);
    }
  }
  
  /* Title */
  x = aleng * 0.5 * rcos - tpos * rsin;
  y = aleng * 0.5 * rsin + tpos * rcos;
  glabel(xorg + x, yorg + y, ctitle, size, theta, 2);
  
  GpmSet_dash_width_dmode((int)mpen.itype, (int)mpen.isize, (int)mpen.imode);
}
