/**********************************************************
 *          GPM-X   Subroutine Package  NO.4              *
 *             Parameter Setting Routines                 *
 *                                                        *
 *        gcsize()  gfactor() gfsize() glimit()           *
 *        gnewpen() gorigin() gpen()  gscale()            *
 **********************************************************
 *                  Coded By  T.Kobayashi                 *
 *                            11/24/89                    *
 *********************************************************/
#include "SL_macro.h"
#include "SL_cmd.h"
#define  GPM_LIB
#include "GPMdef.h"
#include "GPMwin.h"

/*********************************************************
 *                                                        *
 *        gcsize                                          *
 *                                                        *
 *********************************************************/

void
gcsize( size )
    double size;
{
  if (size > 0.0)
    msymbol.height = size;
}


/*********************************************************
 *                                                        *
 *        gfactor                                         *
 *                                                        *
 *********************************************************/
void
gfactor( factor )
    double factor;
{
  if (factor > 0.0)
    mgraph.factor = factor;
}



/*********************************************************
 *                                                        *
 *        gfsize                                          *
 *                                                        *
 *********************************************************/
void
gfsize( x, y )
    double x, y;
{
  if ( x > 0.0 && y > 0.0 ) {
    mgraph.xaxis = x;
    mgraph.yaxis = y;
  }
}


/*********************************************************
 *                                                        *
 *        glimit                                          *
 *                                                        *
 *********************************************************/
void
glimit( xmin, ymin, xmax, ymax )
    double xmin, ymin, xmax, ymax;
{
  if (xmin == 0.0 && xmax == 0.0 && ymin == 0.0 && ymax == 0.0) {

    mgraph.xmin = 0.0;
    mgraph.ymin = 0.0;
    mgraph.xmax = mdev.xleng;
    mgraph.ymax = mdev.yleng;

  } else {

    xmin += mgraph.xorg;
    xmax += mgraph.xorg;
    ymin += mgraph.yorg;
    ymax += mgraph.yorg;
    
    if (xmin >= 0.0 && xmin < xmax)
      mgraph.xmin = xmin;
    if (xmax >= 0.0 && xmin > xmax)
      mgraph.xmin = xmax;
    
    if (xmin <= mdev.xleng && xmin > xmax)
      mgraph.xmax = xmin;
    if (xmax <= mdev.xleng && xmin < xmax)
      mgraph.xmax = xmax;
    
    if (ymin >= 0.0 && ymin < ymax)
      mgraph.ymin = ymin;
    if (ymax >= 0.0 && ymin > ymax)
      mgraph.ymin = ymax;
    
    if (ymin <= mdev.yleng && ymin > ymax)
      mgraph.ymax = ymin;
    if (ymax <= mdev.yleng && ymin < ymax)
      mgraph.ymax = ymax;
  }
  
}



/*********************************************************
 *                                                        *
 *        gnewpen                                         *
 *                                                        *
 *********************************************************/
void
gnewpen(color)
    int color;
{
  int c  = abs(color) % MAX_COLOR;

  mpen.icolor =  (char)  c;
  mpen.rainbow = (char) -1;

  GpmSet_color( c, -1);
}


/*********************************************************
 *                                                        *
 *        gorigin                                         *
 *                                                        *
 *********************************************************/
void
gorigin( x, y )
    double x, y;
{
  if (x >= 0.0 && y >= 0.0 && x < mdev.xleng && y < mdev.yleng) {
    mgraph.xorg = x;
    mgraph.yorg = y;
    mgraph.xpre = mgraph.xorg;
    mgraph.ypre = mgraph.yorg;
  }
}



/*********************************************************
 *                                                        *
 *        gpen                                            *
 *                                                        *
 *********************************************************/
void
gpen( ip_size, ip_type, ip_mode )
     int ip_size, ip_type, ip_mode;
{
  static int imode, itype, isize;

  if (ip_size >= 0)
    mpen.isize = ip_size;

  if (ip_type >= 0 && ip_type <= 7)
    mpen.itype = ip_type;

  if (ip_mode >= 0 && ip_mode <= 2)
    mpen.imode = ip_mode;

  itype  = (int)mpen.itype;
  isize  = (int)mpen.isize;
  imode  = (int)mpen.imode;

  GpmSet_dash_width_dmode(itype, isize, imode);
}


/*********************************************************
 *                                                        *
 *        gscale                                          *
 *                                                        *
 *********************************************************/
void
gscale(xmin, ymin, xmax, ymax)
    double xmin, ymin, xmax, ymax;
{
  if (xmin < xmax) {
    mscale.xdat_min = xmin;
    mscale.xdat_max = xmax;
  } else {
    mscale.xdat_min = xmax;
    mscale.xdat_max = xmin;
  }
  
  if (ymin < ymax) {
    mscale.ydat_min = ymin;
    mscale.ydat_max = ymax;
  } else {
    mscale.ydat_min = ymax;
    mscale.ydat_max = ymin;
  }
}



/*********************************************************
 *                                                        *
 *        grainbow                                        *
 *                                                        *
 *********************************************************/

void
grainbow(level)
    double  level;	/* 0.0 <= level <= 1.0 */
{
  int n;
  int div     = RAINBOW_DIVNUM;
  int basecol = RAINBOW_BASECOL;
  
  if ((level >= 0.0) && (level <= 1.0)) {
    n = (int) (level*(double)(div * basecol));
  } else
    n = (level < 0.0) ? 0 : div*basecol;
  
  mpen.icolor =  (char) -1;
  mpen.rainbow = (char)  n;

  GpmSet_color(-1, n);
}

