/**********************************************************
 *                                                        *
 *          GPM-X   Subroutine Package  NO.5              *
 *                                                        *
 *             plot(), symbol(), csymbol()                *
 *                                                        *
 **********************************************************
 *                                                        *
 *                  Coded By  T.Kobayashi                 *
 *                                                        *
 *                            11/24/89                    *
 *                                                        *
 *********************************************************/
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#define  GPM_LIB
#include "GPMdef.h"
#include "GPMwin.h"
#include "GPMfont.h"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#define PLOT_STACK_MAX 100
#define DRAW_MODE CoordModeOrigin

static void plot_symbol _ANSI_ARGS_((double x, double y, double rw, double rh,
			double rcos, double rsin, int *SymBuf ));
static int  symbol _ANSI_ARGS_((double x, double y, double rcos, double rsin));
static void xy_sub _ANSI_ARGS_((double x, double y,
				int iix, int iiy, int *ix, int *iy,
				double rw, double rh, double rcos, double rsin ));

/**********************************************************
 *                                                        *
 *        plot                                            *
 *                                                        *
 *********************************************************/
void
plot(x, y, ipen_mode )
     double x, y;
     int   ipen_mode;
{
  static XPoint point_stack[PLOT_STACK_MAX];
  static int    n = 0;
  static char   before_level = -1;
  static char   before_col = -1;

  static double x1, y1, x2, y2;
  int          ix1, iy1, ix2, iy2;
  int          flagx1, flagy1, flagx2, flagy2;

  if (ipen_mode == 0) {
    mgraph.xpre = x;
    mgraph.ypre = y;
    mgraph.cline = 0;
  } else {
    flagx1 = 0;
    flagy1 = 0;
    flagx2 = 0;
    flagy2 = 0;
    x1 = mgraph.xpre  + mgraph.xorg;
    y1 = mgraph.ypre  + mgraph.yorg;
    x2 = x            + mgraph.xorg;
    y2 = y            + mgraph.yorg;

    if (x1 > mgraph.xmax) {
      y1 = trans_func(x1, y1, x2, y2, mgraph.xmax);
      x1 = mgraph.xmax;
      flagx1 = 1;
    } else if (x1 < mgraph.xmin) {
      y1 = trans_func(x1, y1, x2, y2, mgraph.xmin);
      x1 = mgraph.xmin;
      flagx1 = -1;
    }
    if (y1 > mgraph.ymax) {
      x1 = trans_func(y1, x1, y2, x2, mgraph.ymax);
      y1 = mgraph.ymax;
      flagy1 = 1;
    } else if (y1 < mgraph.ymin) {
      x1 = trans_func(y1, x1, y2, x2, mgraph.ymin);
      y1 = mgraph.ymin;
      flagy1 = -1;
    }
    if (x2 > mgraph.xmax) {
      y2 = trans_func(x1, y1, x2, y2, mgraph.xmax);
      x2 = mgraph.xmax;
      flagx2 = 1;
    } else if (x2 < mgraph.xmin) {
      y2 = trans_func(x1, y1, x2, y2, mgraph.xmin);
      x2 = mgraph.xmin;
      flagx2 = -1;
    }
    if (y2 > mgraph.ymax) {
      x2 = trans_func(y1, x1, y2, x2, mgraph.ymax);
      y2 = mgraph.ymax;
      flagy2 = 1;
    } else if (y2 < mgraph.ymin) {
      x2 = trans_func(y1, x1, y2, x2, mgraph.ymin);
      y2 = mgraph.ymin;
      flagy2 = -1;
    }

    if ( flagx1 * flagx2 <= 0  && flagy1 * flagy2 <= 0 ) {

      if ( flagx2 != 0 || flagy2 != 0 ) ipen_mode = 2;
      if ( flagx1 != 0 || flagy1 != 0 ) mgraph.cline = 0;

      ix2 =               (int) (x2 * mgraph.factor * mwin.ffx + 0.5);
      iy2 = mwin.iyleng - (int) (y2 * mgraph.factor * mwin.ffy + 0.5);

      if (!mgraph.cline) {
	ix1 =               (int) (x1 * mgraph.factor * mwin.ffx + 0.5);
	iy1 = mwin.iyleng - (int) (y1 * mgraph.factor * mwin.ffy + 0.5);
	point_stack[0].x = ix1;
	point_stack[0].y = iy1;
	n = 1;
      }

      x1 -= mgraph.xorg;
      y1 -= mgraph.yorg;
      x2 -= mgraph.xorg;
      y2 -= mgraph.yorg;

      if (!mgraph.cline) 
	writeplot(x1, y1, 0);

      if (( fabs( x1 - x2 ) > 0.0001 ) || ( fabs( y1 - y2 ) > 0.0001 ) ||
	  ( ipen_mode >= 2 ) ) {
        writeplot(x2, y2, ipen_mode);
      }

      if ( n > 0 &&
	  (point_stack[n-1].x != ix2 || point_stack[n-1].y != iy2 )) { 
	point_stack[n].x = ix2;
	point_stack[n].y = iy2;
	n++;
      }
      mgraph.cline = 1;

    } 
    else {
      mgraph.cline = 0;
    }
  }

  if (ipen_mode > 0) {
    mgraph.xpre = x;
    mgraph.ypre = y;
  }

  if ( n >= PLOT_STACK_MAX ||
       (before_col != mpen.icolor || before_level != mpen.rainbow ||
	mgraph.cline == 0 || ipen_mode != 1 )) {
    if ( n == 1 ) {
      if (gpm_display != NULL && gpm_window != 0){
	XDrawPoints( gpm_display, gpm_window, gpm_gc, point_stack,
		     n, DRAW_MODE );
	XDrawPoints( gpm_display, gpm_pixmap, gpm_gc, point_stack,
		     n, DRAW_MODE );
      }
    } else {
      if (gpm_display != NULL && gpm_window != 0) {
	if ( ipen_mode != 3 ){
	  XDrawLines( gpm_display, gpm_window, gpm_gc, point_stack,
		      n, DRAW_MODE );
	  XDrawLines( gpm_display, gpm_pixmap, gpm_gc, point_stack,
		      n, DRAW_MODE );
	}else{
	  XFillPolygon( gpm_display, gpm_window, gpm_gc, point_stack, n,
			Complex, CoordModeOrigin );
	  XFillPolygon( gpm_display, gpm_pixmap, gpm_gc, point_stack, n,
			Complex, CoordModeOrigin );
        }
      }
    }
    if ( ipen_mode < 0 && n > 1)
      n--;
    point_stack[0].x = point_stack[n-1].x;
    point_stack[0].y = point_stack[n-1].y;
    n = 1;
  }
  before_col   = mpen.icolor;
  before_level = mpen.rainbow;
}


/**********************************************************
 *                                                        *
 *        Box                                             *
 *                                                        *
 *********************************************************/

void
box( x1, y1, x2, y2, mode, level )
     double x1, y1, x2, y2, level;
     int   mode;
{
  int   ix1, iy1, ix2, iy2;
  
  x1 = mgraph.xorg + x1;
  y1 = mgraph.yorg + y1;
  x2 = mgraph.xorg + x2;
  y2 = mgraph.yorg + y2;
  
  mgraph.xpre = x2;
  mgraph.ypre = y2;
  
  /* Frame Over Check */
  if ((x1 <= mgraph.xmax || x2 <= mgraph.xmax) &&
      (y1 <= mgraph.ymax || y2 <= mgraph.ymax) &&
      (x1 >= mgraph.xmin || x2 >= mgraph.xmin) &&
      (y1 >= mgraph.ymin || y2 >= mgraph.ymin)) {

    if (x1 > mgraph.xmax) x1 = mgraph.xmax;
    if (y1 > mgraph.ymax) y1 = mgraph.ymax;
    if (x2 > mgraph.xmax) x2 = mgraph.xmax;
    if (y2 > mgraph.ymax) y2 = mgraph.ymax;
    if (x1 < mgraph.xmin) x1 = mgraph.xmin;
    if (y1 < mgraph.ymin) y1 = mgraph.ymin;
    if (x2 < mgraph.xmin) x2 = mgraph.xmin;
    if (y2 < mgraph.ymin) y2 = mgraph.ymin;

    writebox(x1-mgraph.xorg, y1-mgraph.yorg,
	     x2-mgraph.xorg, y2-mgraph.yorg, mode, level);
  
    /* following part was modified for MAP by M.Shirakawa */

    ix1 =               (int)(x1 * mgraph.factor * mwin.ffx + 0.51);
    iy1 = mwin.iyleng - (int)(y1 * mgraph.factor * mwin.ffy + 0.49);
    ix2 =               (int)(x2 * mgraph.factor * mwin.ffx + 0.51);
    iy2 = mwin.iyleng - (int)(y2 * mgraph.factor * mwin.ffy + 0.51);
      
    if (gpm_display != NULL && gpm_window != 0)
      switch (mode) {
      case 1:			/* Box Draw */
	XDrawRectangle(gpm_display, gpm_window, gpm_gc,
		       ix1, iy2, ix2 - ix1, iy1 - iy2);
	XDrawRectangle(gpm_display, gpm_pixmap, gpm_gc,
		       ix1, iy2, ix2 - ix1, iy1 - iy2);
	break;
      case 2:			/* Fill Box Draw */
      case 3:
      default:
	XFillRectangle(gpm_display, gpm_window, gpm_gc,
		       ix1, iy2, ix2 - ix1, iy1 - iy2);
	XFillRectangle(gpm_display, gpm_pixmap, gpm_gc,
		       ix1, iy2, ix2 - ix1, iy1 - iy2);
	break;
      }
  }
}

static int
symbol( x, y, rcos, rsin )
     double x, y, rcos, rsin;
{
  double     rh, rw;
  double     fontwidth;
  int       ichar;

  /* Charactor Check */
  ichar = (int) msymbol.cdata;
  if (ichar < 0x20)		/* if charactor code less than 0x20, return */
    return 1;
  ichar -= 0x20;
  
  fontwidth = getfontwidth(msymbol.cdata, msymbol.height, msymbol.font);
  
  mgraph.xpre = x + fontwidth * rcos;
  mgraph.ypre = y + fontwidth * rsin;
  
  if (gpm_display == NULL || gpm_window == 0)
    return;

  rh = msymbol.height / FONT_RANGE;
  rw = fontwidth      / FONT_RANGE;

  plot_symbol ( x, y, rw, rh, rcos, rsin, GPMFont[ichar] );
  return 0;
}

/*********************************************************
 *        label                                           *
 *********************************************************/

void
label( x, y, ichar, height, theta, imode )
     double x, y, height;
     char  *ichar;
     double theta;
     int   imode;
{
  int     i, ilen;
  double   off, rad, rcos, rsin;
  
  GpmSet_dash_width_dmode(0, 0, (int)mpen.imode);

  writelabel(x, y, ichar, height, theta, imode);
  
  ilen = strlen(ichar);
  
  msymbol.height = height;
  msymbol.theta  = theta;
  
  msymbol.wph = 1.0;
  height *= msymbol.wph;
  
  switch (imode) {
  case 1:			/* Right */
    off = getstrwidth(ichar, height, msymbol.font);
    break;
  case 2:			/* Centering */
    off = getstrwidth(ichar, height, msymbol.font)*0.5;
    break;
  case 0:			/* Left */
  default:
    off = 0.0;
    break;
  }
  
  /* Frexible Angle */
  rad  = theta * M_PI / 180.0;
  rcos = (double)cos((double)rad);
  rsin = (double)sin((double)rad);
  x += mgraph.xorg - off * rcos;
  y += mgraph.yorg - off * rsin;
  
  for (i = 0; i < ilen; i++) {
    msymbol.cdata = ichar[i];
    symbol(x, y, rcos, rsin );
    x = mgraph.xpre;
    y = mgraph.ypre;
  }

  GpmSet_dash_width_dmode((int)mpen.itype, (int)mpen.isize, (int)mpen.imode);
}

/************************************************************
 *  roll()                                                   *
 ************************************************************/

void
roll()
{
  writeroll();
}


/*********************************************************
 *                                                       *
 *        csymbol                                        *
 *                                                       *
 ********************************************************/
int
csymbol( x, y )
     double x, y;
{
  int      ichar;
  double     x1, y1, rw, rh, rad, rcos, rsin;
  
  GpmSet_dash_width_dmode(0, (int)mpen.isize, (int)mpen.imode);

  x1 = mgraph.xorg + x;
  y1 = mgraph.yorg + y;

  if (( x1 <= mgraph.xmax ) && ( y1 <= mgraph.ymax ) &&
      ( x1 >= mgraph.xmin ) && ( y1 >= mgraph.ymin )) {
    
    /* Charactor Check */
    ichar = (int) msymbol.cdata;
    if (ichar >= MAX_SYMBOL_NUM )
      return 1;			/* if symbol number is greater than 0x1f, return */
    writecsymbol( x, y );

    if (gpm_display != NULL && gpm_window != 0){
      rad  = (double) msymbol.theta / 180.0 * M_PI;
      rcos = (double) cos((double) rad);
      rsin = (double) sin((double) rad);
      rw = rh = msymbol.height / SYMBOL_RANGE;
      plot_symbol ( x1, y1, rw, rh, rcos, rsin, GPMsymbol[ichar] );
    }
  }

  GpmSet_dash_width_dmode((int)mpen.itype, (int)mpen.isize, (int)mpen.imode);
  return 0;
}  


#define MAX_FILLS 50
static void
plot_symbol( x, y, rw, rh, rcos, rsin, SymBuf )
     double x, y, rw, rh, rcos, rsin;
     int   *SymBuf;
{

  double     fx, fy;
  int       icolor;
  int       i, j, k;
  int       ixpre = 0, iypre = 0, ixx, iyy, lx, ly, d1, d2;
  XPoint    fills[MAX_FILLS];

  icolor = (int)mpen.icolor;
  GpmSet_color(icolor,-1);

  i = 0;
  while(( j = SymBuf[i++]) != EOD  ) {
    lx = (int) SymBuf[i++];
    ly = (int) SymBuf[i++];
    xy_sub(x, y, lx, ly, &ixx, &iyy, rw, rh, rcos, rsin );

    switch( j ) {
    case PLT:
      XDrawLine( gpm_display, gpm_window, gpm_gc, ixpre, iypre,
		ixx, iyy );
      XDrawLine( gpm_display, gpm_pixmap, gpm_gc, ixpre, iypre,
		ixx, iyy );
    case MOV:
      ixpre = ixx;
      iypre = iyy;
      break;
    case POL: case FIL: case FLB:
      fills[0].x = ixx;
      fills[0].y = iyy;
      k = 1;
      do { 
	while ( SymBuf[i] != EPL && k < MAX_FILLS ) {
	  lx = (int) SymBuf[i++];
	  ly = (int) SymBuf[i++];
	  xy_sub(x, y, lx, ly, &ixx, &iyy, rw, rh, rcos, rsin );
	  fills[k].x = ixx;
	  fills[k].y = iyy;
	  k++;
	}
	if ( k > 2 ) {
	  switch( j ) {
	  case FLB:
            GpmSet_color(0, -1);
	  case FIL:
	    XFillPolygon( gpm_display, gpm_window, gpm_gc,
			 fills, k, Complex, CoordModeOrigin );
	    XFillPolygon( gpm_display, gpm_pixmap, gpm_gc,
			 fills, k, Complex, CoordModeOrigin );
	  case POL:
	    XDrawLines( gpm_display, gpm_window, gpm_gc,
		       fills, k, CoordModeOrigin );
	    XDrawLines( gpm_display, gpm_pixmap, gpm_gc,
		       fills, k, CoordModeOrigin );
            if (j==FLB)
	      GpmSet_color(icolor, -1);
	    break;
	  }
	  fills[0].x = fills[k-1].x;
	  fills[0].y = fills[k-1].y;
	  k = 1;
	}
      } while ( SymBuf[i] != EPL );
      i++;
      break;
    case CIR: case FCR: case FCB:
      fx = mwin.ffx * mgraph.factor;
      fy = mwin.ffy * mgraph.factor;
      d1 = (int)( fx * rw * (double)SymBuf[i++]);
      d2 = (int)( fy * rh * (double)SymBuf[i++]);
      switch ( j ) {
      case CIR:
	XDrawArc( gpm_display, gpm_window, gpm_gc, ixx-d1, iyy-d2,
		 d1*2, d2*2, 0, 23040 );
	XDrawArc( gpm_display, gpm_pixmap, gpm_gc, ixx-d1, iyy-d2,
		 d1*2, d2*2, 0, 23040 );
	break;
      case FCB:
        GpmSet_color(0, -1);
      case FCR:
	XSetArcMode( gpm_display, gpm_gc, ArcPieSlice );
	XFillArc( gpm_display, gpm_window, gpm_gc, ixx-d1, iyy-d2,
		 d1*2, d2*2, 0, 23040 );
	XFillArc( gpm_display, gpm_pixmap, gpm_gc, ixx-d1, iyy-d2,
		 d1*2, d2*2, 0, 23040 );
        if (j==FCB)
	  GpmSet_color(icolor, -1);
	break;
      }
      break;
    }
  }
}

static void
xy_sub( x, y, iix, iiy, ix, iy, rw, rh, rcos, rsin )
     double x, y, rcos, rsin, rw, rh;
     int iix, iiy, *ix, *iy;
{
  double rx, ry, xx, yy;

  rx = (double)iix;
  ry = (double)iiy;

  xx = (rw * rx * rcos - rh * ry * rsin) + x;
  yy = (rw * rx * rsin + rh * ry * rcos) + y;

  *ix =               (int) (xx * mwin.ffx * mgraph.factor + 0.5);
  *iy = mwin.iyleng - (int) (yy * mwin.ffy * mgraph.factor + 0.5);

}

void
GpmSet_dash_width_dmode(itype,isize,imode)
     int itype, isize, imode;
{
  static char dot1[] = { 4, 4 };
  static char dot2[] = { 2, 2, 6, 2 };
  static char dot3[] = { 2, 2, 2, 2, 6, 2 };
  static char dot4[] = { 2, 2 };
  static char dot5[] = { 1, 3 };
  static char dot6[] = { 1, 7 };
  static char dot7[] = { 1, 1 };
  static char *dashtbl[] = { dot1, dot2, dot3, dot4, dot5, dot6, dot7 };
  static int   dashlen[] = { 2, 4, 6, 2, 2, 2, 2};

  if (gpm_display == NULL || gpm_window == 0)
    return;

  if ( itype > 0 && itype < 8 ) 
    XSetDashes( gpm_display, gpm_gc, 0, dashtbl[itype-1], dashlen[itype-1] );

  if (isize >= 0)
    isize *= 2;

  XSetLineAttributes( gpm_display, gpm_gc, isize,
		     ( (itype==0) ? LineSolid : LineDoubleDash ),
		     CapButt, JoinMiter);

  switch (imode) {		/* from gpmx4.c gnewpen() */
  case 1:
    XSetFunction(gpm_display, gpm_gc, GXxor);
    break;
  case 2:
    XSetFunction(gpm_display, gpm_gc, GXclear);
    break;
  case 0:
  default:
    XSetFunction(gpm_display, gpm_gc, GXcopy);
    break;
  }
}

void
GpmSet_color( color, rainbow)
     int   color;
     int   rainbow;
{
  unsigned long c;
  static   int  RainbowMax = RAINBOW_DIVNUM * RAINBOW_BASECOL+2;
  unsigned long white;
  unsigned long black;
  double level;

  if (gpm_display == NULL || gpm_window == 0)
    return;

  white      = WhitePixel (gpm_display, gpm_screen);
  black      = BlackPixel (gpm_display, gpm_screen);

  if ( gpm_depth > 1 ) {
    if ( color < 0 || rainbow >= 0) {
      if ( rainbow >= 0 && rainbow < RainbowMax ) {
	if ( gpm_depth >= 8 ) {
	  c = gpm_rainbow[rainbow];
	} else {
	  rainbow /= (RAINBOW_DIVNUM);
	  c = gpm_rainbow[rainbow];
	}
      } else {
	c = ( rainbow < 0 ) ? gpm_rainbow[0] : gpm_rainbow[RainbowMax-1];
      }
    } else
      c = gpm_color[color%MAX_COLOR];

    XSetForeground(gpm_display, gpm_gc, c);
#ifdef WHITE_BGCOLOR
    XSetBackground (gpm_display, gpm_gc, white);
#else
    XSetBackground (gpm_display, gpm_gc, black);
#endif /* WHITE_BGCOLOR */
    XSetFillStyle (gpm_display, gpm_gc, FillSolid);
  } else {
    if ( color < 0 ) {
      level = (double)rainbow/ (double)RainbowMax;
      set_tile_pattern(gpm_display, gpm_screen, gpm_window, gpm_gc, level);
    } else {
#ifdef WHITE_BGCOLOR
      XSetForeground(gpm_display, gpm_gc, (color!=0) ? black: white);
      XSetBackground(gpm_display, gpm_gc, white);
#else
      XSetForeground(gpm_display, gpm_gc, (color!=0) ? white: black);
      XSetBackground(gpm_display, gpm_gc, black);
#endif /* WHITE_BGCOLOR */
    }
  }
}
