#define  GPM_LIB

#include <stdio.h>

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"

float **
ldata(bufno, nx, ny, timeaxis, viewpoint)
    int bufno, nx, ny, viewpoint;
    char *timeaxis;
{
  register int i;
  int    dim2, index2[MAX_INDEX], index[2];
  int    siz, ix, iy;
  Buffer *work;
  float	 **buf;
  
  if((work = ReadBuffer(bufno, &dim2, index2)) == NULL) 
    return NULL;
  siz = IndexSize(dim2, index2);
  
  buf = (float **)_malloc2d(nx, ny, sizeof(float));

  if (*timeaxis == 'X' || *timeaxis == 'x' ) {
    for( i = 0; i < siz; i++) {
      rIndex(i, index, dim2, index2);
      ix = index[0];
      iy = index[1];
      if(viewpoint < 0)
	iy = ny - iy - 1;
      buf[ix][iy] =  (float)work[i];
    }
  } else {
    for( i = 0; i < siz; i++) {
      rIndex(i, index, dim2, index2);
      ix = index[1];
      iy = index[0];
      if(viewpoint < 0)
	iy = ny - iy - 1;
      buf[ix][iy] =  (float)work[i];
    }
  }
  FreeBuffer(work);
  return  buf;
}


void
thinout(buf, nx, ny, xdiv, ydiv)
    float **buf;
    int   *nx, *ny, xdiv, ydiv;
{
  register int	i, j;
  /* mabiki */
  *nx = (*nx-1) / xdiv + 1;
  *ny = (*ny-1) / ydiv + 1;
  for(i = 0; i < *nx; i++) { 
    for(j = 0; j < *ny; j++) {
      buf[i][j] = buf[i*xdiv][j*ydiv];
    }
  }
}

char **
_malloc2d(nx,ny,siz)
    int nx, ny, siz;
{
  register int	i;
  char	**f = (char **) malloc(sizeof(char *) * nx);
  for (i = 0; i < nx; i++) 
    f[i] = (char *) malloc((unsigned)(siz * ny));
  return f;
}
