/*********************************************************
 *                                                        *
 *        PostScript Printer Driver Routine               *
 *                                                        *
 **********************************************************
 *                  Coded By  Y.Ohmi                      *
 *                             5/31/90                    *
 *********************************************************/

#define  GPM_LIB

#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"

#define MtoI (72.0/25.4)	/* convert 1 m to 1/72 inchs */
#define CSSIZE	17		/* number of center symbols */
#define PS_STACK_MAX 100

/* GPM_INITFILE_PATH and
   GPM_TRAYSET_PATH are obsolete. */
#define GPM_INITFILE "GPMps"
#define GPM_TRAYSET  "TrayPs"

int     gpm_colorps_mode = 0;
Devpara gpm_dev;

static unsigned int times = 0;
static unsigned int maxpath = 0;

/***************************
 *    Global variables     *
 ***************************/

/* for LN */
int             pssize, pstype, psmode = -1;

/* for rainbow level */
int             ps_rainbow_flag = 0;

/* for char */
int             psfont, psflag;
double           psheight;

/* for factor */
double           psfactor = 1.0;

/* for status */
int             ginitflag = 0;


/***************************
 *        ps_origin         *
 ***************************/

void
ps_origin(x, y)
     double x, y;
{
  gpm_dev.xorg = x;
  gpm_dev.yorg = y;
}

/***************************
 *        ps_color          *
 ***************************/

void
ps_color(color)
    int color;
{
  static double  gray[16] = {1.0, 0.8, 0.6, 0.3, 0.0, 0.0, 0.0, 0.0,
			     0.3, 0.6, 0.8, 1.0, 1.0, 1.0, 1.0, 1.0};
  static double   red[8]  = {1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0};
  static double green[8]  = {1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0};
  static double  blue[8]  = {1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0};
  
  if (color != gpm_dev.color || gpm_dev.level != -1.0 ) {
    
    if (psmode == 1) {
      printf("ST\n");
      times = 0; maxpath = 0; psmode = -1;
    }

    if ( color < 0 ) return;

    gpm_dev.color = color;
    gpm_dev.level = -1.0;

    if ( gpm_colorps_mode && color < 8 ) {
      printf("%.1f %.1f %.1f setrgbcolor ",
	     red[color], green[color], blue[color]);
    } else {
      color = color % 16;
      printf("%.1f setgray ", gray[color]);
    }
  }
}


static void
ps_set_rainbow_color( level, r, g, b )
     double level, *r, *g, *b;
{
  if ( level >= 0.0 && level < 0.2 ) {
    *r = 0.0;
    *g = 0.0;
    *b = level*5.0;
  } else if ( level < 0.4 ) {
    *r = 0.0;
    *g = (level-0.2)*5.0; 
    *b = 1.0;
  } else if ( level < 0.6 ) {
    *r = 0.0;
    *g = 1.0;
    *b = (0.6-level)*5.0;
  } else if ( level < 0.8 ) {
    *r = (level-0.6)*5.0; 
    *g = 1.0;
    *b = 0.0;
  } else if ( level <= 1.0 ) {
    *r = 1.0;
    *g = (1.0-level)*5.0; 
    *b = 0.0;
  }
}

/***************************
 *        ps_rainbow        *
 ***************************/

void
ps_rainbow(level)
    double level;
{
  if ( fabs( (double) gpm_dev.level - (double) level ) > 0.001
      || gpm_dev.color != -1 ) {
    
    if (psmode == 1) {
      printf("ST\n" );
      times = 0; maxpath = 0; psmode = -1;
    }

    gpm_dev.level = (double) level;
    gpm_dev.color = -1;

    if ( gpm_colorps_mode != 0 ) {
      double	 r = 0.0, g = 0.0, b = 0.0;
      ps_set_rainbow_color( level, &r, &g, &b );
      printf("%.3f %.3f %.3f setrgbcolor ", r, g, b );
    } else {
      if ( !ps_rainbow_flag )
	level = 1.0 - level;
      printf("%.3f setgray ", level);
    }
  }
}

/***************************
 *        ps_plot           *
 ***************************/

void
ps_plot(x, y, mode)
    double x, y;
    int   mode;
    
{
  static double x1, y1, x0=0.0, y0=0.0;
  
  x1 = x + gpm_dev.xorg;
  y1 = y + gpm_dev.yorg;

  if ( ( psmode == -1 && mode != 0 ) || mode < 0 ) {
    times++; maxpath++; psmode = 0;
    x0 = mgraph.xpre + gpm_dev.xorg;
    y0 = mgraph.ypre + gpm_dev.yorg ;
    printf("%.2f %.2f MV ", x0, y0 );
  } 

  if ( mode >= 0 ) {
    mgraph.xpre = x;
    mgraph.ypre = y;
  }
  switch(mode) {
  case -1: case 1:
    if ( maxpath < PS_STACK_MAX ) {
      if ( fabs( x0 - x1 ) > 0.02  || fabs( y0 - y1 ) > 0.02 )  {
	printf("%.2f %.2f LN ", x1, y1 );
	times   ++; maxpath ++;
	psmode = 1;
      }
      break; /* this line must be this position */
    } 
  case -2: case 2:
    printf("%.2f %.2f LN ST\n", x1, y1 );
    maxpath = 0; times = 0; psmode = -1;
    break;
  case 3:
    printf("%.2f %.2f LN FL\n", x1, y1 );
    maxpath = 0; times = 0; psmode = -1;
    break;
  case 0:
  default:
    printf("%.2f %.2f MV ", x1, y1 );
    times   ++; maxpath ++;
    psmode = 0;
    break;
  }
  if ( (times+1) % 5 == 0 ) { times = 0; puts(""); }

  if ( mode < 0 ) {
    printf("%.2f %.2f MV ", x0, y0 );
    psmode = 0; times ++; maxpath++;
    if ( (times+1) % 5 == 0 ) { times = 0; puts(""); }
  }
}

  
/***************************
 *        ps_factor         *
 ***************************/

void
ps_factor(factor)
    double factor;
    
{
  double f;
  
  if (psmode == 1) {
    printf("ST\n" );
    times = 0; maxpath = 0; psmode = -1;
  }
  if ( fabs( psfactor - factor ) > 0.0001 ) {
    psfactor = factor;
    f = MtoI * factor;
    printf("%f %f scale\n", f, f);
  }
}


/***************************
 *        ps_box           *
 ***************************/

void
ps_box(x1, y1, x2, y2, mode, level, color)
    double x1, y1, x2, y2, level;
    int   mode, color;
    
{
  x1 = gpm_dev.xorg + x1;
  y1 = gpm_dev.yorg + y1;
  x2 = gpm_dev.xorg + x2;
  y2 = gpm_dev.yorg + y2;
  
  mgraph.xpre = x2;
  mgraph.ypre = y2;

  if (psmode == 1) {
    printf("ST\n" );
    times = 0; maxpath = 0; psmode = -1;
  }

  if (mode == 2) {
    if      (level < 0.0) level = 0.0;
    else if (level > 1.0) level = 1.0;

    if (!gpm_colorps_mode && ps_rainbow_flag )
      level = 1.0 - level;
    ps_rainbow(level);
  } else
    ps_color(color);

  printf("%.2f %.2f %.2f %.2f box ", x2 - x1, y2 - y1, x1, y1);

  switch (mode) {
  case 2: case 3:
    printf("FL\n");
    break;
  case 1: default:
    printf("ST\n");
    break;
  }
}


void
ps_lwidth(width)
    int width;
{
  double linewidth;
  
  if ( pssize != width ) {
    pssize = width;

    switch (width) {
    case 1:  linewidth = 1.0; break;
    case 2:  linewidth = 2.0; break;
    case 3:  linewidth = 4.0; break;
    case 4:  linewidth = 6.0; break;
    case 0:
    default: linewidth = 0.5; break;
    }
    if (psmode == 1) {
      printf("ST\n" );
      times = 0; maxpath = 0; psmode = -1;
    }
    printf("%.2f setlinewidth\n", linewidth / MtoI);
  }
}


void
ps_ltype(type)
    int type;
{
  if (pstype != type) {
    if (psmode == 1) {
      printf("ST\n" );
      times = 0; maxpath = 0; psmode = -1;
    }
    pstype = type;

    switch (type) {
    case 1:
      printf(" [2 2]");            break;
    case 2:
      printf(" [1 1 3 1]");        break;
    case 3:
      printf(" [1 1 1 1 3 1]");    break;
    case 4:
      printf(" [1 1]");            break;
    case 5:
      printf(" [0.5 1.5]");        break;
    case 6:
      printf(" [0.5 3.5]");        break;
    case 7:
      printf(" [0.5 0.5]");        break;
    case 0:
    default:
      printf(" []");               break;
    }
    printf(" 0 setdash\n");
  }
}


#define FONT_MAX 12
void
ps_string(x, y, str, height, theta, centermode, font)
    double x, y;
    char  *str;
    double height;
    double theta;
    int   centermode;
    char  font;
{
  char *str2;
  int  parenNumber, i, j;
  char rshowmode[10], nshowmode[10];
  
  /* Table of fonts */
  
  static char    *fontname[3] =
    {"Times", "Helvetica", "Courier"};
  
  static char    *fonttype[3][4] = {
    {"Roman", "Italic", "Bold", "BoldItalic"},
    {"", "Oblique", "Bold", "BoldOblique"},
    {"", "Oblique", "Bold", "BoldOblique"}};
  
  if ( strlen(str) > 0 && height > 0.01 ) {

    msymbol.font = (char) font;
    
    if (psheight != height || psfont != msymbol.font) {
      /* name of font, size of font */
      msymbol.height = height;
      if (msymbol.font >= FONT_MAX) {
	msymbol.font = 0;
      }
      if (strlen(fonttype[msymbol.font / 4][msymbol.font % 4]) == 0)
	printf("/%s", fontname[msymbol.font / 4]);
      else
	printf("/%s-%s",
	       fontname[msymbol.font / 4],
	       fonttype[msymbol.font / 4][msymbol.font % 4]);
      
      printf(" findfont\n");
      printf("%.2f scalefont setfont\n", height );
      psfont = msymbol.font;
      psheight = height;
    }
    
    switch (centermode) {
    case 0:			/* Left */
      strcpy(rshowmode, "rshow_l");
      strcpy(nshowmode, "nshow_l");
      break;
    case 1:			/* Right */
      strcpy(rshowmode, "rshow_r");
      strcpy(nshowmode, "nshow_r");
      break;
    case 2:			/* Centering */
      strcpy(rshowmode, "rshow_c");
      strcpy(nshowmode, "nshow_c");
      break;
    }
    
    parenNumber = 0;
    for (i = 0; i < strlen(str); i++) {
      if (*(str + i) == '(' || *(str + i) == ')') {
	parenNumber++;
      }
    }
    
    j = 0;
    str2 = (char *) calloc(strlen(str) + parenNumber + 1, sizeof(char));
    
    for (i = 0; i < strlen(str); i++) {
    
      if (*(str + i) == '(' || *(str + i) == ')') {
      
	*(str2 + j) = '\\';
	j++;
	*(str2 + j) = *(str + i);
	j++;
      } else {
      
	*(str2 + j) = *(str + i);
	j++;
      }
    }
    
    if (!gpm_colorps_mode)
      ps_color(7);

    if ((int)theta != 0) {
      /* rotate */
      printf("(%s) %d %.2f %.2f %s\n", str2, (int)theta,
	     x + gpm_dev.xorg, y + gpm_dev.yorg, rshowmode);
    } else {
      printf("(%s) %.2f %.2f %s\n", str2,
	     x + gpm_dev.xorg, y + gpm_dev.yorg, nshowmode);
    }
    free(str2);
  }
}



/* flag for string output  */
void
ps_flag(sw)
    int sw;
{
  
  psflag = sw;
  
}


/***************************
 *                          *
 *        ps_symbl          *
 *                          *
 ***************************/
void
ps_csymbol(x, y, cdata, height)
    double x, y;
    int   cdata;
    double height;
{
  int i;
  
  if ((i = cdata) >= CSSIZE) {
    i = 0;
  }
  if (psmode == 1) {
    printf("ST\n" );
    times = 0; maxpath = 0; psmode = -1;
  }

  /* draw center symbols */
  printf("%.2f %.2f %.2f csymbol%d\n",
	 x + gpm_dev.xorg, y + gpm_dev.yorg,
	 (height > 0.01) ? height : 0.01, i);
}


/***************************
 *                          *
 *        ps_open           *
 *                          *
 ***************************/
void
ps_open()
{
  /* initialize for global valiables  */
  
  psmode    = -1;
  ginitflag = 0;
  
  ps_ginit();
}


/***************************
 *                          *
 *        ps_close          *
 *                          *
 ***************************/
void
ps_close()
{
  printf("%%%%EOF\n");
}


/***************************
 *                          *
 *        ps_init           *
 *                          *
 ***************************/
void
ps_init()
{
  FILE *defs_fp;
  char buf[ONE_LINE];
  static char fname[FILE_LENGTH];

  strcpy(fname,GPM_INITFILE);
  if ( access(fname, R_OK ) != 0 ) {
#ifdef GPM_INITFILE_PATH
    strcpy(fname, GPM_INITFILE_PATH);
#else
    strcpy(fname, SL_LIB_DIR);
    strcat(fname, "/");
    strcat(fname, GPM_INITFILE);
#endif
  }      

/*  printf("initgraphics\n"); */

  defs_fp = fopen( fname, "r" );
  if ( defs_fp ) {
    while( fgets( buf, ONE_LINE, defs_fp ) != NULL )
      printf( "%s", buf );
    fclose( defs_fp );
  } else {
    fprintf(stderr,"cannot find file : %s\n", fname );
    exit(0);
  }
  printf("\n");
}



/***************************
 *                          *
 *        ps_roll           *
 *                          *
 ***************************/
void
ps_roll()
{
  if (psmode == 1) {
    printf("ST\n");
    psmode = -1;
  }
  printf("showpage\n");
  ginitflag=0;
}

/***************************
 *                          *
 *        ps_end            *
 *                          *
 ***************************/
void
ps_end()
{
}


void
ps_rainbow_mode(mode)
    int mode;
{
  ps_rainbow_flag = mode;
}

void
ps_ginit()
{
  if (psmode == 1) {
    printf("ST\n");
    times = 0; maxpath = 0; psmode = -1;
  }

  psmode = -1;

  gpm_dev.xorg = -1.0;
  gpm_dev.yorg = -1.0;
  gpm_dev.color = -1;
  gpm_dev.level = -1.0;
  
  if ( ginitflag == 0 ) {
    ps_flag(0);
    psfont = -1;
    psheight = 0.;
    pssize = -1;
    pstype = -1;
    psfactor = -1.0;
    printf("ginit\n");
    if (mdev.irotate == 1) {
      if ((int)mdev.number == 0) {
	printf("589 10 translate\n");
      } else {
	printf("723 10 translate\n");
      }
      printf("90 rotate\n\n");
    } else {
      printf("0 4 translate\n");
    }
    ginitflag = 1;
  }
}


void
ps_initAdobe(paperSize, orientation, creator, infilename)
    int paperSize, orientation;
    char *creator, *infilename;
{
  printf("%%!PS-Adobe-2.0\n");
  printf("%%%%Title: %s\n", infilename);
  printf("%%%%Creator: %s\n", creator);
  printf("%%%%Pages: (atend)\n");

  printf("%%%%DocumentPaperSizes: ");
  if ( paperSize == 1 ) printf("B4\n");
  else                  printf("A4\n");

  printf("%%%%Orientation: ");
  if ( orientation == 1 ) printf("Landscape\n");
  else                    printf("Portrait\n");

  printf("%%%%EndComments\n");
}  

/* for tray select function by take */
void
ps_setTray(paperSize, orientation)
    int paperSize, orientation;
{
  FILE *defs_fp;
  char buf[ONE_LINE];
  static char fname[FILE_LENGTH];

  strcpy(fname,GPM_TRAYSET);
  if ( access(fname, R_OK ) != 0 ) {
#ifdef GPM_TRAYSET_PATH
    strcpy(fname, GPM_TRAYSET_PATH);
#else
    strcpy(fname, SL_LIB_DIR);
    strcat(fname, "/");
    strcat(fname, GPM_TRAYSET);
#endif
  }      
  defs_fp = fopen( fname, "r" );
  if ( defs_fp ) {
    printf("initgraphics\n");
    while(fgets( buf, ONE_LINE, defs_fp ) != NULL )
      printf( "%s", buf );
    fclose( defs_fp );

    if ( paperSize == 1 )   printf("@b4\n");
    else                    printf("@a4\n");
    if ( orientation == 1 ) printf("@landscape\n");
  } else {
    fprintf(stderr,"cannot find file : %s\n", fname );
  }
  printf("\n");
}

void
ps_page(pageNumber)
    int pageNumber;
{
  printf("%%%%Page: %d %d\n", pageNumber, pageNumber);
}

void
ps_pages(pageNumber)
    int pageNumber;
{
  printf("%%%%Trailer\n%%%%Pages: %d\n", pageNumber);
}
