/*******************************************************************
 **      File Name : rwgpm.c                                      **
 **                                                               **
 **          System Common Area Read / Write Routine              **
 **                   for GPM Module                              **
 **                                                               **
 **                                      Coded by T.Kobayashi     **
 ******************************************************************/

#define  GPM_LIB
#define  _RW_GPM_
#include <stdio.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#include <fcntl.h>

GpmContext  GpmCont;
Mdev        mdev;
Mgraph      mgraph;
Mpen        mpen;
Mscale      mscale;
Msymbol     msymbol;
Mwin        mwin;


int
regpm()
{
  FILE *spfp;
  char fname[FILE_LENGTH];
  
  strcpy(fname, get_tmpdir());
  strcat(fname, GPM_file);
  
  if (( spfp = fopen( fname, "r" ) ) == NULL ) {
    perror("<<GPM:Error>>  Can't open parameter file");
    return (-1);
  }
  fread( (char *) &GpmCont, sizeof(GpmContext), 1, spfp );
  fclose(spfp);
  return 0;
}


int
wrgpm()
{
  FILE *spfp;
  char fname[FILE_LENGTH];
  
  strcpy(fname, get_tmpdir());
  strcat(fname, GPM_file);
  
  if ( (spfp = fopen(fname, "w") ) == NULL ) {
    perror("<<GPM:Error>>  Can't open parameter file");
    return (-1);
  }
  fwrite( (char *) &GpmCont, sizeof(GpmContext), 1, spfp );
  fclose(spfp);
  return 0;
}


/************************************************
 * for GPM2 ( window parameters of all windows)
 ************************************************/

int
createGpm2()
{
  GpmContext  tmp[MAX_WIN];
  FILE       *spfp;
  char        fname[FILE_LENGTH];
  int i;
  
  strcpy(fname, get_tmpdir());
  strcat(fname, GPM_file2);
  
  if ( (spfp = fopen( fname, "w" )) == NULL ) {
    perror("<<GPM:Error>>  Can't open parameter file");
    return (-1);
  }
  for ( i = 0; i < MAX_WIN; i++ )
    tmp[i] = GpmCont;

  fwrite( (char*)tmp, sizeof(GpmContext), MAX_WIN, spfp );
  fclose( spfp );
  return 0;
}


int
regpm2( win_num )
     int win_num;
{
  GpmContext tmp[MAX_WIN];
  FILE       *spfp;
  char       fname[FILE_LENGTH];
  
  if ( win_num < 0 )
    return -1;
  
  strcpy(fname, get_tmpdir() );
  strcat(fname, GPM_file2);
  
  if ( (spfp = fopen( fname, "r" )) == NULL ) {
    perror("<<GPM:Error>>  Can't open parameter file");
    return (-1);
  }

  fread( (char *)tmp, sizeof(GpmContext), MAX_WIN, spfp );
  fclose(spfp);

  GpmCont = tmp[(int)win_num];
  return 0;
}


int
wrgpm2( win_num )
     int win_num;
{
  FILE  *spfp;
  GpmContext tmp[MAX_WIN];
  char fname[FILE_LENGTH];
  
  if ( win_num < 0 )
    return -1;

  strcpy(fname, get_tmpdir());
  strcat(fname, GPM_file2);
  
  if (( spfp = fopen( fname, "r+" )) == NULL ) {
    perror("<<GPM:Error>>  Can't open parameter file");
    return (-1);
  }

  fread( (char*)tmp, sizeof(GpmContext), MAX_WIN, spfp );
  fseek( spfp, 0L, 0 );

  tmp[(int)win_num] = GpmCont;

  fwrite( (char*)tmp, sizeof(GpmContext), MAX_WIN, spfp );
  fclose(spfp);
  return 0;
}
