/************************************************
*                                               *
*        SET LINE WIDTH                         *
*                                               *
*************************************************
*                                               *
*        LWIDTH  I1, I2                         *
*-----------------------------------------------*
*                                               *
*        I1   : GRAPH LINE WIDTH  ( 1 .. 3 )    *
*                                               *
*        I2   : AXIS & FRAME LINE WIDTH         *
*                                               *
*************************************************
*                                               *
*        T.KOBAYASHI         12/03/88           *
*                                               *
************************************************/
#include <stdio.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"


int
main()
{
  int numer[2], i;
  
  /* LOAD SYSTEM PARAMETER */
  read_syscom();
  regpm();

  numer[0] = (int)GetScalar(0)-1;
  numer[1] = (int)GetScalar(1)-1;
  
  for (i = 0; i <= 1; i++)
    if ( numer[i] < 0 || numer[i] > 4 )
      exit(2);
  
  GpmCont.gLineWidth = numer[0];
  GpmCont.fLineWidth = numer[1];
  
  write_syscom();
  wrgpm();
  return 0;
}
