#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif


/* in interval.c */
extern void store_start_time _ANSI_ARGS_((void));
extern void wait_msec        _ANSI_ARGS_((int waittime));

/* in gpmx1.c */
extern void set_tile_pattern ( /* display, screen, window, gc, level */ );

/* private functions */
static double  norm            _ANSI_ARGS_((double data,
					    double amin, double amax));
static int    draw_box_       _ANSI_ARGS_((int ix, int iy, double size,
					   double hx, double hy, int fillmode,
					   double level ));
static void   creategradation _ANSI_ARGS_((int c));
static void   setMonoCols     _ANSI_ARGS_((int n, double x, int c));
static void   gradation       _ANSI_ARGS_((double level));



/**************************************************************
        MAP GRAPHIC COMMAND  -New Version-
***************************************************************
       map(buf, dir, mode, set, vp)

       buf         : BUFFER
       dir         : DRAWING DIRECTION
       mode        : MAP STYLEE
       set         : TILE SIZE
       vp          : VIEWPOINT
***************************************************************
        T.KOBAYASHI (Buffer Version       ) 90/09/05
        M.Shirakawa (PS Version           ) 92/01/31
        S.Hitomi    (on SATELLITE Language) 92/11/17
        K.Takebe    (Extended Version     ) 94/03/03
**************************************************************/

int
main()
{
  Buffer **data, *indat, *tmp;
  int   wait_time = 500, startp = 0, endp = 0, step = 1, dviflag = 0;
  double a, rmin, rmax, min, max, hx, hy, level, size;
  int   dim, index[MAX_INDEX];
  int   tnum, dnum, viewpoint, flag, dmode, xyset;
  int   nx, ny, subsize, fillmode;
  int   j, k, p1, p2;
  register int i, ix, iy;
  char  *timeaxis, rest_device;
  
  /* LOAD SYSTEM PARAMETER */
  read_syscom();
  regpm();

  indat     = (Buffer*)GetSeries(0,&dim,index);
  timeaxis  =        GetString(1);
  dmode     = (int)  GetScalar(2);
  xyset     = (int)  GetScalar(3);
  viewpoint = ((int) GetScalar(4) > 0) ? 1 : -1;
  
  if (GetArgNum() > 5) {
    wait_time = (int)  GetScalar(5);
    startp    = (int)  GetScalar(6);
    endp      = (int)  GetScalar(7);
    step      = (int)  GetScalar(8);
  }

  /* Load Data */
  if ( indat == NULL || dim < 2 || dim > 3 )
    exit(16); /* dimension mismatch */

  dnum = IndexSize(dim, index);
  tnum = ( dim == 3 ) ? index[0] : 1;
  data = (Buffer**)malloc(tnum*sizeof(Buffer*));
  if ( data == NULL )
    exit(8); /* cannot allocate memory */

  if ( *timeaxis == 'X' || *timeaxis == 'x' ) {
    nx = index[dim-2];
    ny = index[dim-1];
    p1 = ny;
    p2 = 1;
  } else {
    nx = index[dim-1];
    ny = index[dim-2];
    p1 = 1;
    p2 = nx;
  }
  subsize = index[dim-2]*index[dim-1];
  for (tmp = indat, i = 0; i < tnum; i++, tmp += subsize )
    data[i] = tmp;

  if ( dim == 3 ) {
    if ( startp >= tnum ) startp = tnum-1;
    else                  startp = ( startp < 0 ) ? 0 : startp;
    if ( endp >= tnum )   endp   = tnum-1;
    else {
      endp = ( endp <= 0 ) ? tnum : endp;
      endp = ( startp >= endp ) ? startp+1 : endp;
    }
    if ( step <= 0 )      step = 1;
    else                  step = ( step > endp-startp) ? endp-startp : step;
  } else {
    startp = 0;
    endp   = 1;
    step   = 1;
  }
  
  dviflag = checktodvi();
  if ( dviflag == True )
    writegpm();

  rest_device = GpmCont.device;
  if ( dim != 2 )
    GpmCont.device = 0;
  
  if ( GpmCont.xMode == 0 ) {
    GpmCont.xMin = 0.0;
    GpmCont.xMax = (double)(nx-1);
  }

  if ( GpmCont.yMode == 0 ) {
    GpmCont.yMin = 0.0;
    GpmCont.yMax = (double)(ny-1);
  }
  GpmCont.axisType = 0;

  min = indat[0];
  max = indat[0];
  for (i = 0; i < dnum; i++) {
    if (indat[i] > max) max = indat[i];
    if (indat[i] < min) min = indat[i];
  }

  if ( GpmCont.zMode == 0 ) {
    GpmCont.zMin = rmin = min;
    GpmCont.zMax = rmax = max;
  } else {
    rmin = GpmCont.zMin;
    rmax = GpmCont.zMax;
/*
    if ( GpmCont.zType == 1 ) {
      rmin = ( rmin > 0.0 )? log10(rmin) : 0.0;
      rmax = ( rmax > 0.0 )? log10(rmax) : 0.0;
    }
*/
  }
  
  hx = GpmCont.xSize / (double) nx;
  hy = GpmCont.ySize / (double) ny;
  
  if ( xyset == 1) {
    if (hx > hy)
      hx = hy;
    else
      hy = hx;
  }

  if ( rmin == rmax ) {
    rmin -= 0.5;
    rmax += 0.5;
  }

  printf("  Matrix Size  %d x %d\n", nx, ny);
  printf("  (scale: min = %g, max = %g,", rmin, rmax);
  printf(" data: min = %g, max = %g)\n", min, max);
  
  gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device, GpmCont.winNum);
  gpen(GpmCont.gLineWidth, GpmCont.gLineType, 0);
  gnewpen(GpmCont.gColor);
  gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
  gfactor(GpmCont.factor);

  if ( dmode > 7 )
    creategradation( dmode-8 );

  for ( j = startp; j < endp; j+=step ) {
    tmp = data[j];
    if ( dim == 3 ) {
      if ( j + step > endp )
	GpmCont.device = rest_device;
      store_start_time();
    }
    if ( dmode > 0 && dmode < 8 ) {
      gnewpen(0);
      gbox(0, 0, GpmCont.xSize, GpmCont.ySize, 3, -1.0);
      gnewpen(GpmCont.gColor);
    }

    switch ( dmode ) {
    case 1:/* size */
      for (ix = 0; ix < nx; ix++) {
	for (iy = 0; iy < ny; iy++) {
	  i = ix*p1 + iy*p2;
	  a = tmp[i];
	  if ( a < 0.0 ) {
	    gnewpen(GpmCont.fColor);
	    size = norm( a,0.0,rmin);
	  } else {
	    gnewpen(GpmCont.gColor);
	    size = norm( a,0.0, rmax);
	  }
	  if (size <= 0.0) continue;
	  if (size >  1.0) size = 1.0;
	  k = ( viewpoint > 0 ) ? iy : ( ny - iy -1 );
	  level = size;
	  fillmode = 3;
	  draw_box_( ix, k, size, hx, hy, fillmode, level );
	}
      }
      break;

    case 2:/* size & color */
      for (ix = 0; ix < nx; ix++) {
	for (iy = 0; iy < ny; iy++) {
	  i = ix*p1 + iy*p2;
	  a = tmp[i];
	  if ( a < 0.0) {
	    size = norm( a,0.0, rmin);
	  } else {
	    size = norm( a,0.0, rmax);
	  }
	  if (size <= 0.0) continue;
	  if (size >  1.0) size = 1.0;
	  k = ( viewpoint > 0 ) ? iy : ny - iy -1;
	  level = norm( a, rmin, rmax);
	  grainbow(level);
	  fillmode = 2;
	  draw_box_( ix, k, size, hx, hy, fillmode, level );
      }
    }
    break;
	
    case 3:/* normalized size */
    case 4:/* normalized size (inverse) */
      for (ix = 0; ix < nx; ix++) {
	for (iy = 0; iy < ny; iy++) {
	  i = ix*p1 + iy*p2;
	  a = tmp[i];
	  size = level = norm( a, rmin, rmax);
	  if (size <= 0.0) continue;
	  if (size >  1.0) size = 1.0;
	  if ( dmode == 3) fillmode = 2;
	  else             fillmode = 1;
	  k = ( viewpoint > 0 ) ? iy : ny - iy -1;
	  level = size;
	  draw_box_( ix, k, size, hx, hy, fillmode, level );
	}
      }
      break;
	
    case 5:/* normalized size & color */
      for (ix = 0; ix < nx; ix++) {
	for (iy = 0; iy < ny; iy++) {
	  i = ix*p1 + iy*p2;
	  a = tmp[i];
	  size = level = norm(a, rmin, rmax);
	  if (size <= 0.0) continue;
	  if (size >  1.0) size = 1.0;
	  grainbow(level);
	  fillmode = 2;
	  k = ( viewpoint > 0 ) ? iy : ny - iy -1;
	  level = size;
	  draw_box_( ix, k, size, hx, hy, fillmode, level );
	}
      }
      break;
	
    case 6: /* data>0: open,   data<0: fill */
    case 7:/* data>0: fill,   data<0: open */
      for (ix = 0; ix < nx; ix++) {
	for (iy = 0; iy < ny; iy++) {
	  i = ix*p1 + iy*p2;
	  a = tmp[i];
	  if (a < 0.0) {
	    flag = 1;
	    size = norm( a, 0.0, rmin);
	  } else {
	    flag = 0;
	    size = norm( a, 0.0, rmax);
	  }
	  if (size <= 0.0) continue;
	  if (size >  1.0) size = 1.0;
	  level = size;
	  
	  gnewpen(GpmCont.gColor);
	  fillmode = 1;
	  if ( dmode == 6) {
	    if (flag == 1) fillmode = 3;
	  } else {
	    if (flag == 0) fillmode = 3;
	  }
	  k = ( viewpoint > 0 ) ? iy : (ny - iy -1);
	  draw_box_( ix, k, size, hx, hy, fillmode, level );
	}
      }
      break;
      
    case 0: /* Rainbow Color */
      for (ix = 0; ix < nx; ix++) {
	for (iy = 0; iy < ny; iy++) {
	  i = ix*p1 + iy*p2;
	  a = tmp[i];
	  level = norm(a, rmin, rmax);
	  grainbow(level);
	  size = 1.0;
	  fillmode = 2;
	  k = ( viewpoint > 0 ) ? iy : ny - iy -1;
	  draw_box_( ix, k, size, hx, hy, fillmode, level );
	}
      }
      break;
      
    default: /* Gradation */
      for (ix = 0; ix < nx; ix++) {
	for (iy = 0; iy < ny; iy++) {
	  i = ix*p1 + iy*p2;
	  a = tmp[i];
	  level = norm( a, rmin, rmax);
	  gradation(level);
	  size = 1.0;
	  fillmode = 2;
	  k = ( viewpoint > 0 ) ? iy : ny - iy -1;
	  draw_box_( ix, k, size, hx, hy, fillmode, level );
	}
      }
      break;
    }
    if ( dim == 3 ) {
      gflush();
      printf("\r[%6d]",j); fflush(stdout);
      wait_msec( wait_time );
    }
  }    

  if ( dim == 3 )
    printf("\n");

  gclose();
  GpmCont.device = rest_device;
  wrgpm();
  write_syscom();
  return 0;
}

static double
norm(data, amin, amax)
    double data;
    double amin, amax;
{
  double level;
  
  level = (data - amin) / (amax - amin);
  if (level > 1.0)
    level = 1.0;
  else if (level < 0.0)
    level = 0.0;

  return (level);
}

static int
draw_box_( ix, iy, size, hx, hy, fillmode, level )
    int ix, iy;
    double size, hx, hy;
    int fillmode;
    double level;
{
  double x, y, lx, ly;
  
  x = ((double) ix + 0.5 - size*0.5) * hx;
  y = ((double) iy + 0.5 - size*0.5) * hy;
  lx = hx * size;
  ly = hy * size;
  gbox(x, y, x + lx, y + ly, fillmode, level);

  return 0;
}


static void
creategradation( c )
    int c;
{
  double	 level;
  int	 i, n, maxcols;
  int	div      = RAINBOW_DIVNUM;
  int	basecol  = RAINBOW_BASECOL;
  
  if ( c < 0 || c > 6 ) return;
  
  if ( gpm_depth >= 8 ) {
    maxcols = div*basecol;
    n = 1;
    for ( i = 0; i < maxcols; i++, n++ ) {
      level = (double)n / (double)maxcols;
      setMonoCols( n-1, level, c );
    }
    setMonoCols(n-1, 1.0, c );

  } else if ((gpm_depth == 4) || (gpm_depth == 1)) {
    gpm_rainbow[0] = gpm_color[1];
    gpm_rainbow[1] = gpm_color[5];
    gpm_rainbow[2] = gpm_color[4];
    gpm_rainbow[3] = gpm_color[6];
    gpm_rainbow[4] = gpm_color[2];
    gpm_rainbow[5] = gpm_color[2];
  }
}

static void
setMonoCols( n, x, c )
    int n, c;
    double x;
{
  int	 status;
  XColor rainbow;
  static int t[3][7] = {
    { 1, 0, 1, 0, 1, 0, 1 },
    { 0, 1, 1, 0, 0, 1, 1 },
    { 0, 0, 0, 1, 1, 1, 1 } };

  x = ( x > 0.0 ) ?  65535 * sqrt(x) : 0;

  rainbow.blue  = t[0][c] ? x : 0 ;
  rainbow.red   = t[1][c] ? x : 0 ;
  rainbow.green = t[2][c] ? x : 0 ;
  
  rainbow.flags = flags;
  if (gpm_display != NULL) 
    status = XAllocColor(gpm_display, gpm_cmap, &rainbow);
  gpm_rainbow[n] = rainbow.pixel;
}

static void
gradation(level)
     double level;	/* 0.0 <= level <= 1.0 */
{
  int n;
  int div     = RAINBOW_DIVNUM;
  int basecol = RAINBOW_BASECOL;

  if ((level >= 0.0) && (level <= 1.0)) {
    n = (int) ( level * div * basecol);
    mpen.rainbow = (char) n + 1;
    if (gpm_display != NULL) {
      if (( gpm_depth == 8 ) || ( gpm_depth == 24 ))
	XSetForeground(gpm_display, gpm_gc, gpm_rainbow[n]);
      else if (gpm_depth == 4) {
	n /= div;
	XSetForeground(gpm_display, gpm_gc, gpm_rainbow[n]);
      } else
	set_tile_pattern (gpm_display, gpm_screen, gpm_window, gpm_gc, level);
    }
  } else
    if (gpm_display != NULL)
      XSetForeground(gpm_display, gpm_gc, gpm_color[7]);
}
