/************************************************
*                                               *
*        SET PEN COLOR                          *
*                                               *
*************************************************
*                                               *
*        COLOR  I1, I2                          *
*-----------------------------------------------*
*                                               *
*        I1   : GRAPH COLOR                     *
*        I2   : AXIS and FRAME COLOR            *
*                                               *
*        COLOR                                  *
*         0 : BLACK                             *
*         1 : BLUE                              *
*         2 : RED                               *
*         3 : MAGENTA                           *
*         4 : GREEN                             *
*         5 : SKY BLUE                          *
*         6 : YELLOW                            *
*         7 : WHITE                             *
*                                               *
*************************************************
*                                               *
*        S.HITOMI         02/13/92              *
*                                               *
************************************************/
#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"

typedef struct {
  char *name;
  int  no;
} Color;

Color           color[] = {
#ifdef WHITE_BGCOLOR
  {"white"  , 0}, {"blue" , 1}, {"red"    , 2}, {"magenta", 3},
  {"green"  , 4}, {"cyan" , 5}, {"skyblue", 5}, {"yellow" , 6},
  {"black"  , 7}, {"WHITE", 0}, {"BLUE"   , 1}, {"RED"    , 2},
  {"MAGENTA", 3}, {"GREEN", 4}, {"CYAN"   , 5}, {"SKYBLUE", 5},
  {"YELLOW" , 6}, {"BLACK", 7},
#else
  {"black"  , 0}, {"blue" , 1}, {"red"    , 2}, {"magenta", 3},
  {"green"  , 4}, {"cyan" , 5}, {"skyblue", 5}, {"yellow" , 6},
  {"white"  , 7}, {"BLACK", 0}, {"BLUE"   , 1}, {"RED"    , 2},
  {"MAGENTA", 3}, {"GREEN", 4}, {"CYAN"   , 5}, {"SKYBLUE", 5},
  {"YELLOW" , 6}, {"WHITE", 7},
#endif /* WHITE_BGCOLOR */
  {"gray1",   8}, {"gray2", 9}, {"gray3",  10},
  {"GRAY1",   8}, {"GRAY2", 9}, {"GRAY3",  10},
  {NULL,    0}
};


int
main()
{
  int  number[2];
  char *name[2];
  int  i, n;
  
  /* LOAD SYSTEM PARAMETER */
  read_syscom();
  regpm();

  name  [0] =      GetString(0);
  name  [1] =      GetString(1);
  number[0] = (int)GetScalar(0);
  number[1] = (int)GetScalar(1);

  for (i = 0; i < 2; i++)
    for (n = 0; color[n].name != NULL; n++)
      if ( name[i] != NULL && strcmp(name[i], color[n].name) == 0 ) {
	number[i] = color[n].no;
	break;
      }
  
  for (i = 0; i < 2; i++) {
    if (number[i] < 0 )
      exit(2);      
    else
      number[i] %= MAX_COLOR;
  }
  
  GpmCont.gColor = number[0];
  GpmCont.fColor = number[1];
  
  write_syscom();
  wrgpm();
  return 0;
}
  
