#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"

/*************************
    noise.c
    
    coded by Takashi KODERA

    March 9th, 1992
    
**************************/

extern void wait_msec2 _ANSI_ARGS_((int waittime));
  
int
main()
{
#if !defined(SYSV) && !defined(SVR4)
  double norm=2147483648.0;
#else
  double norm=32767.0;
#endif

  double value;
  int colorflag;
  int x,y;
  int size;
  int xnum, ynum, loop, num, wnum;

  read_syscom() ;
  regpm() ;

  xnum = (int)GetScalar(0);
  ynum = (int)GetScalar(1);
  size = (int)GetScalar(2);
  loop = (int)GetScalar(3);
  wnum = (int)GetScalar(4);

  xnum = ( xnum > 0 ) ? xnum : 13;
  ynum = ( ynum > 0 ) ? ynum : 13;
  size = ( size > 0 ) ? size : 10;
  loop = ( loop > 0 ) ? loop : 100;
  wnum = ( wnum > 0 ) ? wnum : 100;
  
  GpmCont.device = 0;
  gopen( GpmCont.paper, GpmCont.orientation, GpmCont.device,
	GpmCont.winNum ) ;
  gnewpen( GpmCont.fColor ) ;
  gpen( GpmCont.fLineWidth, GpmCont.fLineType, 0) ;
  gorigin( GpmCont.xOrigin, GpmCont.yOrigin ) ;
  gfactor( GpmCont.factor ) ;

  colorflag=0;
#ifdef WHITE_BGCOLOR
  XSetForeground(gpm_display,gpm_gc,
		 BlackPixel(gpm_display,gpm_screen));
#else
  XSetForeground(gpm_display,gpm_gc,
		 WhitePixel(gpm_display,gpm_screen));
#endif /* WHITE_BGCOLOR */
  num=0;
  while (num<loop) {

    for (x=0; x<xnum; x++) {
      for (y=0; y<ynum; y++) {

	value=1.0*(double)rand()/norm;

	if ((value<0.5)&&(colorflag==1)) {

#ifdef WHITE_BGCOLOR
	  XSetForeground(gpm_display,gpm_gc,
			 BlackPixel(gpm_display,gpm_screen));
#else
	  XSetForeground(gpm_display,gpm_gc,
			 WhitePixel(gpm_display,gpm_screen));
#endif /* WHITE_BGCOLOR */
	  colorflag=0;
	}
	else if ((value<0.5)&&(colorflag==0)) {

#ifdef WHITE_BGCOLOR
	  XSetForeground(gpm_display,gpm_gc,
			 WhitePixel(gpm_display,gpm_screen));
#else
	  XSetForeground(gpm_display,gpm_gc,
			 BlackPixel(gpm_display,gpm_screen));
#endif /* WHITE_BGCOLOR */
	  colorflag=1;
	}

	gbox((double)(x*size),(double)(y*size),
	     (double)(x*size+size),(double)(y*size)+size, 3, -1.0);
      } 
    }
    num++;
    gflush();
    wait_msec2(wnum);
  }

  gclose();
  write_syscom() ;
  return 0;
}
