#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
  
int main()
{
  int   num;
  int   result;
  int   div     = RAINBOW_DIVNUM;
  int   basecol = RAINBOW_BASECOL;
  int   lwidth, ltype, lcolor, lrainbow, lmode;
  static int   preColor=-1, preRainbow=0, preType=-1, preWidth=-1; 
  int   rollflag = 0;
  int   pages = 1;
  char  *gpm_dvifile;
  
  read_syscom();
  regpm();

  if ( GetArgNum() != 0 ) {
    gpm_dvifile = GetString(0);
    strcpy( GpmCont.dvifile, gpm_dvifile );
  } else {
    strcpy( GpmCont.dvifile, "GPMDVIFILE1" );
    gpm_dvifile = GpmCont.dvifile;
  }  

  opendvi_for_read();
  if ( readdvihead() == -1 ) {
    exit(33);
  }

  printf("Preview of %s\n", gpm_dvifile );
  
  lseek( dvi_fd, strlen(gpm_head) + 5, 0 );

  GpmCont.device = 0;

  gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device, GpmCont.winNum);
  gerase();
  
  printf("Page %2d: ", pages), fflush(stdout);

  do {
    
    result = readgpm();
    
    if (result > 0 ) {
      
      if ( rollflag == 1 ) {
	printf(" press return >> next page."), fflush(stdout);
	gflush();
	getchar();
	gerase();
	printf("Page %2d: ",++pages), fflush(stdout);
	rollflag = 0;
      }
      
      gfactor((double)gpm_param.factor);
      gorigin((double)gpm_param.xorg, (double)gpm_param.yorg);

      do {

	num = readdvi();

	if (num > 0) {
	  switch (num) {
	  case NPLOT:
	    lwidth = (int) gpm_plot.lwidth;
	    ltype  = (int) gpm_plot.ltype;
	    lcolor = (int) gpm_plot.color;
	    lrainbow = (int) gpm_plot.rainbow;
	    lmode  = (int) gpm_plot.ipen_mode;
	    if ( preWidth != lwidth || preType != ltype ) {
	      gpen(lwidth, ltype, 0);
	      preWidth = lwidth;
	      preType  = ltype;
	    }
	    if ( preColor != lcolor || preRainbow != lrainbow ) {
	      if (lcolor != -1)
		gnewpen(lcolor);
	      else
		grainbow(((float)lrainbow/(float)(div*basecol)));
	      preColor = lcolor;
	      preRainbow = lrainbow;
	    }
	    plot(gpm_plot.x, gpm_plot.y, lmode);
	    break;
	    
	  case NBOX:
	    lwidth = (int) gpm_box.lwidth;
	    ltype  = (int) gpm_box.ltype;
	    lcolor = (int) gpm_box.color;
	    lmode  = (int) gpm_box.mode;

	    gpen(lwidth, ltype, 0);
	    if (lcolor == -1 && gpm_box.level >= 0.0)
	      grainbow(gpm_box.level);
	    else
	      gnewpen(lcolor);

	    box(gpm_box.x1, gpm_box.y1, gpm_box.x2, gpm_box.y2,
		gpm_box.mode, gpm_box.level);
	    break;
	    
	  case NCSYMBOL:
	    lcolor = (int) gpm_csymbol.color;
	    gnewpen(lcolor);
	    
	    msymbol.cdata  = gpm_csymbol.cdata;
	    msymbol.theta  = gpm_csymbol.theta;
	    msymbol.height = gpm_csymbol.height;
	    
	    csymbol(gpm_csymbol.x, gpm_csymbol.y);
	    break;
	    
	  case NLABEL:
	    lcolor = (int) gpm_label.color;
	    gnewpen(lcolor);
	    
	    label(gpm_label.x, gpm_label.y, gpm_label.ichar,
		  gpm_label.height, gpm_label.theta, gpm_label.mode);
	    break;

	  case NROLL:
	    printf("done. "), fflush(stdout);
	    rollflag = 1;
	    break;
	  }
	}
      } while (num > 0);
    }
  } while (result > 0);
  
  printf("done.\n");
  gflush();
  closedvi();

  return 0;
}
