#include <stdio.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"


int
main( argc, argv )
    int argc;
    char *argv[];
{
  int num;
  int result;

  if ( argc == 2 )
    strcpy( GpmCont.dvifile, argv[1] );
  else
    strcpy( GpmCont.dvifile, "GPMDVIFILE1");

  opendvi();
  if ( readdvihead() == -1 )
    exit(33);

  printf("paper:=%d\n"      ,mdev.number);
  printf("orientation:=%d\n",mdev.irotate);
  printf("device:=%d\n",     mdev.todvi);


  lseek( dvi_fd, strlen(gpm_head)+5L, 0 );

  do {
    result=readgpm();

    if ( result != 0 ) {
      printf("endmark:=%d\n"     ,(int)gpm_param.endmark);
      printf("factor :=%f\n"     ,(float)gpm_param.factor);
      printf("origin :=(%f,%f)\n",(float)gpm_param.xorg,
	     (float)gpm_param.yorg);
      
      do {

	num=readdvi();

	if (num>0) {

	  switch (num) {

	  case 1:
	    printf("plot    ");
	    printf("(x,y,ipen_mode,color,rainbow,ltype,lwidth)=");
	    printf("(%f,%f,%d,%d,%d,%d,%d)\n",
		   gpm_plot.x,gpm_plot.y,gpm_plot.ipen_mode,
		   gpm_plot.color,gpm_plot.rainbow,gpm_plot.ltype,
		   gpm_plot.lwidth);
	    break;
	  case 2:
	    printf("box     ");
	    printf("(x1,y1,x2,y2,mode,level,color,line)=");
	    printf("(%f,%f,%f,%f,%d,%f,%d,%d,%d)\n",
		   gpm_box.x1,gpm_box.y1,gpm_box.x2,gpm_box.y2,gpm_box.mode,
		   gpm_box.level,gpm_box.color,gpm_box.ltype,gpm_box.lwidth);
	    break;
	  case 3:
	    printf("csymbol ");
	    printf("(x,y,cdata,height,itheta,color)=(%f,%f,%3d,%f,%f,%d)\n",
		   gpm_csymbol.x,gpm_csymbol.y,gpm_csymbol.cdata,
		   gpm_csymbol.height,gpm_csymbol.theta,gpm_csymbol.color);
	    break;
	  case 4:
	    printf("label   ");
	    printf("(x,y,ichar,height,itheta,imode,color,font)=");
	    printf("(%f,%f,%s,%f,%f,%d,%d,%d)\n",
		   gpm_label.x,gpm_label.y,gpm_label.ichar,gpm_label.height,
		   gpm_label.theta,gpm_label.mode,gpm_label.color,
		   gpm_label.font);
	    break;
	  }
	}
      } while (num>0);
    }
  } while (result>0);

  closedvi();
  return 0;
}
