#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"

int
sc_type( s )
    char *s;
{
  int type;
  
  if      ( *s == 'N' ) type = 0;
  else if ( *s == 'L' ) type = 1;
  else exit(2);

  return type;
}


int
sc_mode( s )
    char *s;
{
  int mode;
  
  if      ( *s == 'A' ) mode = 1;
  else if ( *s == 'F' ) mode = 2;
  else if ( *s == 'D' ) mode = 3;
  else exit(2);

  return mode;
}

int
token_s(r_code, rnum)
     int     *r_code;
     double  *rnum;
{
  char    str[40];
  
  (void) fgets(str,40,stdin);
  if (strlen(str) == 0) *r_code = 2;
  else                  *r_code = sscanf(str, "%lf", rnum);
  return 0;
}

int
set_minmax( str, arg, narg, mind, maxd, min, max )
    char  str;
    int    arg, narg;
    double  mind, maxd;
    float *min, *max;
{
  int   itype;
  double rnum;
  
  while (1) {
    if ( narg > arg ) 
	*min = mind;
    else {
      printf("%c -- MIN = %f    ", str, *min);
      fflush(stdout);
      token_s(&itype, &rnum);
      if (itype == 1)
	*min = rnum;
    }
    if ( narg > arg+1 )
	*max = maxd;
    else {
      printf("%c -- MAX = %f    ", str, *max);
      fflush(stdout);
      token_s(&itype, &rnum);
      if (itype == 1)
	*max = rnum;
    }
    if (*min < *max)
      break;
    else
      arg = narg;
  }
  return 0;
}
    

int
main()
{
  int     i, zflag, args, flag = 0;
  int     ityp[3], iscl[3], needs[3];
  float   *min[3], *max[3];
  float   rnumer[6], tmp;
  char   *ialpha[6], *atype[6];
  static char str[] = { 'X', 'Y', 'Z' };
    
  /***** Load System Parameter *****/
  read_syscom();
  regpm();

  for (i=0; i<6; i++) rnumer[i] = 0.0;
  /***** Get Parameter *****/
  args = GetArgNum();
  for ( i = 0; i < args && i < 6; i++ ) {
    atype [i] = GetArgType(i);
    ialpha[i] = GetString(i);
  } 
  zflag = (args >= 6) ? (!strcmp(atype[4],"string")) : 0;

  for ( i = 0; i < 6; i++ )
    rnumer[i] = 0.0;
  
  if ( !zflag ) {
    if ( args >= 6 ) {
      rnumer[0] = rnumer[2] = (float)GetScalar(4);
      rnumer[1] = rnumer[3] = (float)GetScalar(5);
      if ( args > 6 ) {
	rnumer[2] = (float)GetScalar(6);
	rnumer[3] = (float)GetScalar(7);
      }
    }
  } else {
    if ( args >= 8 ) {
      rnumer[0] = rnumer[2] = rnumer[4] = (float)GetScalar(6);
      rnumer[1] = rnumer[3] = rnumer[5] = (float)GetScalar(7);
      if ( args >= 10 ) {
	rnumer[2] = rnumer[4] = (float)GetScalar(8);
	rnumer[3] = rnumer[5] = (float)GetScalar(9);
	if ( args > 10 ) {
	  rnumer[4] = (float)GetScalar(10);
	  rnumer[5] = (float)GetScalar(11);
	}
      }
    }
  }
  
  /***** Set Parameter *****/
  ityp[0] = GpmCont.xType = sc_type(ialpha[0]);
  ityp[1] = GpmCont.yType = sc_type(ialpha[2]);

  iscl[0] = sc_mode(ialpha[1]);
  iscl[1] = sc_mode(ialpha[3]);

  if ( zflag ) {
    ityp[2] = GpmCont.zType = sc_type(ialpha[4]);
    iscl[2] = sc_mode(ialpha[5]);
  } else {
    ityp[2] = GpmCont.zType;
    iscl[2] = GpmCont.zMode ? 3 : 1;
  }    

  GpmCont.xMode    = ( iscl[0] == 1 ) ? 0 : 1 ;
  GpmCont.yMode    = ( iscl[1] == 1 ) ? 0 : 1 ;
  GpmCont.zMode    = ( iscl[2] == 1 ) ? 0 : 1 ;
  GpmCont.axisType = ityp[1]*2 + ityp[0];
  
  needs[0] = (zflag)? 6: 4;
  needs[1] = needs[0]+(iscl[0]==2)*2;
  needs[2] = needs[0]+(iscl[0]==2)*2+(iscl[1]==2)*2;
  
  if (iscl[0]*iscl[1]*iscl[2] != 1) {
    
    /***** Set Scale Data *****/
    min[0] = &(GpmCont.xMin);
    max[0] = &(GpmCont.xMax);
    min[1] = &(GpmCont.yMin);
    max[1] = &(GpmCont.yMax);
    min[2] = &(GpmCont.zMin);
    max[2] = &(GpmCont.zMax);
    
    /***** Set Scale Data *****/
    
    for ( i = 0; i < 3;) {
      if ( ityp[i] == 1 && iscl[i] != 3 && flag == 0 ) {
	*min[i] = (*min[i] > 0.0 ) ? (float)log10((double)*min[i]) : -1.0;
	*max[i] = (*max[i] > 0.0 ) ? (float)log10((double)*max[i]) :  0.0;
	if ( *min[i] == *max[i] )
	 *min[i] = *max[i] - 1.0;
        if ( *min[i] > *max[i] ) {
          tmp = *min[i]; *min[i] = *max[i]; *max[i] = tmp;
        }
      }
      if ( iscl[i] == 2 ) {
	set_minmax(str[i], needs[i], args,
		   rnumer[i*2], rnumer[i*2+1],
		   min[i], max[i] );
      }
      if ( ityp[i] == 1 && iscl[i] != 3 ) {
	if ( fabs((double)*max[i]) < 38.0 && fabs((double)*min[i]) < 38.0 ) {
	  *max[i] = (float)pow(10.0,(double)*max[i]);
	  *min[i] = (float)pow(10.0,(double)*min[i]);
	  flag = 0;
	} else {
	  flag = -1;
	  if ( args >= needs[i] ) {
	    if ( fabs(*max[i]) > 37.0 )
	      fprintf(stderr, "*** 10^(%g) is out of domain of Log scale.\n",
		*max[i]);
	    if ( fabs(*min[i]) > 37.0 )
	      fprintf(stderr, "*** 10^(%g) is out of domain of Log scale.\n",
		*min[i]);
	    exit(2);
          }
        }
      }
      if (flag == 0)
	i++;
    }
  }    

  wrgpm();
  write_syscom();
  return 0;
}


